//***************************************************************************
//
// ImgView.h
//
//***************************************************************************

DEFINE_GUID (CLSID_FileViewer, 0x8e74e20a, 0x0f1a, 0x11aa, 0xbc, 0xb0,
    0x11, 0xfd, 0x0e, 0xab, 0xcd, 0x6c);

/////////////////////////////////////////////////////////////////////////////
// Nonmember function prototypes

STDAPI DllGetClassObject (REFCLSID, REFIID, LPVOID*);
STDAPI DllCanUnloadNow ();

LRESULT CALLBACK MainWndProc (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK ViewWndProc (HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK AboutDlgProc (HWND, UINT, WPARAM, LPARAM);

void SizeWindowToImage (HWND, BITMAPHANDLE*);
void ResizeView (HWND, HWND, int, int);
void RecordStatusBarPreference (BOOL);
BOOL PreferStatusBarHidden ();

/////////////////////////////////////////////////////////////////////////////
// Class factory class

class CClassFactory : public IClassFactory
{
private:
    ULONG m_cRef;
    
public:
    CClassFactory ();
    ~CClassFactory ();
        
    // IUnknown methods
    STDMETHODIMP            QueryInterface (REFIID, LPVOID*);
    STDMETHODIMP_(ULONG)    AddRef ();
    STDMETHODIMP_(ULONG)    Release ();
    
    // IClassFactory methods
    STDMETHODIMP CreateInstance (LPUNKNOWN, REFIID, LPVOID*);
    STDMETHODIMP LockServer (BOOL);
};

/////////////////////////////////////////////////////////////////////////////
// File viewer class

class CFileViewer : public IFileViewer, IPersistFile
{
private:
    ULONG   m_cRef;
    char    m_szFile[MAX_PATH];
    BOOL    m_bShowInitializeCalled;
    HWND    m_hWnd;

public:
    CFileViewer ();
    ~CFileViewer ();

    // IUnknown methods
    STDMETHODIMP            QueryInterface (REFIID, LPVOID*);
    STDMETHODIMP_(ULONG)    AddRef ();
    STDMETHODIMP_(ULONG)    Release ();
    
    // IFileViewer methods
    STDMETHODIMP PrintTo (LPSTR, BOOL);
    STDMETHODIMP ShowInitialize (LPFILEVIEWERSITE);
    STDMETHODIMP Show (LPFVSHOWINFO);

    // IPersistFile methods
    STDMETHODIMP IsDirty ();
    STDMETHODIMP Load (LPCOLESTR, DWORD);
    STDMETHODIMP Save (LPCOLESTR, BOOL);
    STDMETHODIMP SaveCompleted (LPCOLESTR);
    STDMETHODIMP GetCurFile (LPOLESTR*);
    STDMETHODIMP GetClassID (LPCLSID);

    // Other functions    
    BOOL LoadImage (LPSTR);
};
