Option Explicit

Type TopicRecord
    szTopicTitle As String
    lTopicNum As Long
End Type

Global gblhTitle As Integer                 'Handle to the MediaView title
Global gblhTList As Integer                 'Handle to a topic list (used to pass a topic
					    'list from the search form to the results form
Global gblbSearchActive As Integer          'Is a Search active?
Global gblbHistoryActive As Integer         'Is History form loaded?
Global gblbIndexActive As Integer           'Is Index form loaded?
Global gbllpHighLight As Integer            'Pointer to current search hit highlight structure
Global gbllCurTextColor As Long             'Current text color
Global gblhHiliteBrush As Integer           'Handle to current search hit highlight brush
Global gblCurHiliteColor As Long            'Current search hit highlight color
Global gblnNumMenuBookmarks As Integer      'Number of bookmarks on Bookmarkmenu

Global gblarHistoryList() As TopicRecord    'Array for history list

Global Const PRINT_ALL = 0
Global Const PRINT_CURTOPIC = 1
Global Const PRINT_MARKED = 2

Global Const MAX_HISTORYLIST = 50           'Maximum nuber of items to keep in history array
Global Const MAX_BACKLIST = 500             'Maximum number of topics to keep in back list box
Global Const MAX_BOOKMARKMENU = 9           'Maximum number of bookmark to show on bookmark menu

Global Const BAGGAGEFILE_EXT = ".MVX"       'File extension for MVP file loaded as baggage within M12
Global Const BOOKMARKFILE_EXT = ".BMK"      'File extension for bookmark file

'Error constants
Global Const ERR_BASE = 0
Global Const ERR_CREATEOBJECT = ERR_BASE + 1
Global Const ERR_OPENCLIPBOARD = ERR_BASE + 2
Global Const ERR_SETCLIPBOARDDATA = ERR_BASE + 2
Global Const ERR_READBMKFILE = ERR_BASE + 3
Global Const ERR_NOSELECTEDTEXT = ERR_BASE + 4
Global Const ERR_TLFATAL = ERR_BASE + 5
Global Const ERR_TLCREATE = ERR_BASE + 6
Global Const ERR_TLCOMBINE = ERR_BASE + 7
Global Const ERR_NOMARKEDTOPICS = ERR_BASE + 8
Global Const ERR_BADVA = ERR_BASE + 9
Global Const ERR_BADADDRESS = ERR_BASE + 10
Global Const ERR_NOGROUPS = ERR_BASE + 11
Global Const ERR_BADKEYCOUNT = ERR_BASE + 12
Global Const ERR_BADKEYGETADDRESS = ERR_BASE + 13
Global Const ERR_TOPICTITLE = ERR_BASE + 14
Global Const ERR_WRITEBOOKMARK = ERR_BASE + 15
Global Const ERR_UPDATESR = ERR_BASE + 16
Global Const ERR_UPDATENSR = ERR_BASE + 17
Global Const ERR_NOTOPICS = ERR_BASE + 18
Global Const ERR_WWOPEN = ERR_BASE + 19
Global Const ERR_WWLOOKUP = ERR_BASE + 20
Global Const ERR_NOKEYWORDSINTITLE = ERR_BASE + 21
Global Const ERR_NOKEYWORDS = ERR_BASE + 22
Global Const ERR_NO0ORNEG = ERR_BASE + 23
Global Const ERR_LESSTHAN1000 = ERR_BASE + 24
Global Const ERR_WHOLENUM = ERR_BASE + 25
Global Const ERR_TLLOOKUP = ERR_BASE + 26

'Windows API's
' SetWindowPos() and WINDOWPOS flag
Global Const SWP_NOSIZE = &H1
Global Const SWP_NOMOVE = &H2
Global Const SWP_NOZORDER = &H4
Global Const SWP_NOREDRAW = &H8
Global Const SWP_NOACTIVATE = &H10
Global Const SWP_FRAMECHANGED = &H20    ' The frame changed: send WM_NCCALCSIZE
Global Const SWP_SHOWWINDOW = &H40
Global Const SWP_HIDEWINDOW = &H80
Global Const SWP_NOCOPYBITS = &H100
Global Const SWP_NOOWNERZORDER = &H200  ' Don't do owner Z ordering
Global Const SWP_DRAWFRAME = SWP_FRAMECHANGED
Global Const SWP_NOREPOSITION = SWP_NOOWNERZORDER
Global Const SWP_NOSENDCHANGING = &H400
Global Const SWP_DEFERERASE = &H2000
' SetWindowPos() hwndInsertAfter field values
Global Const HWND_TOP = 0
Global Const HWND_BOTTOM = 1
Global Const HWND_TOPMOST = -1
Global Const HWND_NOTOPMOST = -2

Global Const LF_FACESIZE = 32
Global Const FW_DONTCARE = 0
Global Const FW_NORMAL = 400
Global Const FW_BOLD = 700
Global Const GW_CHILD = 5
Global Const R2_XORPEN = 7  '  DPx
Global Const HORZRES = 8    '  Horizontal width in pixels
Global Const VERTRES = 10   '  Vertical width in pixels
Global Const LOGPIXELSX = 88    '  Logical pixels/inch in X
Global Const LOGPIXELSY = 90    '  Logical pixels/inch in Y
Global Const WM_USER = &H400
Global Const LB_SETTABSTOPS = (WM_USER + 19)
Global Const GWW_HWNDPARENT = (-8)

Type RECT
    Left As Integer
    Top As Integer
    Right As Integer
    Bottom As Integer
End Type

Type LOGFONT
    lfHeight As Integer
    lfWidth As Integer
    lfEscapement As Integer
    lfOrientation As Integer
    lfWeight As Integer
    lfItalic As String * 1
    lfUnderline As String * 1
    lfStrikeOut As String * 1
    lfCharSet As String * 1
    lfOutPrecision As String * 1
    lfClipPrecision As String * 1
    lfQuality As String * 1
    lfPitchAndFamily As String * 1
    lfFaceName As String * LF_FACESIZE
End Type

Type RGBTRIPLE
    rgbtBlue As String * 1
    rgbtGreen As String * 1
    rgbtRed As String * 1
End Type

Type TEXTMETRIC
    tmHeight As Integer
    tmAscent As Integer
    tmDescent As Integer
    tmInternalLeading As Integer
    tmExternalLeading As Integer
    tmAveCharWidth As Integer
    tmMaxCharWidth As Integer
    tmWeight As Integer
    tmItalic As String * 1
    tmUnderlined As String * 1
    tmStruckOut As String * 1
    tmFirstChar As String * 1
    tmLastChar As String * 1
    tmDefaultChar As String * 1
    tmBreakChar As String * 1
    tmPitchAndFamily As String * 1
    tmCharSet As String * 1
    tmOverhang As Integer
    tmDigitizedAspectX As Integer
    tmDigitizedAspectY As Integer
End Type

Type DOCINFO 'Size is 10 bytes
    cbSize As Integer
    lpszDocName As Long
    lpszOutput As Long
End Type

Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hwndInsertAfter As Integer, ByVal x As Integer, ByVal y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)

Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer

Declare Function GetProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer
Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, lpRect As RECT)
Declare Sub InvalidateRect Lib "User" (ByVal hWnd As Integer, lpRect As Any, ByVal bErase As Integer)
Declare Sub UpdateWindow Lib "User" (ByVal hWnd As Integer)

Declare Function GetWindow Lib "User" (ByVal hWnd As Integer, ByVal wCmd As Integer) As Integer

Declare Function GetDC Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function ReleaseDC Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer

Declare Function GetTextMetrics Lib "GDI" (ByVal hDC As Integer, lpMetrics As TEXTMETRIC) As Integer

Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer

Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer

Declare Function StartDoc Lib "GDI" (ByVal hDC As Integer, lpdi As DOCINFO) As Integer
Declare Function EndDocAPI Lib "GDI" Alias "EndDoc" (ByVal hDC As Integer) As Integer

Declare Function StartPage Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function EndPage Lib "GDI" (ByVal hDC As Integer) As Integer

Declare Function lstrcpy Lib "Kernel" (ByVal lpString1 As Any, ByVal lpString2 As Any) As Long

Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long

Declare Function OpenClipboard Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function CloseClipboard Lib "User" () As Integer
Declare Function SetClipboardData Lib "User" (ByVal wFormat As Integer, ByVal hMem As Integer) As Integer

Declare Function GetActiveWindow Lib "User" () As Integer

Declare Function SetWindowWord Lib "User" (ByVal hWnd As Integer, ByVal nIndex As Integer, ByVal wNewWord As Integer) As Integer

Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, lpKeyName As Any, lpString As Any, ByVal lplFileName As String) As Integer


'Multimedia Windows API's
Global Const MMIO_READ = &H0                    '  open file for reading only

'  flags for mmioSeek()
Global Const SEEK_SET = 0                       '  seek to an absolute position
Global Const SEEK_END = 2                       '  seek relative to end of file

Declare Function mmioOpen Lib "mmsystem" (ByVal szFilename As String, ByVal lpmmioinfo As Long, ByVal dwOpenFlags As Long) As Integer
Declare Function mmioClose Lib "mmsystem" (ByVal hmmio As Integer, ByVal uFlags As Integer) As Integer
Declare Function mmioRead Lib "mmsystem" (ByVal hmmio As Integer, ByVal pch As String, ByVal cch As Long) As Long
Declare Function mmioSeek Lib "mmsystem" (ByVal hmmio As Integer, ByVal lOffset As Long, ByVal iOrigin As Integer) As Long

' MediaView Stuff
'MVVB Helper declarations
Declare Function GetLoFromDouble Lib "mvvbhelp.dll" (ByVal d As Double) As Long
Declare Function GetHiFromDouble Lib "mvvbhelp.dll" (ByVal d As Double) As Long
Declare Function fMVPrintMediaHelper Lib "mvvbhelp.dll" (ByVal lpMV As Long, ByVal hDC As Integer, rectPage As RECT, lpRect As RECT, ByVal lpfnPageCallBack As Long, ByVal lpPageCallbackData As Long, lpErr As Integer) As Integer

Global Const TTLINF_TITLE = 1
Global Const TTLINF_COPYRIGHT = 2
Global Const TTLINF_NUMTOPICS = 11
Global Const TTLINF_HASINDEX = 100
Global Const TTLINF_TOPICADDR = 101
Global Const TTLINF_TOPICTITLE = 102
Global Const TTLINF_FILESYS = 105
Global Const TTLINF_FILENAME = 106
Global Const TTLINF_ADDRTITLE = 110
Global Const TTLINF_FONTTABLE = 111
Global Const IMPLICIT_AND = 0
Global Const IMPLICIT_OR = 1

Global Const TL_AND = 0
Global Const TL_OR = 1
Global Const TL_NOT = 2

Global Const HOTSPOT_STRING = 0
Global Const HOTSPOT_HASH = 1
Global Const HOTSPOT_POPUPHASH = 2
Global Const HOTSPOT_UNKNOWN = 3

Global Const ADDRNIL = -1&
Global Const VANIL = -1&

Type QUERYERR
    iError As Integer
    iStart As Integer
    iLength As Integer
End Type

Declare Function TitleOpen Lib "mvttl12" (ByVal lpTitleName As String) As Integer
Declare Function TopicListFromQuery Lib "mvttl12" (ByVal hTitle As Integer, ByVal wFlags As Integer, ByVal lpszQuery As String, ByVal htlLimit As Integer, ByVal wNear As Integer, ByVal lpfnReserved As Long, lpHighlight As Integer, lpQError As QUERYERR) As Integer
Declare Sub TitleClose Lib "mvttl12" (ByVal hTitle As Integer)
Declare Sub TopicListDestroy Lib "mvttl12" (ByVal htl As Integer)
Declare Function TopicListLength Lib "mvttl12" (ByVal htl As Integer) As Long
Declare Function TopicListLookup Lib "mvttl12" (ByVal htl As Integer, ByVal lItem As Long) As Long
Declare Function TitleGetInfo Lib "mvttl12" (ByVal hTitle As Integer, ByVal iInfoMsg As Integer, ByVal lParam1 As Long, ByVal lParam2 As Any) As Long
Declare Function TopicListLoad Lib "mvttl12" (ByVal hTitle As Integer, ByVal lpszName As String) As Integer
Declare Function TopicListCombine Lib "mvttl12" (ByVal iOperation As Integer, ByVal htl1 As Integer, ByVal htl2 As Integer, ByVal fReserved As Integer) As Integer
Declare Function TopicListFromTopicNo Lib "mvttl12" (ByVal hTitle As Integer, ByVal lTopic As Long) As Integer

Declare Function addrMVGetPrev Lib "medv12" (ByVal lpMV As Long) As Long
Declare Function addrMVGetNext Lib "medv12" (ByVal lpMV As Long) As Long
Declare Function addrGetContents Lib "mvttl12" (ByVal hTitle As Integer) As Long

Declare Function fMVSetAddress Lib "medv12" (ByVal lpMV As Long, ByVal va As Long, ByVal iSubTopic As Integer, ByVal lScroll As Long, lpErr As Integer) As Integer
Declare Function fMVHasSR Lib "medv12" (ByVal lpMV As Long) As Integer
Declare Function fMVHasNSR Lib "medv12" (ByVal lpMV As Long) As Integer
Declare Function vaConvertAddr Lib "mvttl12" (ByVal hTitle As Integer, ByVal ADDR As Long) As Double
Declare Function lMVTopicNumber Lib "medv12" (ByVal lpMV As Long) As Long

Declare Function HighlightsInTopic Lib "mvttl12" (ByVal hTitleHilites As Integer, ByVal lTopicNo As Long) As Integer
Declare Function hMVGetHighlights Lib "medv12" (ByVal lpMV As Long) As Integer
Declare Function hMVSetHighlights Lib "medv12" (ByVal lpMV As Long, ByVal hHilites As Integer, ByVal fDraw As Integer, lpErr As Integer) As Integer

Declare Sub MVSetTextColor Lib "medv12" (ByVal lpMV As Long, ByVal cofore As Long)
Declare Function hwndMVGetWindow Lib "medv12" (ByVal lpMV As Long) As Integer
Declare Function fMVApplyToDC Lib "medv12" (ByVal lpMV As Long, ByVal hDC As Integer, lpRect As RECT, lpErr As Integer) As Integer
Declare Function ptMVGetSize Lib "medv12" (ByVal lpMV As Long) As Double

Declare Function fMVHighlightHotspots Lib "medv12" (ByVal lpMV As Long, ByVal fHighlightHotspots As Integer, lpErr As Integer) As Integer

Declare Function hMVGetFontTable Lib "medv12" (ByVal lpMV As Long) As Integer
Declare Function iCharStyleCount Lib "mvttl12" (ByVal hFntTable As Integer, lpErr As Integer) As Integer
Declare Function fGetCharStyle Lib "mvttl12" (ByVal hFntTable As Integer, lpiStyle As Integer, ByVal lpszStyleName As String, lplfLogFont As LOGFONT, lprgbFore As RGBTRIPLE, lprgbBack As RGBTRIPLE, lpiSubSuper As Integer, ByVal lpbMoreAttr As Any, lpErr As Integer) As Integer
Declare Function fSetCharStyle Lib "mvttl12" (ByVal hFntTable As Integer, ByVal iStyle As Integer, ByVal lpszStyleName As String, lplfLogFont As LOGFONT, lprgbFore As RGBTRIPLE, lprgbBack As RGBTRIPLE, lpiSubSuper As Integer, ByVal lpbMoreAttr As Any, lpErr As Integer) As Integer
Declare Sub MVUnrealize Lib "medv12" (ByVal lpMV As Long)
Declare Function fMVRealize Lib "medv12" (ByVal lpMV As Long, lpRect As RECT, lpErr As Integer) As Integer

Declare Function hMVSetHighlightLook Lib "medv12" (ByVal lpMV As Long, ByVal hHiliteBrush As Integer, ByVal roHiliteROP As Integer, lpErr As Integer) As Integer

Declare Function hMVGetName Lib "medv12" (ByVal lpMV As Long) As Integer

Declare Function lpMVDuplicate Lib "medv12" (ByVal lpMV As Long, lpErr As Integer) As Long
Declare Sub MVDelete Lib "medv12" (ByVal lpMV As Long)

Declare Function addrConvertTopicNumber Lib "mvttl12" (ByVal hTitle As Integer, ByVal lTopicnumber As Long) As Long
Declare Function fMVPrintMedia Lib "medv12" (ByVal lpMV As Long, ByVal hDC As Integer, rectPage As RECT, lpRect As RECT, lpfnPageCallBack As Integer, ByVal lpPageCallbackData As Long, lpErr As Integer) As Integer

Declare Function fMVIsSelected Lib "medv12" (ByVal lpMV As Long) As Integer
Declare Function hMVCopyMedia Lib "medv12" (ByVal lpMV As Long, lpErr As Integer) As Integer
Declare Function hMVCopySelection Lib "medv12" (ByVal lpMV As Long, lpErr As Integer) As Integer

Declare Function KeyIndexGetCount Lib "mvttl12" (ByVal hWheel As Integer, ByVal lpKey As String) As Integer
Declare Function KeyIndexGetAddrs Lib "mvttl12" (ByVal hWheel As Integer, ByVal lpKey As String, ByVal nStart As Integer, ByVal nCount As Integer, lpAddrs As Long) As Long
Declare Sub WordWheelClose Lib "mvttl12" (ByVal hWheel As Integer)
Declare Function WordWheelLength Lib "mvttl12" (ByVal hWheel As Integer) As Long
Declare Function WordWheelLookup Lib "mvttl12" (ByVal hWheel As Integer, ByVal lIndex As Long, ByVal lpbBuffer As String, ByVal wBufferLen As Integer) As Integer
Declare Function WordWheelOpen Lib "mvttl12" (ByVal lpszFS As String, ByVal lpszName As String) As Integer
Declare Function WordWheelPrefix Lib "mvttl12" (ByVal hWheel As Integer, ByVal lpszPrefix As String) As Long

'Media View Error Constants
Global Const wERRS_NONE = 0
Global Const wERRS_OOM = 1001                 'Out Of Memory
Global Const wERRS_OODC = 1002                'Out of Display Contexts
Global Const wERRS_NOTITLE = 1003
Global Const wERRS_FNF = 1004                 'File Not Found
Global Const wERRS_NOTOPIC = 1005
Global Const wERRS_BADPRINT = 1006
Global Const wERRS_BADFILE = 1007
Global Const wERRS_OLDFILE = 1008
Global Const wERRS_DiskFull = 1009
Global Const wERRS_FSReadWrite = 1010
Global Const wERRS_FCEndOfTopic = 1011
Global Const wERRS_BADPARAM = 1012
Global Const wERRS_NOFONTCHANGE = 1013
Global Const wERRS_NOMOREHOTSPOTS = 1014
Global Const wERRS_BADEWWINCLASS = 1015
Global Const wERRS_PARTIAL = 1016
Global Const wERRS_NOADDRESS = 1017
Global Const wERRS_NORECTANGLE = 1018
Global Const wERRS_NOVSCROLL = 1019           'No Vertical Scrollbar
Global Const wERRS_NOHSCROLL = 1020           'No Horizontal Scrollbar
Global Const wERRS_CANTFINDDLL = 1021
Global Const wERRS_CANTUSEDLL = 1022
Global Const wERRS_EWOOM = 1023               'Embedded Window Out Of Memory
Global Const wERRS_DEBUGMISMATCH = 1024
Global Const wERRS_BADPOLYGON = 1025          'less than 3 pts or none passed
Global Const wERRS_BADEWCALLBACK = 1026
Global Const wERRS_OLDFONTTABLE = 1027
Global Const wERRS_NOSUCHSTYLE = 1028
Global Const wERRS_GROUPIDTOOBIG = 1029

Global Const ERR_INTERNAL_BASE = 2000
Global Const ERR_INTERNAL_MAX = (ERR_INTERNAL_BASE + 32)

Global Const ERR_GRAMMAR_BASE = 2200
Global Const ERR_GRAMMAR_MAX = (ERR_GRAMMAR_BASE + 50)
				 
Global Const ERR_LOADLIBRARY_BASE = 2400
Global Const ERR_LOADLIBRARY_MAX = (ERR_LOADLIBRARY_BASE + 32)

Global Const ERR_DOS_BASE = 2600
Global Const ERR_DOS_MAX = (ERR_DOS_BASE + 256)

Global Const ERR_SUCCESS = (ERR_INTERNAL_BASE + 0)
Global Const ERR_FAILED = (ERR_INTERNAL_BASE + 1)
Global Const ERR_IDXINTERRUPT = (ERR_INTERNAL_BASE + 2)
Global Const ERR_NEARMEMORY = (ERR_INTERNAL_BASE + 3)
Global Const ERR_MEMORY = (ERR_INTERNAL_BASE + 4)
Global Const ERR_DISKFULL = (ERR_INTERNAL_BASE + 5)
Global Const ERR_WORDTOOLONG = (ERR_INTERNAL_BASE + 6)
Global Const ERR_BADVERSION = (ERR_INTERNAL_BASE + 7)
Global Const ERR_TOOMANYDOCS = (ERR_INTERNAL_BASE + 8)
Global Const ERR_TOOMANYSTOPS = (ERR_INTERNAL_BASE + 9)
Global Const ERR_TOOLONGSTOPS = (ERR_INTERNAL_BASE + 10)
Global Const ERR_STEMTOOLONG = (ERR_INTERNAL_BASE + 11)
Global Const ERR_TREETOOBIG = (ERR_INTERNAL_BASE + 12)
Global Const ERR_CANTREAD = (ERR_INTERNAL_BASE + 13)
Global Const ERR_IDXSEGOVERFLOW = (ERR_INTERNAL_BASE + 14)
Global Const ERR_BADARG = (ERR_INTERNAL_BASE + 15)
Global Const ERR_VOCABTOOLARGE = (ERR_INTERNAL_BASE + 16)
Global Const ERR_GROUPIDTOOBIG = (ERR_INTERNAL_BASE + 17)
Global Const ERR_BADOPERATOR = (ERR_INTERNAL_BASE + 18)
Global Const ERR_TERMTOOCOMPLEX = (ERR_INTERNAL_BASE + 19)
Global Const ERR_SEARCHTOOCOMPLEX = (ERR_INTERNAL_BASE + 20)
Global Const ERR_BADSYSCONFIG = (ERR_INTERNAL_BASE + 21)
Global Const ERR_ASSERT = (ERR_INTERNAL_BASE + 22)
Global Const ERR_FILE_NOT_EXIST = (ERR_INTERNAL_BASE + 23)
Global Const ERR_INVALID_FS_FILE = (ERR_INTERNAL_BASE + 24)
Global Const ERR_OUT_OF_RANGE = (ERR_INTERNAL_BASE + 25)
Global Const ERR_SEEK_FAILED = (ERR_INTERNAL_BASE + 26)
Global Const ERR_FILECREAT_FAILED = (ERR_INTERNAL_BASE + 27)
Global Const ERR_CANTWRITE = (ERR_INTERNAL_BASE + 28)
Global Const ERR_NOHANDLE = (ERR_INTERNAL_BASE + 29)
Global Const ERR_EXIST = (ERR_INTERNAL_BASE + 30)
Global Const ERR_INVALID_HANDLE = (ERR_INTERNAL_BASE + 31)
Global Const ERR_BADFILEFORMAT = (ERR_INTERNAL_BASE + 32)
				   
Global Const ERR_NULLQUERY = (ERR_GRAMMAR_BASE + 0)
Global Const ERR_EXPECTEDTERM = (ERR_GRAMMAR_BASE + 1)
Global Const ERR_EXTRACHARS = (ERR_GRAMMAR_BASE + 2)
Global Const ERR_MISSQUOTE = (ERR_GRAMMAR_BASE + 3)
Global Const ERR_MISSLPAREN = (ERR_GRAMMAR_BASE + 4)
Global Const ERR_MISSRPAREN = (ERR_GRAMMAR_BASE + 5)
Global Const ERR_TOODEEP = (ERR_GRAMMAR_BASE + 6)
Global Const ERR_TOOMANYTOKENS = (ERR_GRAMMAR_BASE + 7)
Global Const ERR_BADFORMAT = (ERR_GRAMMAR_BASE + 8)
Global Const ERR_BADVALUE = (ERR_GRAMMAR_BASE + 9)
Global Const ERR_UNMATCHEDTYPE = (ERR_GRAMMAR_BASE + 10)
Global Const ERR_BADBREAKER = (ERR_GRAMMAR_BASE + 11)
Global Const ERR_BADRANGEOP = (ERR_GRAMMAR_BASE + 12)
Global Const ERR_ALL_WILD = (ERR_GRAMMAR_BASE + 13)
Global Const ERR_NON_LAST_WILD = (ERR_GRAMMAR_BASE + 14)
Global Const ERR_WILD_IN_DTYPE = (ERR_GRAMMAR_BASE + 15)

Sub AddToBackList ()
    'This function places a topic in the back list box
    'and will remove the oldest item in the list if the number
    'of topics has exceeded the maximum allowed.
    'NOTE:  Strings are not being stored in the list box, instead
    'the topic number is stored in the item data property.  This allows
    'for much greater storage by lower the memory overhead for each topic
    
    frmMain.lbBackList.AddItem "", 0
    frmMain.lbBackList.ItemData(0) = gblarHistoryList(UBound(gblarHistoryList) - 1).lTopicNum
    If frmMain.lbBackList.ListCount > MAX_BACKLIST Then frmMain.lbBackList.RemoveItem MAX_BACKLIST
    frmMain.cmdBack.Enabled = True
    frmMain.mnuTopic_Back.Enabled = True
End Sub

Sub AddToHistory ()
    'This function adds topics into the array used to keep track
    'of where the user has been.  It also removes the oldest topic
    'from the array if it has exceeded the maximum allowed entries
    
    Dim nUBound, nTemp As Integer
    
    'Get the current upper bound of the history array
    nUBound = UBound(gblarHistoryList)
    If nUBound < MAX_HISTORYLIST - 1 Then
	'The upper bound is less than the maximum allowed so add it
	nUBound = nUBound + 1
	'The preserve keyword keeps the data currently in the array
	ReDim Preserve gblarHistoryList(nUBound)
	gblarHistoryList(nUBound).szTopicTitle = frmMain.MediaView1.MediaViewTopic
	gblarHistoryList(nUBound).lTopicNum = frmMain.MediaView1.TopicIndex
    Else
	'Adding the new item will exceed the max allowed, so first remove the oldest
	'topic in the history list by setting 0 = 1, 1 = 2, 2 = 3, 3 = 4, etc.
	For nTemp = 0 To MAX_HISTORYLIST - 2
	    gblarHistoryList(nTemp).szTopicTitle = gblarHistoryList(nTemp + 1).szTopicTitle
	    gblarHistoryList(nTemp).lTopicNum = gblarHistoryList(nTemp + 1).lTopicNum
	Next nTemp
	'Now add the topic to the history array
	gblarHistoryList(nUBound).szTopicTitle = frmMain.MediaView1.MediaViewTopic
	gblarHistoryList(nUBound).lTopicNum = frmMain.MediaView1.TopicIndex
    End If
    If gblbHistoryActive Then
	'If the history form is loaded, add the topic the list box!!
	frmHistory.lbHistory.AddItem gblarHistoryList(nUBound).szTopicTitle, 0
	frmHistory.lbHistory.ItemData(0) = gblarHistoryList(nUBound).lTopicNum
	If frmHistory.lbHistory.ListCount > MAX_HISTORYLIST Then
	    'The max has been exceeded, so remove the last item from the list box
	    frmHistory.lbHistory.RemoveItem MAX_HISTORYLIST
	End If
    End If
End Sub

Sub ChangeFileExtension (szFilename As String, szNewExtension As String, bPreservePath As Integer)
    'This function changes the file extension (if any) of szFilename param
    'to szNewExtension param. The full path is preserve if requested by the
    'bPreservePath param.
    
    Dim nTemp, nPos As Integer
    
    nTemp = 1
    'Find the position of the last backslash
    Do
	nPos = InStr(nTemp, szFilename, "\")
	If nPos > 0 Then nTemp = nPos + 1
    Loop Until nPos = 0
    
    'Find the position of the extension if any
    nPos = InStr(nTemp, szFilename, ".")
    
    'Preserve the path if requested
    If bPreservePath Then nTemp = 1
    If nPos > 0 Then
	'Replace the old extension if there was one
	szFilename = Mid$(szFilename, nTemp, nPos - nTemp) & szNewExtension
    Else
	'There was no old extension, so just add the new one
	szFilename = Mid$(szFilename, nTemp) & szNewExtension
    End If
End Sub

Sub DefaultCursor ()
    Screen.MousePointer = DEFAULT
End Sub

Sub DestroyBookmarkMenu ()
    Dim nTemp As Integer
    
    'This destroys/hides all the bookmarks on the Bookmark menu
    frmMain.mnuBookmark_Mark(0).Visible = False
    frmMain.mnuBookmark_Sep(0).Visible = False
    frmMain.mnuBookmark_More.Visible = False
    For nTemp = 1 To gblnNumMenuBookmarks - 1
	Unload frmMain.mnuBookmark_Mark(nTemp)
    Next nTemp
    gblnNumMenuBookmarks = 0
End Sub

Function FillGroupListBox (szBaggageContents As String, lbGroups As Control, szSection As String) As Integer
    'This function is used to fill list boxes and combo boxes with entries
    'from the baggage file passed as the szBaggageContents param
    
    Dim lPos, lTemp As Long
    Dim nSectionLen, nPosStart, nPosEnd As Integer
    Dim szBaggageLine, szGroupName, szGroupTitle As String
    
    'Rather than keep a separate array for group names, I set a tab width
    'wide enough to ensure that the user won't see the group names that I place
    'in a list box
    If TypeOf lbGroups Is ListBox Then lTemp = SendMessage(lbGroups.hWnd, LB_SETTABSTOPS, 1, 200)
    lTemp = 1
    nSectionLen = Len(szSection) + 1
    If nSectionLen > 1 Then
	'Only enter loop if a value was passed in the szSection param
	Do
	    lPos = InStr(lTemp, szBaggageContents, szSection)
	    If lPos > 0 Then
		'Only continue if the specified section is found in the szBaggageContents
		szBaggageLine = Mid$(szBaggageContents, lPos, InStr(lPos, szBaggageContents, Chr$(10)) - lPos)
		nPosEnd = InStr(nSectionLen, szBaggageLine, ",")
		If nPosEnd > 0 Then
		    'Only add try to add the name to the list/combo box if a comma is found
		    
		    'Get the text between the szSection and the comma
		    szGroupName = Trim$(Mid$(szBaggageLine, nSectionLen, nPosEnd - nSectionLen))
		    nPosStart = InStr(nPosEnd + 1, szBaggageLine, Chr$(34))
		    nPosEnd = InStr(nPosStart + 1, szBaggageLine, Chr$(34))
		    
		    'Get the text surrounded by quotes
		    szGroupTitle = Mid$(szBaggageLine, nPosStart + 1, nPosEnd - nPosStart - 1)
		    If TypeOf lbGroups Is ListBox Then
			'If list box then dealing with groups, so add group title
			'and group name separated by a TAB
			lbGroups.AddItem szGroupTitle & Chr$(9) & szGroupName
		    Else
			'Otherwise, we're dealing with keywords, so add the
			'keyword title and set the itemdata to the ascii equivalent
			'of the keyword name (keyword names are ALWAYS 1 character!!)
			lbGroups.AddItem szGroupTitle
			lbGroups.ItemData(lbGroups.NewIndex) = Asc(szGroupName)
		    End If
		    lTemp = lPos + 1
		End If
	    End If
	Loop Until lPos = 0
    End If
    'If lTemp == 1 then the section was not passed, so return false
    FillGroupListBox = (lTemp > 1)
End Function

Function GetValidlpMV (MedView As Control) As Long
    'This function returns a valid lpMV of either the NSR or the SR
    
    If MedView.lpMVNSR <> 0 Then
	GetValidlpMV = MedView.lpMVNSR
    Else
	GetValidlpMV = MedView.lpMVSR
    End If
End Function

Sub GetWinTextColor ()
    'This function returns the default text color from the WIN.INI
    'file.  If no color is defined, it returns black
    
    Dim szRGB As String
    Dim nRetLen, nTemp, nRVal, nGVal, nBVal As Integer
    
    'Initialize the string
    szRGB = String(128, 0)
    'Get the entry from the WIN.INI
    nRetLen = GetProfileString("colors", "WindowText", "0 0 0", szRGB, Len(szRGB))
    szRGB = Left$(szRGB, nRetLen)
    
    'Separate the RGB values from the string returned
    For nTemp = 1 To 2
	nRetLen = InStr(szRGB, " ")
	Select Case nTemp
	    Case 1
		nRVal = Val(Left$(szRGB, nRetLen - 1))
	    Case 2
		nGVal = Val(Left$(szRGB, nRetLen - 1))
	End Select
	szRGB = Right$(szRGB, Len(szRGB) - nRetLen)
    Next nTemp
    nBVal = Val(szRGB)
    gbllCurTextColor = RGB(nRVal, nGVal, nBVal)
End Sub

Sub LoadAllBookmarks (lbListbox As Control)
    'This function loads all bookmarks into the list box
    'passed in the lbListbox param
    
    Dim szFilename As String
    Dim nTemp, nMarkNum As Integer
    Dim szName As String
    Dim szAddress As String

    lbListbox.Clear
    szFilename = frmMain.MediaView1.MediaViewTitle
    'Change the file extension
    Call ChangeFileExtension(szFilename, BOOKMARKFILE_EXT, True)
    
    'Initialize the string
    szName = String(128, 0)
    'Get the bookmark name
    nTemp = GetPrivateProfileString("BOOKMARKS", "0", "NULL", szName, Len(szName), szFilename)
    szName = Left$(szName, nTemp)
    nMarkNum = 0
    
    'Read the bookmarks from the BMK file
    While (szName <> "NULL")
	'Initialize the string
	szAddress = String(128, 0)
	'Get the topic address of the bookmark
	nTemp = GetPrivateProfileString("BOOKMARKS", "ADDR" & Format$(nMarkNum, "0"), "NULL", szAddress, Len(szAddress), szFilename)
	szAddress = Left$(szAddress, nTemp)
	
	If szAddress = "NULL" Then
	    'Couldn't get the address
	    nTemp = ViewMVError(ERR_READBMKFILE, szName)
	Else
	    'Add the bookmark name and topic address to list box
	    lbListbox.AddItem szName
	    lbListbox.ItemData(lbListbox.NewIndex) = Val(szAddress)
	End If
	nMarkNum = nMarkNum + 1
	
	'Initialize the string
	szName = String(128, 0)
	'Get the next bookmark
	nTemp = GetPrivateProfileString("BOOKMARKS", Format$(nMarkNum, "0"), "NULL", szName, Len(szName), szFilename)
	szName = Left$(szName, nTemp)
    Wend
End Sub

Sub LoadBookmarkMenu ()
    'This function adds bookmarks to the Bookmark menu
    'and will show the More Bookmarks menu item if necessary
    
    Dim szFilename As String
    Dim nTemp As Integer
    Dim szKeyValue As String

    szFilename = frmMain.MediaView1.MediaViewTitle
    'Change file extension to BMK
    Call ChangeFileExtension(szFilename, BOOKMARKFILE_EXT, True)
    
    'Initialize string
    szKeyValue = String(128, 0)
    'Get first bookmark name
    nTemp = GetPrivateProfileString("BOOKMARKS", "0", "NULL", szKeyValue, Len(szKeyValue), szFilename)
    szKeyValue = Left$(szKeyValue, nTemp)
    While (szKeyValue <> "NULL") And (gblnNumMenuBookmarks < MAX_BOOKMARKMENU)
	'Add bookmarks
	If gblnNumMenuBookmarks <> 0 Then
	    Load frmMain.mnuBookmark_Mark(gblnNumMenuBookmarks)
	Else
	    frmMain.mnuBookmark_Mark(gblnNumMenuBookmarks).Visible = True
	End If
	
	'Set menu item caption
	frmMain.mnuBookmark_Mark(gblnNumMenuBookmarks).Caption = "&" & Format$(gblnNumMenuBookmarks + 1, "0") & " " & Left$(szKeyValue, nTemp)
	gblnNumMenuBookmarks = gblnNumMenuBookmarks + 1
	'Intialize string
	szKeyValue = String(128, 0)
	'Get next bookmark name
	nTemp = GetPrivateProfileString("BOOKMARKS", Format$(gblnNumMenuBookmarks, "0"), "NULL", szKeyValue, Len(szKeyValue), szFilename)
	szKeyValue = Left$(szKeyValue, nTemp)
    Wend
    If (gblnNumMenuBookmarks = MAX_BOOKMARKMENU) And (szKeyValue <> "NULL") Then
	'Show menu seperator and More Bookmarks menu items
	frmMain.mnuBookmark_Sep(0).Visible = True
	frmMain.mnuBookmark_More.Visible = True
    End If
End Sub

Function MVError (lpErr As Integer, szExtraText As String) As Integer
    'This function displays error messages that are generated by MediaView
    
    Dim szMsg As String
    Dim nFlags As Integer
    
    Select Case lpErr
	'General Error messages
	Case wERRS_NONE
	    szMsg = "There was no error."
	    nFlags = MB_OK Or MB_ICONINFORMATION
	Case wERRS_OOM
	    szMsg = "There has been an out of memory error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_OODC                'Out of Display Contexts
	    szMsg = "Out of Device Contexts."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_NOTITLE
	    szMsg = "No title is open."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_FNF                 'File Not Found
	    szMsg = "File not found."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_NOTOPIC
	    szMsg = "No topic with that topic number found."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_BADPRINT
	    szMsg = "Error printing."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_BADFILE
	    szMsg = "Bad file."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_OLDFILE
	    szMsg = "This file was created with an older version of MediaView."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_DiskFull
	    szMsg = "Could not create a necessary file.  Please free some hard drive space by deleting some unnecessary files."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_FSReadWrite
	    szMsg = "There has been an internal file system read/write error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_FCEndOfTopic
	    szMsg = "End of topic error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_BADPARAM
	    szMsg = "An incorrect or bad parameter was passed."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_NOFONTCHANGE
	    szMsg = "Could not change the font."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_NOMOREHOTSPOTS
	    szMsg = "There are no more hot spots."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_BADEWWINCLASS
	    szMsg = "Bad embedded window class."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_PARTIAL
	    szMsg = "There has been a *partial* error, whatever that means."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_NOADDRESS
	    szMsg = "No address was given or passed."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_NORECTANGLE
	    szMsg = "No rectangle was passed or either the height or width of the passed rectangle was 0."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_NOVSCROLL           'No Vertical Scrollbar
	    szMsg = "There is no vertical scroll bar."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_NOHSCROLL           'No Horizontal Scrollbar
	    szMsg = "There is no horizontal scroll bar."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_CANTFINDDLL
	    szMsg = "Could not find a DLL."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_CANTUSEDLL
	    szMsg = "Could not use a DLL."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_EWOOM               'Embedded Window Out Of Memory
	    szMsg = "There has been an embedded window out of memory error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_DEBUGMISMATCH
	    szMsg = "There has been a DEBUG mismatch error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_BADPOLYGON          'less than 3 pts or none passed
	    szMsg = "A bad (less than 3 points) or no polygon was passed."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_BADEWCALLBACK
	    szMsg = "Bad embedded window callback function."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_OLDFONTTABLE
	    szMsg = "The font table is of an older and unsupported style."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_NOSUCHSTYLE
	    szMsg = "No such style exists in the font table."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case wERRS_GROUPIDTOOBIG
	    szMsg = "The group ID is too big."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	
	'Search Error messages
	Case ERR_SUCCESS
	    szMsg = "The search was successful."
	    nFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_FAILED
	    szMsg = "The search failed."    'or  "Unable to Search"
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_IDXINTERRUPT
	    szMsg = "The indexer has been interupted."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_MEMORY, ERR_NEARMEMORY
	    szMsg = "The search failed due to an out-of-memory error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_MEMORY
	    szMsg = "The search failed due to an out-of-memory error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_DISKFULL
	    szMsg = "Insufficient disk space to perform search. Delete some files to free disk space and then try again."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_WORDTOOLONG
	    szMsg = "A word in the search query is too long. Search words can have a maximum of 255 characters."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADVERSION
	    szMsg = "The index, stopword, word wheel or catalog file is of the wrong type or version."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TOOMANYDOCS
	    szMsg = "There are too many documents."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TOOMANYSTOPS
	    szMsg = "Too many words in stop-word list. The stop-word list can have a maximum of 1,024 stop words."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TOOLONGSTOPS
	    szMsg = "Too long stop words."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_STEMTOOLONG
	    szMsg = "A word in the search query is too long. Search words can have a maximum of 255 characters."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TREETOOBIG
	    szMsg = "The search query is too long or too complex."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_CANTREAD
	    szMsg = "The search failed due to a disk read error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_IDXSEGOVERFLOW
	    szMsg = "There has been a indexer segment overflow."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADARG
	    szMsg = "An invalid value was passed to a search function."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_VOCABTOOLARGE
	    szMsg = "The vocabulary is too large."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_GROUPIDTOOBIG
	    szMsg = "A group ID number is too large."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADOPERATOR
	    szMsg = "Cannot use quotes or NEAR to search this title."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TERMTOOCOMPLEX
	    szMsg = "Too many matches. Type a word or phrase that is more specific."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADSYSCONFIG
	    szMsg = "The indexer cannot run in real mode or on a 80286 system."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_ASSERT
	    szMsg = "An assertion failed."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_FILE_NOT_EXIST
	    szMsg = "The search failed. A required file was not found."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_INVALID_FS_FILE
	    szMsg = "The internal file system is invalid."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_OUT_OF_RANGE
	    szMsg = "There has been an out of range error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_SEEK_FAILED
	    szMsg = "The search failed. A disk seek error occurred."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_FILECREAT_FAILED
	    szMsg = "The search failed. Could not create a required file."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_CANTWRITE
	    szMsg = "The search failed due to a disk-read error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_NOHANDLE
	    szMsg = "The search failed. Could not open a required file because too many files are open."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_EXIST
	    szMsg = "There has been an existence error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_INVALID_HANDLE
	    szMsg = "The search failed. Could not open a required file."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADFILEFORMAT
	    szMsg = "The character-table file is improperly formatted."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_NULLQUERY
	    szMsg = "The query is empty or has no searchable words. You cannot search for words marked as stop words (for example, ""the"", ""that"", or ""a"")."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_EXPECTEDTERM
	    szMsg = "The query or a subexpression within parentheses begins or ends with an operator."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_EXTRACHARS
	    szMsg = "There has been an extra characters error."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_MISSQUOTE
	    szMsg = "The query is missing a quotation mark."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_MISSLPAREN
	    szMsg = "The query is missing a left parenthesis."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_MISSRPAREN
	    szMsg = "The query is missing a right parenthesis."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TOODEEP
	    szMsg = "The query is too complex. Do not nest parentheses more than five levels deep."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TOOMANYTOKENS
	    szMsg = "The query has too many terms."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADFORMAT
	    szMsg = "The query contains an improperly formatted data-type value."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADVALUE
	    szMsg = "The query contains an improper data value (for example, an invalid date or out-of-range number)."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_UNMATCHEDTYPE
	    szMsg = "The operands to the THRU operator are of different data-types."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADRANGEOP
	    szMsg = "A subexpression was used as an operand to the THRU operator. The THRU operator supports only simple terms as operands."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	'// THRU in both of the above messages should be replaced by name of operator defined in operator file
	Case ERR_BADBREAKER
	    szMsg = "Word breaker function table not specified."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case Is = ERR_ALL_WILD
	    szMsg = "The query contains a word consisting only of combination of wildcard characters (* and ?)."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_WILD_IN_DTYPE
	    szMsg = "The query uses a wildcard (*) within a term marked as non-text data. The wildcard can only be used within text."
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
	Case Else
	    szMsg = "Unknown Error # " & Format$(lpErr, "0")
	    nFlags = MB_OK Or MB_ICONEXCLAMATION
    End Select
    MVError = MsgBox(szMsg, nFlags, frmMain.Caption)
End Function

Sub NewTopic (bBack As Integer)
    'This function takes care of setting up the app to properly display
    'and intialize after a new topic has been displayed
    
    'Set the state of the previous and next buttons
    Call SetPrevNext
    'Show search hits
    If gblbSearchActive Then Call ShowSearchHits(CInt(frmMain.mnuHighlight_SearchHits.Checked))
    'Add new topic to history list
    Call AddToHistory
    'If this new topic was not displayed as a result of using the "Back" feature,
    'add it to the back list box
    If Not bBack Then Call AddToBackList
End Sub

Sub PerformUpdate (hHDC As Integer, hHWnd As Integer, lpMV As Long, rectRect As RECT)
    'This function updates the rectRect within the hHWnd of a MediaView
    
    Dim nTemp, lpErr As Integer
    
    'Unrealize the MediaView
    Call MVUnrealize(lpMV)
    'Invalidate the RECT
    Call InvalidateRect(hHWnd, rectRect, True)
    'Update the window to force an immediate update
    Call UpdateWindow(hHWnd)
    
    'Realize the MediaView
    nTemp = fMVRealize(lpMV, rectRect, lpErr)
    'Show error message if necessary
    If nTemp = 0 Then nTemp = MVError(lpErr, "")
    'Apply to the SR's DC
    nTemp = fMVApplyToDC(lpMV, hHDC, rectRect, lpErr)
    'Show error message if necessary
    If nTemp = 0 Then nTemp = MVError(lpErr, "")
    'Invaidate the RECT, note no need to call UpdateWindow
    Call InvalidateRect(hHWnd, rectRect, True)
End Sub

Function ReadBaggageMVP (szBaggageContents As String) As Integer
    'This function reads the MVP file stored as baggage within the
    'M12 file and places it in the variable szBaggageContents
    
    Dim szBaggageName As String
    Dim hFile As Integer
    Dim lBytes, lTemp As Long

    szBaggageName = frmMain.MediaView1.MediaViewTitle
    'Change the file extension
    Call ChangeFileExtension(szBaggageName, BAGGAGEFILE_EXT, False)
    szBaggageName = frmMain.MediaView1.MediaViewTitle & "+" & szBaggageName
    'Open the file
    hFile = mmioOpen(szBaggageName, 0&, MMIO_READ)
    If hFile = 0 Then
	'Couldn't open the file, so return false
	ReadBaggageMVP = False
    Else
	'Get the size of the file
	lBytes = mmioSeek(hFile, 0, SEEK_END)
	'Initialize the string
	szBaggageContents = String$(lBytes + 1, 0)
	'Return to the beginning of the file
	lTemp = mmioSeek(hFile, 0, SEEK_SET)
	'Read the file into szBaggageContents
	lTemp = mmioRead(hFile, szBaggageContents, lBytes)
	'Close the file
	lTemp = mmioClose(hFile, 0)
	ReadBaggageMVP = True
    End If
End Function

Sub SetMVAddress (MedView As Control, ByVal lpMV As Long, ByVal addrAddress As Long, ByVal lScroll As Long)
    'This function performs a jump  in a MediaView VBX given an address
    
    Dim nTemp, lpErr  As Integer
    Dim va As Long
    Dim dblva As Double

    'For some reason, the vaConvertAddr call fails if declared as returning
    'anything other than a double, so return a double
    dblva = vaConvertAddr(gblhTitle, addrAddress)
    'Now use the MVVBHELP.DLL to get the first 4 bytes of the 8 byte double
    va = GetHiFromDouble(dblva)
    If va = VANIL Then
	'Show the error message
	nTemp = ViewMVError(ERR_BADVA, Format$(addrAddress, "0"))
    Else
	'If a valid return value then set the address
	nTemp = fMVSetAddress(lpMV, va, 0, lScroll, lpErr)
	If nTemp = 0 Then
	    'Perhaps there is just no NSR
	    If lpErr <> wERRS_NOTOPIC Then
		'Error setting the address
		nTemp = MVError(lpErr, CStr(va))
	    Else
		'OK, there may not be an NSR so try the SR.
		'If this fails, then there is a problem.
		nTemp = fMVSetAddress(lpMV, va, 1, lScroll, lpErr)
		If nTemp = 0 Then nTemp = MVError(lpErr, CStr(va))
	    End If
	End If
	If lpErr = wERRS_NONE Then
	    'Tell the VBX that it has a new topic
	    MedView.TopicIndex = lMVTopicNumber(lpMV)
	    'Set up the app for the newly displayed topic
	    Call NewTopic(False)
	End If
    End If
End Sub

Sub SetPrevNext ()
    'This subroutine set the states of the previous and next
    'buttons and menu items
    
    Dim lpMV As Long
    Dim bEnable As Integer

    'Get a valid lpMV
    lpMV = GetValidlpMV(frmMain.MediaView1)

    If addrMVGetNext(lpMV) = ADDRNIL Then
	'There is a next topic in the browse sequence
	bEnable = False
    Else
	'This is the last topic in the browse sequence
	bEnable = True
    End If
    'Set the button and menu states
    frmMain.cmdNext.Enabled = bEnable
    frmMain.mnuTopic_Next.Enabled = bEnable

    If addrMVGetPrev(lpMV) = ADDRNIL Then
	'There is a previous topic in the browse sequence
	bEnable = False
    Else
	'This is the first topic in the browse sequence
	bEnable = True
    End If
    'Set the button and menu states
    frmMain.cmdPrev.Enabled = bEnable
    frmMain.mnuTopic_Prev.Enabled = bEnable
End Sub

Sub ShowSearchHits (bShow As Integer)
    'This subroutine turns the higlighting for the current topic
    'on or off
    
    Dim hTopicHighlights, nRet1, nRet2, nTemp, lpErr  As Integer

    If bShow Then
	'If turning on, get the highlight structure
	hTopicHighlights = HighlightsInTopic(gbllpHighLight, frmMain.MediaView1.TopicIndex)
    Else
	'Otherwise set the handle to null
	hTopicHighlights = 0
    End If

    If frmMain.MediaView1.lpMVNSR <> 0 Then
	'Set the highlights for the NSR
	nRet1 = hMVSetHighlights(frmMain.MediaView1.lpMVNSR, hTopicHighlights, True, lpErr)
	'Show an error message if necessary
	If lpErr <> wERRS_NONE Then nTemp = MVError(lpErr, "")
    End If
    If frmMain.MediaView1.lpMVSR <> 0 Then
	'Set the highlights for the SR
	nRet2 = hMVSetHighlights(frmMain.MediaView1.lpMVSR, hTopicHighlights, True, lpErr)
	'Show an error message if necessary
	If lpErr <> wERRS_NONE Then nTemp = MVError(lpErr, "")
    End If

    'Free the memory associated with the NSR
    If nRet1 <> 0 Then nTemp = GlobalFree(nRet1)
    'Free the memory associated with the SR, but check to make sure its no the same handle!!!
    If (nRet2 <> 0) And (nRet2 <> nRet1) Then nTemp = GlobalFree(nRet2)
End Sub

Sub UpdateMedView (MedView As Control)
    'This subroutine takes care of refreshing a MediaView VBX after
    'character style changes.
    
    Dim nTemp, hHWnd As Integer
    Dim hHDC As Integer
    Dim rectRect As RECT
	
    Call WaitCursor
    If MedView.lpMVSR <> 0 Then

	'There's no way we'll ever get an hWnd to a pop-up because
	'as soon as the user clicks on the menu bar the pop-up will be
	'dismissed.  So the only possibility is to get the hWnd of the SR!
	hHWnd = GetWindow(MedView.hWnd, GW_CHILD)
		
	'Get the DC of the SR
	If hHWnd <> 0 Then hHDC = GetDC(hHWnd)
	If (hHWnd = 0) Or (hHDC = 0) Then
	    'Show error message
	    nTemp = ViewMVError(ERR_UPDATESR, "")
	Else
	    'This takes care of refreshing the SR
	    Call GetWindowRect(hHWnd, rectRect)
	    rectRect.Bottom = rectRect.Bottom - rectRect.Top
	    rectRect.Right = rectRect.Right - rectRect.Left
	    rectRect.Left = 0
	    rectRect.Top = 0
	    'If eiter the width or height is 0 then there's nothing to update!
	    If (rectRect.Right <> 0) And (rectRect.Bottom <> 0) Then
		'Perform the update
		Call PerformUpdate(hHDC, hHWnd, CLng(MedView.lpMVSR), rectRect)
	    End If
	    'Make sure to release the DC!!!
	    nTemp = ReleaseDC(hHWnd, hHDC)
	End If
    End If
    
    'Get the DC of the NSR
    hHDC = GetDC(MedView.hWnd)
    'Get the hWnd of the NSR
    hHWnd = hwndMVGetWindow(MedView.lpMVNSR)
    If (hHDC = 0) Or (hHWnd = 0) Then
	'Show error message
	nTemp = ViewMVError(ERR_UPDATENSR, "")
    Else
	If MedView.lpMVNSR <> 0 Then
	    'Get the hWnd of the NSR
	    hHWnd = hwndMVGetWindow(MedView.lpMVNSR)
	    'Change Bottom to be the height of the NSR
	    rectRect.Bottom = (MedView.Height / Screen.TwipsPerPixelY) - rectRect.Bottom
	    'If eiter the width or height is 0 then there's nothing to update!
	    If (rectRect.Right - rectRect.Left <> 0) And (rectRect.Bottom - rectRect.Top <> 0) Then
		'Perform the update
		Call PerformUpdate(hHDC, hHWnd, CLng(MedView.lpMVNSR), rectRect)
	    End If
	End If
	'Make sure to release the DC!!!
	nTemp = ReleaseDC(MedView.hWnd, hHDC)
    End If
    Call DefaultCursor
End Sub

Function ViewMVError (nError As Integer, szExtraText As String) As Integer
    'This function displays error messages generated by this application
    
    Dim szMsg As String
    Dim fFlags As Integer
    
    Select Case nError
	Case ERR_CREATEOBJECT
	    szMsg = "Could not create object to: " & szExtraText
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_OPENCLIPBOARD
	    szMsg = "Could not open clipboard."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_SETCLIPBOARDDATA
	    szMsg = "Could not set clipboard data."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_READBMKFILE
	    szMsg = "There was an error reading the bookmark: " & szExtraText & "."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_NOSELECTEDTEXT
	    szMsg = "No text is currently selected."
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_TLFATAL
	    szMsg = "Could not create initial topic list.  Can not continue operation."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TLCREATE
	    szMsg = "Could not create a topic list. Resulting list will be incomplete."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TLCOMBINE
	    szMsg = "Could not combine topic list. Resulting list will be incomplete."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_NOMARKEDTOPICS
	    szMsg = "There are no topics marked for printing.  Choose Mark For Print from the Topic menu to mark topics.":
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_BADVA
	    szMsg = "Incorrect virtual address returned for address :" & szExtraText & "."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADADDRESS
	    szMsg = "Incorrect address returned for topic number :" & szExtraText & "."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_NOGROUPS
	    szMsg = "No groups were selected."
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_BADKEYCOUNT
	    szMsg = "Incorrect number of topics associated with keyword: " & szExtraText & "."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_BADKEYGETADDRESS
	    szMsg = "Bad return value when attempting to get adrresses of topics associated with keyword: " & szExtraText & "."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_TOPICTITLE
	    szMsg = "Couldn't get title for topic with address or topic number: " & szExtraText & "."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_WRITEBOOKMARK
	    szMsg = "Couldn't write bookmark: " & szExtraText & "."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_UPDATESR
	    szMsg = "Couldn't update scrolling region."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_UPDATENSR
	    szMsg = "Couldn't update non-scrolling region."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_NOTOPICS
	    szMsg = "No topics found with the text: " & szExtraText
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_WWOPEN
	    szMsg = "Couldn't open the word wheel for: " & szExtraText
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_WWLOOKUP
	    szMsg = "Couldn't add keyword number: " & szExtraText & ". Resulting list will be incomplete."
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
	Case ERR_NOKEYWORDSINTITLE
	    szMsg = "There are no keywords in this title."
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_NOKEYWORDS
	    szMsg = "There are no keywords in the keyword group: " & szExtraText & "."
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_NO0ORNEG
	    szMsg = "Zero and negative number are not allowed."
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_LESSTHAN1000
	    szMsg = "Only magnification levels less than 1,000 are allowed."
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_WHOLENUM
	    szMsg = "Only whole numbers (no decimals) are allowed."
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case ERR_TLLOOKUP
	    szMsg = "Couldn't get the topic number from the current topic list entry: " & szExtraText & "."
	    fFlags = MB_OK Or MB_ICONINFORMATION
	Case Else
	    szMsg = "Unknown error # " & Format$(nError, "0")
	    fFlags = MB_OK Or MB_ICONEXCLAMATION
    End Select
    ViewMVError = MsgBox(szMsg, fFlags, frmMain.Caption)
End Function

Sub WaitCursor ()
    Screen.MousePointer = HOURGLASS
End Sub

