VERSION 2.00
Begin Form frmMark 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Mark Topic for Printing"
   ClientHeight    =   4425
   ClientLeft      =   1860
   ClientTop       =   2100
   ClientWidth     =   7545
   Height          =   4950
   Left            =   1800
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4425
   ScaleWidth      =   7545
   Top             =   1635
   Width           =   7665
   Begin CommandButton cmdDeleteAll 
      Caption         =   "Delete A&ll"
      Enabled         =   0   'False
      Height          =   345
      Left            =   5985
      TabIndex        =   13
      Top             =   3165
      Width           =   1380
   End
   Begin CommandButton cmdDelete 
      Caption         =   "&Delete"
      Enabled         =   0   'False
      Height          =   345
      Left            =   5985
      TabIndex        =   12
      Top             =   2655
      Width           =   1380
   End
   Begin CommandButton cmdAdd 
      Caption         =   "&Add"
      Default         =   -1  'True
      Height          =   345
      Left            =   5985
      TabIndex        =   11
      Top             =   2145
      Width           =   1380
   End
   Begin CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "&Close"
      Height          =   345
      Left            =   5985
      TabIndex        =   10
      Top             =   525
      Width           =   1380
   End
   Begin SSPanel pan3dMarkedTopics 
      BevelOuter      =   1  'Inset
      Height          =   2205
      Left            =   195
      TabIndex        =   9
      Top             =   2085
      Width           =   5625
      Begin ListBox lbMarkedTopics 
         Height          =   2175
         Left            =   15
         TabIndex        =   6
         Top             =   15
         Width           =   5595
      End
   End
   Begin SSPanel pan3dGroups 
      BevelOuter      =   1  'Inset
      Height          =   1230
      Left            =   3150
      TabIndex        =   8
      Top             =   435
      Width           =   2670
      Begin ListBox lbGroups 
         Enabled         =   0   'False
         Height          =   1200
         Left            =   15
         Sorted          =   -1  'True
         TabIndex        =   4
         Top             =   15
         Width           =   2640
      End
   End
   Begin SSFrame fra3dMark 
      Height          =   1305
      Left            =   195
      TabIndex        =   7
      Top             =   360
      Width           =   2580
      Begin SSOption opt3dAllTopics 
         Caption         =   "All Topics in &Group"
         Height          =   300
         Left            =   135
         TabIndex        =   1
         TabStop         =   0   'False
         Top             =   780
         Width           =   2235
      End
      Begin SSOption opt3dCurTopic 
         Caption         =   "Current &Topic"
         Height          =   255
         Left            =   135
         TabIndex        =   0
         Top             =   345
         Value           =   -1  'True
         Width           =   2265
      End
   End
   Begin Label lblMarkedTopics 
      BackStyle       =   0  'Transparent
      Caption         =   "&Marked Topics:"
      Height          =   225
      Left            =   195
      TabIndex        =   5
      Top             =   1830
      Width           =   1965
   End
   Begin Label lblGroups 
      BackStyle       =   0  'Transparent
      Caption         =   "G&roups:"
      Height          =   225
      Left            =   3150
      TabIndex        =   3
      Top             =   165
      Width           =   1965
   End
   Begin Label lblMark 
      BackStyle       =   0  'Transparent
      Caption         =   "Mark:"
      Height          =   225
      Left            =   195
      TabIndex        =   2
      Top             =   165
      Width           =   1965
   End
End
Option Explicit

Sub cmdAdd_Click ()
    'Adds a topic or a group to the marked topic list box
    
    Dim szAddString As String

    If opt3dCurTopic.Value Then
        'Its a topic so add the topic's name
        lbMarkedTopics.AddItem "Topic:" & Chr$(9) & frmMain.MediaView1.MediaViewTopic
        'Add the topic number to the list boxes ItemData
        lbMarkedTopics.ItemData(lbMarkedTopics.NewIndex) = frmMain.MediaView1.TopicIndex
    Else
        'Add the group name to the list box
        lbMarkedTopics.AddItem "Group:" & Chr$(9) & lbGroups.List(lbGroups.ListIndex)
    End If
    cmdDeleteAll.Enabled = True
End Sub

Sub cmdClose_Click ()
    Me.Visible = False
End Sub

Sub cmdDelete_Click ()
    'This subroutine deletes entries from the marked topics list box
    
    Dim nTemp As Integer

    'Save the currently highlighted entry
    nTemp = lbMarkedTopics.ListIndex
    'Remove it from the list
    lbMarkedTopics.RemoveItem nTemp
    If lbMarkedTopics.ListCount = 0 Then
        'There are no more items in the list so disable both
        'delete buttons
        cmdDelete.Enabled = False
        cmdDeleteAll.Enabled = False
    Else
        'This takes care of reseting the highlight in the list box
        If nTemp > lbMarkedTopics.ListCount - 1 Then
            'The last item in the list was deleted so move the highlight up one
            nTemp = nTemp - 1
        End If
        'Set the highlight
        lbMarkedTopics.ListIndex = nTemp
    End If
End Sub

Sub cmdDeleteAll_Click ()
    'Clear the list box
    lbMarkedTopics.Clear
    'Disable both delete buttons
    cmdDelete.Enabled = False
    cmdDeleteAll.Enabled = False
End Sub

Sub Form_Load ()
    Dim szBaggageContents As String
    Dim bSuccess As Integer
    Dim lTemp As Long
    ReDim arTabs(0 To 1) As Integer

    Call WaitCursor
    
    'Read the baggage file into szBaggageContents
    bSuccess = ReadBaggageMVP(szBaggageContents)
    'Add the groups to the groups list box
    If bSuccess Then bSuccess = FillGroupListBox(szBaggageContents, frmMark.lbGroups, "group=")
    If Not bSuccess Then
        'There was a problem adding the groups or there were none
        'so disable and grey the appropriate controls
        opt3dAllTopics.Enabled = False
        lblGroups.ForeColor = &H808080
    End If

    'Set tab stops in the marked topics list box
    arTabs(0) = 25
    arTabs(1) = 300
    lTemp = SendMessage(lbMarkedTopics.hWnd, LB_SETTABSTOPS, 2, arTabs(0))
    
    pan3dGroups.Height = lbGroups.Height + 30
    pan3dMarkedTopics = lbMarkedTopics.Height + 30
    Me.Move frmMain.Left + (frmMain.Width - Me.Width) / 2, frmMain.Top + (frmMain.Height - Me.Height) / 2
    Call DefaultCursor
End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
    'This prevents an error condition if the user closes the form with the control menu
    Cancel = (UnloadMode <> 1)
    Me.Visible = False
End Sub

Sub lbGroups_Click ()
    'Enable the Add command button
    cmdAdd.Enabled = True
End Sub

Sub lbMarkedTopics_Click ()
    'Enable the Delete command buttons
    cmdDelete.Enabled = True
    cmdDeleteAll.Enabled = True
End Sub

Sub opt3dAllTopics_Click (Value As Integer)
    'Enable the appropriate controls
    lbGroups.Enabled = True
    If lbGroups.ListIndex = -1 Then cmdAdd.Enabled = False
    'Change the text color to the active state
    lblGroups.ForeColor = &H80000008
End Sub

Sub opt3dCurTopic_Click (Value As Integer)
    'Disable the groups list box
    lbGroups.Enabled = False
    'Change the text color to the disabled state
    lblGroups.ForeColor = &H808080
End Sub

