VERSION 2.00
Begin Form frmMain 
   BackColor       =   &H00C0C0C0&
   Caption         =   "MediaView Title"
   ClientHeight    =   6585
   ClientLeft      =   3015
   ClientTop       =   2610
   ClientWidth     =   9630
   ForeColor       =   &H00C0C0C0&
   Height          =   7515
   Icon            =   MAIN.FRX:0000
   Left            =   2955
   LinkTopic       =   "Form1"
   ScaleHeight     =   439
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   642
   Top             =   1740
   Width           =   9750
   Begin ListBox lbBackList 
      Height          =   420
      Left            =   7920
      TabIndex        =   8
      Top             =   135
      Visible         =   0   'False
      Width           =   585
   End
   Begin Timer tmDelayTimer 
      Enabled         =   0   'False
      Interval        =   200
      Left            =   8580
      Top             =   105
   End
   Begin CommonDialog CMDialog1 
      Left            =   9060
      Top             =   75
   End
   Begin SSPanel pan3dMediaView 
      BevelOuter      =   1  'Inset
      Caption         =   "Panel3D1"
      Height          =   5580
      Left            =   240
      TabIndex        =   7
      Top             =   720
      Width           =   9240
      Begin MediaView MediaView1 
         BackColorNSR    =   &H00FFFFFF&
         BackColorPopup  =   &H00FFFFFF&
         BackColorSR     =   &H00FFFFFF&
         BorderStyle     =   0  'None
         BottomMargin    =   1
         FontZoom        =   100
         Height          =   5535
         Left            =   15
         LeftMargin      =   1
         MediaViewTitle  =   ""
         MediaViewTopic  =   ""
         RightMargin     =   1
         Top             =   15
         TopMargin       =   1
         Width           =   9195
      End
   End
   Begin CommandButton cmdSearch 
      Caption         =   "&Search"
      Height          =   375
      Left            =   4560
      TabIndex        =   6
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton cmdHistory 
      Caption         =   "&History"
      Height          =   375
      Left            =   3480
      TabIndex        =   5
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton cmdBack 
      Caption         =   "&Back"
      Height          =   375
      Left            =   2400
      TabIndex        =   4
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton cmdIndex 
      Caption         =   "&Index"
      Height          =   375
      Left            =   1320
      TabIndex        =   3
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton cmdContents 
      Caption         =   "&Contents"
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton cmdPrev 
      Caption         =   "&<<"
      Enabled         =   0   'False
      Height          =   372
      Left            =   5640
      TabIndex        =   1
      Top             =   120
      Width           =   1092
   End
   Begin CommandButton cmdNext 
      Caption         =   "&>>"
      Enabled         =   0   'False
      Height          =   372
      Left            =   6720
      TabIndex        =   0
      Top             =   120
      Width           =   1092
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFile_Open 
         Caption         =   "&Open..."
      End
      Begin Menu mnuFile_PrintCurTopic 
         Caption         =   "&Print Current Topic..."
      End
      Begin Menu mnuFile_PrintMarkTopic 
         Caption         =   "Print &Marked Topics..."
      End
      Begin Menu mnuFile_PrintAllTopic 
         Caption         =   "Print &All Topics..."
      End
      Begin Menu mnuFile_Exit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuEdit 
      Caption         =   "&Edit"
      Begin Menu mnuEdit_CopyTopic 
         Caption         =   "Copy &Topic"
      End
      Begin Menu mnuEdit_CopySel 
         Caption         =   "&Copy Selection"
      End
      Begin Menu mnuEdit_Search 
         Caption         =   "&Search..."
      End
      Begin Menu mnuEdit_CharStyle 
         Caption         =   "C&haracter Styles..."
      End
   End
   Begin Menu mnuBookmark 
      Caption         =   "B&ookmark"
      Begin Menu mnuBookmark_Define 
         Caption         =   "&Define..."
      End
      Begin Menu mnuBookmark_Mark 
         Caption         =   "&1 "
         Index           =   0
         Visible         =   0   'False
      End
      Begin Menu mnuBookmark_Sep 
         Caption         =   "-"
         Index           =   0
         Visible         =   0   'False
      End
      Begin Menu mnuBookmark_More 
         Caption         =   "&More Bookmarks..."
         Visible         =   0   'False
      End
   End
   Begin Menu mnuTopic 
      Caption         =   "&Topic"
      Begin Menu mnuTopic_Contents 
         Caption         =   "&Contents"
      End
      Begin Menu mnuTopic_Index 
         Caption         =   "&Index..."
      End
      Begin Menu mnuTopic_History 
         Caption         =   "&History..."
      End
      Begin Menu mnuTopic_Back 
         Caption         =   "&Back"
         Enabled         =   0   'False
      End
      Begin Menu mnuTopic_Next 
         Caption         =   "&Next"
      End
      Begin Menu mnuTopic_Prev 
         Caption         =   "&Previous"
      End
      Begin Menu mnuSeperator 
         Caption         =   "-"
         Index           =   0
      End
      Begin Menu mnuTopic_MarkForPrint 
         Caption         =   "&Mark for Print..."
      End
   End
   Begin Menu mnuView 
      Caption         =   "&View"
      Begin Menu mnuView_SearchResults 
         Caption         =   "&Search Results"
         Enabled         =   0   'False
      End
   End
   Begin Menu mnuHighlight 
      Caption         =   "Hi&ghlight"
      Begin Menu mnuHighlight_SearchHits 
         Caption         =   "&Search Hits"
      End
      Begin Menu mnuHighlight_Hotspots 
         Caption         =   "&Hotspots"
         Shortcut        =   ^H
      End
   End
   Begin Menu mnuOptions 
      Caption         =   "&Options"
      Begin Menu mnuOptions_TextColor 
         Caption         =   "&Text Color..."
      End
      Begin Menu mnuOptions_SearchHitColor 
         Caption         =   "&Search Hit Color..."
      End
      Begin Menu mnuOptions_MagText 
         Caption         =   "&Magnify Text..."
      End
   End
   Begin Menu mnuHelp 
      Caption         =   "Hel&p"
      Begin Menu mnuHelp_About 
         Caption         =   "&About VIEWMV.EXE..."
      End
   End
End
Option Explicit

Sub ChangeTextColor ()
    Dim nTemp, hHWnd, hHDC, bSearch, bHotSpot, lpErr As Integer
    Dim rectRect As RECT

    'There is a redraw problem if any highlighting is turned on when
    'changing the text color, so we'll turn them off until we're done.
    bSearch = mnuHighlight_SearchHits.Checked And gblbSearchActive
    If bSearch Then Call mnuHighlight_SearchHits_Click
    bHotSpot = mnuHighlight_Hotspots.Checked
    If bHotSpot Then Call mnuHighlight_Hotspots_Click
    
    'The simple way of forcing the refresh of the new color is to use
    'the following line:
    'MediaView1.TopicIndex = MediaView1.TopicIndex
    'However, that forces a jump and we don't want that as it takes too long.
    'So the following code takes care of the refresh without forcing the jump.
        
    If MediaView1.lpMVSR <> 0 Then
        'There's no way we'll ever get an hWnd to a pop-up because
        'as soon as the user clicks on the menu bar the pop-up will be
        'dismissed.  So the only possibility is to get the hWnd of the SR!
        hHWnd = GetWindow(MediaView1.hWnd, GW_CHILD)
            
        If hHWnd <> 0 Then hHDC = GetDC(hHWnd)
        If (hHWnd <> 0) And (hHDC <> 0) Then
            Call MVSetTextColor(MediaView1.lpMVSR, gbllCurTextColor)
                
            'This takes care of refreshing the SR
            Call GetWindowRect(hHWnd, rectRect)
            rectRect.Bottom = rectRect.Bottom - rectRect.Top
            rectRect.Right = rectRect.Right - rectRect.Left
            rectRect.Left = 0
            rectRect.Top = 0
            nTemp = fMVApplyToDC(MediaView1.lpMVSR, hHDC, rectRect, lpErr)
            If nTemp = 0 Then nTemp = MVError(lpErr, "")
            nTemp = ReleaseDC(hHWnd, hHDC)
        End If
    End If
        
    hHDC = GetDC(MediaView1.hWnd)
    If hHDC <> 0 Then
        If MediaView1.lpMVNSR <> 0 Then
            Call MVSetTextColor(MediaView1.lpMVNSR, gbllCurTextColor)
            hHWnd = hwndMVGetWindow(MediaView1.lpMVNSR)
            'Change Bottom to be the height of the NSR
            rectRect.Bottom = (MediaView1.Height / Screen.TwipsPerPixelY) - rectRect.Bottom
            nTemp = fMVApplyToDC(MediaView1.lpMVNSR, hHDC, rectRect, lpErr)
            If nTemp = 0 Then nTemp = MVError(lpErr, "")
        End If
        nTemp = ReleaseDC(MediaView1.hWnd, hHDC)
    End If
    
    'Turn the highlighting back on if required
    If bSearch Then Call mnuHighlight_SearchHits_Click
    If bHotSpot Then Call mnuHighlight_Hotspots_Click
End Sub

Sub cmdBack_Click ()
    'Let mnuTopic_Back_Click handle this event
    mnuTopic_Back_Click
End Sub

Sub cmdContents_Click ()
    'Let mnuTopic_Contents_Click handle this event
    Call mnuTopic_Contents_Click
End Sub

Sub cmdHistory_Click ()
    'Let mnuTopic_History_Click handle this event
    Call mnuTopic_History_Click
End Sub

Sub cmdIndex_Click ()
    'Let mnuTopic_Index_Click handle this event
    Call mnuTopic_Index_Click
End Sub

Sub cmdNext_Click ()
    'Let mnuTopic_Next_Click handle this event
    Call mnuTopic_Next_Click
End Sub

Sub cmdPrev_Click ()
    'Let mnuTopic_Prev_Click handle this event
    Call mnuTopic_Prev_Click
End Sub

Sub cmdSearch_Click ()
    'Let mnuEdit_Search_Click handle this event
    Call mnuEdit_Search_Click
End Sub

Sub CopyToClipboard (hMem As Integer)
    'This function will copy the text pointed to by the hMem
    'parameter to the clipboard
    
    Dim bFail, nTemp As Integer
    
    'Assume false
    bFail = True
    
    'Clear the clipboard of anything currently in it
    Clipboard.Clear
    'Open the Clipboard
    nTemp = OpenClipboard(Me.hWnd)
    If nTemp = 0 Then
        'Show the error message
        nTemp = ViewMVError(ERR_OPENCLIPBOARD, "")
    Else
        'Set the clipboard data to receive text
        nTemp = SetClipboardData(CF_TEXT, hMem)
        If nTemp = 0 Then
            'Show the error message
            nTemp = ViewMVError(ERR_SETCLIPBOARDDATA, "")
        Else
            'Successful copy
            bFail = False
        End If
        nTemp = CloseClipboard()
    End If
    
    'If the copy was not successful, free the memory
    If bFail Then nTemp = GlobalFree(hMem)
End Sub

Sub Form_Load ()
    Dim nTemp As Integer

    Call WaitCursor
    'Initialize a couple of global variables
    gblhHiliteBrush = 0
    gblnNumMenuBookmarks = 0
    gblhTitle = 0
    
    'Get the current windows text color
    Call GetWinTextColor
    If Command$ <> "" Then
        'There was a command line option given, try to open it
        Call OpenFile(Command$)
    Else
        If App.EXEName = "MAKE" Then
            'Used during testing so I didn't have to choose File/Open every time
            Call OpenFile("C:\MV12KIT\SAMPLE\USA\USA.M12")
        Else
            'No file is open so set the menus and button states
            Call SetMenuAndButtonStates(False, "")
        End If
    End If
    Me.Move (Screen.Width - Me.Width) / 2, (Screen.Height - Me.Height) / 2, 640 * Screen.TwipsPerPixelX, 480 * Screen.TwipsPerPixelY
    Call DefaultCursor
End Sub

Sub Form_Resize ()
    'If not minimized, position the controls appropriately
    If Me.WindowState <> 1 Then
        If Me.Width < 4000 Then Me.Width = 4000
        If Me.Height < 3000 Then Me.Height = 3000
        pan3dMediaView.Move 15, 40, Me.ScaleWidth - 32, Me.ScaleHeight - 56
        MediaView1.Move 30, 30, Screen.TwipsPerPixelX * pan3dMediaView.Width - 60, Screen.TwipsPerPixelY * pan3dMediaView.Height - 60
    End If
End Sub

Sub Form_Unload (Cancel As Integer)
    Dim nTemp As Integer
    
    If gblbSearchActive Then Unload frmResults
    If gblbHistoryActive Then Unload frmHistory
    If gblbIndexActive Then Unload frmKeyword
    Unload frmMark
    'There is an open title so close it
    If gblhTitle <> 0 Then Call TitleClose(gblhTitle)
    'We created a brush during execution of the program so delete it
    If gblhHiliteBrush <> 0 Then nTemp = DeleteObject(gblhHiliteBrush)
End Sub

Sub MediaView1_HotspotClicked (HotSpotType As Integer, HotspotData As Long, Cancel As Integer)
    If HotSpotType = HOTSPOT_HASH Then
        'We have a hotspot so we enable the timer to delay long enough for the
        'VBX to perform the jump
        tmDelayTimer.Enabled = True
    End If
End Sub

Sub mnuBookmark_Define_Click ()
    'Show the define bookmark form
    frmDefineBookmark.Show 1
    Unload frmDefineBookmark
End Sub

Sub mnuBookmark_Mark_Click (Index As Integer)
    Dim nTemp As Integer
    Dim szAddress As String
    Dim szFilename As String

    'Get the MediaView filename
    szFilename = MediaView1.MediaViewTitle
    'Change the filename's extenstion to BMK
    Call ChangeFileExtension(szFilename, BOOKMARKFILE_EXT, True)
    'Initialize the string
    szAddress = String(128, 0)
    'Get the address of the topic with this bookmark
    nTemp = GetPrivateProfileString("BOOKMARKS", "ADDR" & Format$(Index, "0"), "NULL", szAddress, Len(szAddress), szFilename)
    'Strip any nulls from the right of the address - NOTE: Its a string right now
    szAddress = Left$(szAddress, nTemp)
    If szAddress = "NULL" Then
        'Drop the number from the caption for the error message
        nTemp = ViewMVError(ERR_READBMKFILE, Mid$(mnuBookmark_Mark(Index).Caption, 2))
    Else
        Call WaitCursor
        'Set the MediaView to the topic's address
        Call SetMVAddress(frmMain.MediaView1, GetValidlpMV(frmMain.MediaView1), Val(szAddress), 0&)
        Call DefaultCursor
    End If
End Sub

Sub mnuBookmark_More_Click ()
    Call WaitCursor
    'Load the More Bookmarks form
    Load frmMoreBookmarks
    'Add all the bookmark to the list box on the frmMoreBookmarks form
    Call LoadAllBookmarks(frmMoreBookmarks.lbResults)
    Call DefaultCursor
    'Show the form
    frmMoreBookmarks.Show 1
    Unload frmMoreBookmarks
End Sub

Sub mnuEdit_CharStyle_Click ()
    'Show the Character Styles form
    frmCharStyles.Show 1
    Unload frmCharStyles
End Sub

Sub mnuEdit_CopySel_Click ()
    Dim lpErr As Integer
    Dim hMem As Integer

    Call WaitCursor
    'Text in the NSR can not be selected, this is a limitation of the MediaView VBX
    If fMVIsSelected(MediaView1.lpMVSR) = 0 Then
        'No text selected so show the error message
        hMem = ViewMVError(ERR_NOSELECTEDTEXT, "")
    Else
        'Get a handle to the copied text
        hMem = hMVCopySelection(MediaView1.lpMVSR, lpErr)
        If hMem = 0 Then
            'Show the error message
            hMem = MVError(lpErr, "")
        Else
            'Copy the text to the clipboard
            Call CopyToClipboard(hMem)
        End If
    End If
    Call DefaultCursor
End Sub

Sub mnuEdit_CopyTopic_Click ()
    Dim lpErr  As Integer
    Dim hMem As Integer

    Call WaitCursor
    'Get a handle to the text in this topic
    hMem = hMVCopyMedia(MediaView1.lpMVSR, lpErr)
    If hMem = 0 Then
        'Show the error message
        hMem = MVError(lpErr, "")
    Else
        'Copy the text to the clipboard
        Call CopyToClipboard(hMem)
    End If
    Call DefaultCursor
End Sub

Sub mnuEdit_Search_Click ()
    'If there is currently a search active then unload te results form
    If gblbSearchActive Then Unload frmResults
    Load frmSearch
    Unload frmSearch
    'If there were topics found the load the Results form
    If gblbSearchActive Then Load frmResults
End Sub

Sub mnuFile_Exit_Click ()
    Unload Me
End Sub

Sub mnuFile_Open_Click ()
    Call WaitCursor
    CMDialog1.Filename = "*.m12"
    CMDialog1.Filter = "All Files (*.*)|*.*|MediaView (*.m12)|*.m12"
    CMDialog1.FilterIndex = 2
    CMDialog1.Flags = OFN_FILEMUSTEXIST Or OFN_HIDEREADONLY
    CMDialog1.InitDir = App.Path
    CMDialog1.DialogTitle = "File Open"
    CMDialog1.CancelError = True
    Call DefaultCursor
    On Error Resume Next
    CMDialog1.Action = 1
    If Err <> CDERR_CANCEL Then
        On Error GoTo 0
        If UCase$(CMDialog1.Filename) <> UCase$(MediaView1.MediaViewTitle) Then
            Call WaitCursor
            'Open the file chosen in the the common dialog VBX
            Call OpenFile(CStr(CMDialog1.Filename))
            Call DefaultCursor
        End If
    End If
    On Error GoTo 0
End Sub

Sub mnuFile_PrintAllTopic_Click ()
    Call PrintRoutine(PRINT_ALL)
End Sub

Sub mnuFile_PrintCurTopic_Click ()
    Call PrintRoutine(PRINT_CURTOPIC)
End Sub

Sub mnuFile_PrintMarkTopic_Click ()
    Call PrintRoutine(PRINT_MARKED)
End Sub

Sub mnuHelp_About_Click ()
    'Show the About form modally
    frmAbout.Show 1
    Unload frmAbout
End Sub

Sub mnuHighlight_Hotspots_Click ()
    Dim nTemp, lpErr As Integer
    
    mnuHighlight_Hotspots.Checked = Not mnuHighlight_Hotspots.Checked
    If MediaView1.lpMVNSR <> 0 Then
        'Set the highlights for the NSR
        nTemp = fMVHighlightHotspots(MediaView1.lpMVNSR, CInt(mnuHighlight_Hotspots.Checked), lpErr)
        'fMVHighlightHotSpots returns 0 if there are no hotspots so we must check
        'the lpErr value to avoid starting an unnecessary error message dialog box.
        If lpErr <> wERRS_NONE Then nTemp = MVError(lpErr, "")
    End If
    If MediaView1.lpMVSR <> 0 Then
        'Set the highlights for the SR
        nTemp = fMVHighlightHotspots(MediaView1.lpMVSR, CInt(mnuHighlight_Hotspots.Checked), lpErr)
        'fMVHighlightHotSpots returns 0 if there are no hotspots so we must check
        'the lpErr value to avoid starting an unnecessary error message dialog box.
        If lpErr <> wERRS_NONE Then nTemp = MVError(lpErr, "")
    End If
End Sub

Sub mnuHighlight_SearchHits_Click ()
    'Swap the highlight
    mnuHighlight_SearchHits.Checked = Not mnuHighlight_SearchHits.Checked
    'Show/Hide the search hits
    Call ShowSearchHits(CInt(frmMain.mnuHighlight_SearchHits.Checked))
End Sub

Sub mnuOptions_MagText_Click ()
    'Show Magnify form modally
    frmMagnify.Show 1
    Unload frmMagnify
End Sub

Sub mnuOptions_SearchHitColor_Click ()
    Dim hOldBrush, hNewBrush, nTemp, lpErr  As Integer
    
    Call WaitCursor
    CMDialog1.CancelError = False
    CMDialog1.Color = gblCurHiliteColor
    CMDialog1.Flags = CC_RGBINIT
    Call DefaultCursor
    CMDialog1.Action = 3
    
    If CMDialog1.Color <> gblCurHiliteColor Then
        CMDialog1.Color = CMDialog1.Color Xor &HFFFFFF
        'Create a new brush with the chosen color
        hNewBrush = CreateSolidBrush(CMDialog1.Color)
        If hNewBrush = 0 Then
            'Show the error message
            nTemp = ViewMVError(ERR_CREATEOBJECT, "Setting Highlight Color")
        Else
            Call WaitCursor
            If MediaView1.lpMVNSR <> 0 Then
                'Set the new highlight color in NSR
                hOldBrush = hMVSetHighlightLook(MediaView1.lpMVNSR, hNewBrush, R2_XORPEN, lpErr)
                'hMVSetHighlightLook returns 0 under certain conditions so we must check
                'the lpErr value to avoid starting an unnecessary error message dialog box.
                If lpErr <> wERRS_NONE Then nTemp = MVError(lpErr, "")
            End If
            If MediaView1.lpMVSR <> 0 Then
                'Set the new highlight color in SR
                hOldBrush = hMVSetHighlightLook(MediaView1.lpMVSR, hNewBrush, R2_XORPEN, lpErr)
                'hMVSetHighlightLook returns 0 under certain conditions so we must check
                'the lpErr value to avoid starting an unnecessary error message dialog box.
                If lpErr <> wERRS_NONE Then nTemp = MVError(lpErr, "")
            End If
            If gblhHiliteBrush <> 0 Then
                'Delete any old brush that we have created
                hOldBrush = DeleteObject(gblhHiliteBrush)
            End If
            'Save the handle to the new brush
            gblhHiliteBrush = hNewBrush
            'Save the new highlight color
            gblCurHiliteColor = CMDialog1.Color Xor &HFFFFFF
            Call DefaultCursor
        End If
    End If
End Sub

Sub mnuOptions_TextColor_Click ()
    Call WaitCursor
    CMDialog1.CancelError = False
    CMDialog1.Color = gbllCurTextColor
    CMDialog1.Flags = CC_RGBINIT
    Call DefaultCursor
    CMDialog1.Action = 3
    
    If CMDialog1.Color <> gbllCurTextColor Then
        Call WaitCursor
        'Save the new color
        gbllCurTextColor = CMDialog1.Color
        'Change the text color
        Call ChangeTextColor
        Call DefaultCursor
    End If
End Sub

Sub mnuTopic_Back_Click ()
    Call WaitCursor
    'Set the MediaView to the previously visited topic
    MediaView1.TopicIndex = lbBackList.ItemData(0)
    'Remove it from the Back list box
    lbBackList.RemoveItem 0
    'The Back button and menu should only be enabled if there are items in te list box
    cmdBack.Enabled = lbBackList.ListCount > 0
    mnuTopic_Back.Enabled = cmdBack.Enabled
    'Set the app up for the New topic
    Call NewTopic(True)
    Call DefaultCursor
End Sub

Sub mnuTopic_Contents_Click ()
    Dim lpMV As Long
    
    Call WaitCursor
    'Get a valid lpMV
    lpMV = GetValidlpMV(MediaView1)
    'Set the topic address in MediaView
    Call SetMVAddress(MediaView1, lpMV, addrGetContents(gblhTitle), 0&)
    Call DefaultCursor
End Sub

Sub mnuTopic_History_Click ()
    frmHistory.Show
End Sub

Sub mnuTopic_Index_Click ()
    Load frmIndex
    Unload frmIndex
    'If the user completed a keyword search show the results
    If gblbIndexActive Then frmKeyword.Visible = True
End Sub

Sub mnuTopic_MarkForPrint_Click ()
    frmMark.Show 1
End Sub

Sub mnuTopic_Next_Click ()
    Dim lpMV As Long
    
    Call WaitCursor
    'Get a valid lpMV
    lpMV = GetValidlpMV(MediaView1)
    'Set the topic address in the MediaView
    Call SetMVAddress(MediaView1, lpMV, addrMVGetNext(lpMV), 0&)
    Call DefaultCursor
End Sub

Sub mnuTopic_Prev_Click ()
    Dim lpMV As Long
    
    Call WaitCursor
    'Get a valid lpMV
    lpMV = GetValidlpMV(MediaView1)
    'Set the topic address in the MediaView
    Call SetMVAddress(MediaView1, lpMV, addrMVGetPrev(lpMV), 0&)
    Call DefaultCursor
End Sub

Sub mnuView_SearchResults_Click ()
    frmResults.WindowState = 0
End Sub

Sub OpenFile (szFilename As String)
    'This function sets alll the necessary fields and sets up the app when
    'a new title is opened from the File/Open menu
    
    Dim szTitle As String
    Dim lTemp As Long

    'Set the new title name
    MediaView1.MediaViewTitle = szFilename
    'Set the intitial search highlighting color
    gblCurHiliteColor = RGB(0, 0, 0)
    'Set the globally used handle to the open title
    gblhTitle = TitleOpen(szFilename)
    
    'Initialize the string
    szTitle = String(51, 0)
    'Get the title's name
    lTemp = TitleGetInfo(gblhTitle, TTLINF_TITLE, CLng(Len(szTitle)), szTitle)
    If lTemp <> -1 Then
        'Set the caption to the title name
        Me.Caption = Left$(szTitle, lTemp)
    Else
        'Couldn't get the title name, so set the caption to the file name
        Me.Caption = szFilename
    End If
    
    'Set the initial button and menu states
    Call SetMenuAndButtonStates(True, szFilename)
    
    'Unload any forms currently loaded
    If gblbHistoryActive Then Unload frmHistory
    If gblbSearchActive Then Unload frmResults
    If gblbIndexActive Then Unload frmKeyword
    Unload frmMark
    
    'Set text color to currently chosen color
    Call ChangeTextColor
    
    'Reset history array
    ReDim gblarHistoryList(0)
    gblarHistoryList(0).szTopicTitle = MediaView1.MediaViewTopic
    gblarHistoryList(0).lTopicNum = MediaView1.TopicIndex
    
    'Clear the back list box
    lbBackList.Clear
End Sub

Sub PrintAllTopics (hHDC As Integer)
    Dim hTListTemp1 As Integer
    Dim hTListTemp2 As Integer
    Dim hTList As Integer
    Dim nTemp As Integer
    Dim lTemp As Long
    
    'This will create a TopicList containing all topics in an M12
    Call WaitCursor
    lTemp = 0
    'Get a handle to a toic list containing only the first topic
    hTList = TopicListFromTopicNo(gblhTitle, lTemp)
    If hTList = 0 Then
        'Show the error message
        nTemp = ViewMVError(ERR_TLFATAL, CStr(lTemp))
    Else
        'Step through the remaining topics
        For lTemp = 1 To MediaView1.MaxTopics - 1
            'Set the first temporary topic list
            hTListTemp1 = hTList
            'Get a handle to a topic list containing only the next topic
            hTListTemp2 = TopicListFromTopicNo(gblhTitle, lTemp)
            If hTListTemp2 = 0 Then
                'Show the error message
                nTemp = ViewMVError(ERR_TLCREATE, CStr(lTemp))
            Else
                'Combine the two topic lists
                hTList = TopicListCombine(TL_OR, hTListTemp1, hTListTemp2, False)
                If hTList = 0 Then
                    'There was an error, so reset the hTList variable
                    hTList = hTListTemp1
                    'Show the error message
                    nTemp = ViewMVError(ERR_TLCOMBINE, "")
                Else
                    'The combine was successful, so we can safely
                    'destroy the first temporary topic list
                    Call TopicListDestroy(hTListTemp1)
                End If
                'Whether or not the combine is successful, we always
                'destory the second temporary topic list
                Call TopicListDestroy(hTListTemp2)
            End If
        Next lTemp
        
        'We now have a topic list of all the topics in the title, so print it
        Call PrintTopicList(hHDC, hTList)
        'Destory the topic list
        Call TopicListDestroy(hTList)
        Call DefaultCursor
    End If
End Sub

Sub PrintMarkedTopics (hHDC As Integer)
    'This function prints the topics marked for printing
    
    Dim nTemp, nStartPos, nErr, hTListTemp1 As Integer
    Dim hTListTemp2 As Integer
    Dim hTList As Integer
    Dim szTemp As String

    'Are there any marked topics??
    If frmMark.lbMarkedTopics.ListCount = 0 Then
        'Show the error message
        nErr = ViewMVError(ERR_NOMARKEDTOPICS, "")
    Else
        Call WaitCursor
        nStartPos = Len("Group:") + 2
        'Get first one
        'Find out if Topic or Group
        If Left$(frmMark.lbMarkedTopics.List(nTemp), 1) = "T" Then
            'It is a topic, so load a topic list containing just that topic
            hTList = TopicListFromTopicNo(gblhTitle, frmMark.lbMarkedTopics.ItemData(0))
        Else
            'It is a group, so get the position of the group name in the list
            'Remember, the group names are stored in the list too, but separated by a
            'large tab so that they are not visible
            nTemp = InStr(nStartPos, frmMark.lbMarkedTopics.List(nTemp), Chr$(9)) + 1
            'Get the name of the group
            szTemp = Mid$(frmMark.lbMarkedTopics.List(0), nTemp)
            'Load a topic list containing all the topics in this group
            hTList = TopicListLoad(gblhTitle, szTemp)
        End If
        If hTList = 0 Then
            'Show the error message
            nErr = ViewMVError(ERR_TLFATAL, "")
        Else
            'Step thorough the remaining items in the list box if any
            For nTemp = 1 To frmMark.lbMarkedTopics.ListCount - 1
                'Set the first temporary topic list
                hTListTemp1 = hTList
                'Find out if Topic or Group
                If Left$(frmMark.lbMarkedTopics.List(nTemp), 1) = "T" Then
                    'Load a topic list containing only this topic
                    hTListTemp2 = TopicListFromTopicNo(gblhTitle, frmMark.lbMarkedTopics.ItemData(nTemp))
                Else
                    'Load a topic list from a topic group name
                    'The second parameter here is kind of complicated, so see the example above
                    'on loading a topic list from a group name
                    hTListTemp2 = TopicListLoad(gblhTitle, Mid$(frmMark.lbMarkedTopics.List(nTemp), InStr(nStartPos, frmMark.lbMarkedTopics.List(nTemp), Chr$(9)) + 1))
                End If
                If hTListTemp2 = 0 Then
                    'Show the error message
                    nErr = ViewMVError(ERR_TLCREATE, "")
                Else
                    'Combine the topic lists
                    hTList = TopicListCombine(TL_OR, hTListTemp1, hTListTemp2, False)
                    If hTList = 0 Then
                        'There was an error, so reset the hTList variable
                        hTList = hTListTemp1
                        'Show the error message
                        nErr = ViewMVError(ERR_TLCOMBINE, "")
                    Else
                        'We can safely destory the first temporary topic list
                        Call TopicListDestroy(hTListTemp1)
                    End If
                    'We can always destroy the second temporary topic list
                    Call TopicListDestroy(hTListTemp2)
                End If
            Next nTemp
            
            'We have a complete topic list , so print it
            Call PrintTopicList(hHDC, hTList)
            'Destroy the topic list
            Call TopicListDestroy(hTList)
        End If
        Call DefaultCursor
    End If
End Sub

Sub PrintRoutine (nChoice As Integer)
    'This subroutine prints either a the current topic using
    'the VBX's PrintTopic method or will use the common dialog VBX
    'to get a printer hDC to pass on the the appropriate function

    Dim szTitle As String
    
    If nChoice = PRINT_CURTOPIC Then
        'Printing the current topic, use the VBX's PrintTopic method
        MediaView1.PrintTopic = MediaView1.TopicIndex
    Else
        CMDialog1.CancelError = False
        CMDialog1.PrinterDefault = False
        CMDialog1.Flags = PD_NOSELECTION Or PD_RETURNDC Or PD_NOPAGENUMS Or PD_PRINTSETUP
        CMDialog1.Action = 5

        If CMDialog1.hDC <> 0 Then
            'The user chose a printer so pass the hDC to the appropriate function
            If nChoice = PRINT_ALL Then
                Call PrintAllTopics(CInt(CMDialog1.hDC))
            Else
                Call PrintMarkedTopics(CInt(CMDialog1.hDC))
            End If
        End If
    End If
End Sub

Sub PrintTopicList (hHDC As Integer, hTList As Integer)
    'This subroutine calls the MediaView API's to print a topic list
    
    Dim hMVName, hTopicName, nTemp, lpErr As Integer
    Dim lIndex, addrTopic, va As Long
    Dim lpMVNew As Long
    Dim lpszName As Long
    Dim rcPage As RECT
    Dim rcPrint As RECT
    Dim dblva As Double
    Dim diDocInfo As DOCINFO
    Dim szTemp As String

    'By getting the number of pixels per logical vertical inch and setting it
    'to the left field we get a 1 inch left margin. The same logic applies for
    'the top margin.
    rcPage.Left = GetDeviceCaps(hHDC, LOGPIXELSX)
    rcPage.Top = GetDeviceCaps(hHDC, LOGPIXELSY)
    'Set the right and bottom margins to 1 inch too
    rcPage.Right = GetDeviceCaps(hHDC, HORZRES) - rcPage.Left
    rcPage.Bottom = GetDeviceCaps(hHDC, VERTRES) - rcPage.Top
    
    'Get a valid lpMV to the current MediaView
    lpMVNew = GetValidlpMV(MediaView1)
    'Duplicate the current MediaView
    lpMVNew = lpMVDuplicate(lpMVNew, lpErr)
    If lpMVNew = 0& Then
        'Show the error message
        nTemp = MVError(lpErr, "")
    Else
        'This is subject to change in future versions of Windows!!
        diDocInfo.cbSize = 10
        'Initialize the string
        szTemp = String$(31, 0)
        'Set the lpszDocName field
        'NOTE: the lstrcpy not only copies string2 into string1 but also returns
        'a pointer to string1!  Kinda handy, huh??
        diDocInfo.lpszDocName = lstrcpy(szTemp, Left$(Me.Caption, Len(szTemp)))
        'This parameter would be set to a pointer to a string containging a valid
        'filename if we were printing to a file
        diDocInfo.lpszOutput = 0&
        'Start the documant
        nTemp = StartDoc(hHDC, diDocInfo)
        'Step through the topic list
        For lIndex = 0 To TopicListLength(hTList) - 1
            'Convert the topic number to an address
            addrTopic = addrConvertTopicNumber(gblhTitle, TopicListLookup(hTList, lIndex))
            If addrTopic = ADDRNIL Then
                'Show the error message
                nTemp = ViewMVError(ERR_BADADDRESS, CStr(TopicListLookup(hTList, lIndex)))
            Else
                'Convert the address to a virtual address
                dblva = vaConvertAddr(gblhTitle, addrTopic)
                'Get he first 4 bytes of the 8 byte double
                va = GetHiFromDouble(dblva)
                If va = VANIL Then
                    'Show the error message
                    nTemp = ViewMVError(ERR_BADVA, CStr(addrTopic))
                Else
                    'Set the address for the non-scrolling region
                    nTemp = fMVSetAddress(lpMVNew, va, 0, 0, lpErr)
                    'Its possible that this topic has no NSR, in which case
                    'nTemp would be 0 and lpERR would be wERRS_NOTOPIC.  Since
                    'I know I have a valid address I ignore this case and contiue.
                    'NOTE: Even if nTemp returns a zero, the address does get set
                    'so we can get the name of the topic with hMVGetName.
                    If (nTemp = 0) And (lpErr <> wERRS_NOTOPIC) Then
                        'Show the error message
                        nTemp = MVError(lpErr, CStr(va))
                    Else
                        'Get a handle to the topic name
                        hTopicName = hMVGetName(lpMVNew)
                        If hTopicName = 0 Then
                            'If the topic has no name use a default string
                            frmPrinting.lblTopicName.Caption = "<Untitled Topic>"
                        Else
                            'Lock the memory
                            lpszName = GlobalLock(hTopicName)
                            'Initialize the string
                            szTemp = String$(128, 0)
                            'Copy the string
                            lpszName = lstrcpy(szTemp, lpszName)
                            'Unlock the memory
                            nTemp = GlobalUnlock(hTopicName)
                            'Free the memory
                            nTemp = GlobalFree(hTopicName)
                            'Set the caption on the print status form
                            'NOTE: This will load the form if it was not already loaded
                            frmPrinting.lblTopicName.Caption = RTrim$(szTemp)
                        End If
                        'Refresh the print status form
                        frmPrinting.Refresh
                        
                        'Set the initial printing rectangle to be the whole page
                        'less the margins
                        rcPrint = rcPage
                        'Start the page
                        nTemp = StartPage(hHDC)
                        If fMVHasNSR(lpMVNew) <> 0 Then
                            'We have an NSR so use MVVBHELP.DLL to print it
                            'NOTE: The reason the fMVPrintMediaHelper is needed is that
                            'the MediaView fMVPrintMedia API takes a RECT structure and not a LPRECT
                            'as the 3rd parameter, since we can only pass LPRECT from VB, I use
                            'the DLL to convert the LPRECT to a RECT and pass it on to the MediaView API.
                            nTemp = fMVPrintMediaHelper(lpMVNew, hHDC, rcPage, rcPrint, 0&, 0&, lpErr)
                            'Show the error message if neeeded
                            If nTemp = 0 Then nTemp = MVError(lpErr, "")
                            'In the C sample the need for the following line was listed as a bug.
                            'I didn't have the time to check to make sure so I left it here just in case.
                            rcPrint.Bottom = rcPage.Bottom
                        End If
            
                        'Set the address for the scrolling region
                        nTemp = fMVSetAddress(lpMVNew, va, 1, 0, lpErr)
                        'There may not be a SR in which case lpERR would get set
                        'to wERRS_NOTOPIC, but there is no reason to bring up an error message
                        If (nTemp = 0) And (lpErr <> wERRS_NOTOPIC) Then
                            'Show the error message
                            nTemp = MVError(lpErr, CStr(va))
                        Else
                            'Make sure there is an SR
                            If fMVHasSR(lpMVNew) <> 0 Then
                                'Print the SR
                                nTemp = fMVPrintMediaHelper(lpMVNew, hHDC, rcPage, rcPrint, 0&, 0&, lpErr)
                                'Show the error message if neeeded
                                If nTemp = 0 Then nTemp = MVError(lpErr, "")
                            End If
                        End If
                        'End the page
                        nTemp = EndPage(hHDC)
                    End If
                End If
            End If
        Next lIndex
        Unload frmPrinting
        'End the document
        nTemp = EndDocAPI(hHDC)
        'Delete the duplicate MediaView
        Call MVDelete(lpMVNew)
    End If
End Sub

Sub SetMenuAndButtonStates (bState As Integer, szFilename As String)
    'This subroutine sets the menu and button states for the app
    
    mnuEdit.Visible = bState
    mnuBookmark.Visible = bState
    mnuTopic.Visible = bState
    mnuView.Visible = bState
    mnuHighlight.Visible = bState
    mnuOptions.Visible = bState
    mnuFile_PrintCurTopic.Visible = bState
    mnuFile_PrintAllTopic.Visible = bState
    mnuFile_PrintMarkTopic.Visible = bState
    cmdContents.Enabled = bState
    cmdIndex.Enabled = bState
    cmdBack.Enabled = bState
    cmdHistory.Enabled = bState

    'Special case the Back button and menu as this only
    'get called upon start up or a file open
    cmdBack.Enabled = False
    mnuTopic_Back.Enabled = False
    
    'Assume no full text index and then check
    mnuView_SearchResults.Enabled = False
    cmdSearch.Enabled = False
    mnuEdit_Search.Enabled = False
    If bState And (TitleGetInfo(gblhTitle, TTLINF_HASINDEX, 0&, 0&) = 1) Then
        cmdSearch.Enabled = True
        mnuEdit_Search.Enabled = True
    End If
    
    If bState Then
        Call SetPrevNext
    Else
        cmdPrev.Enabled = False
        cmdNext.Enabled = False
    End If

    'Take care of bookmark menu
    If bState Then
        If gblnNumMenuBookmarks <> 0 Then Call DestroyBookmarkMenu
        Call LoadBookmarkMenu
    End If
End Sub

Sub tmDelayTimer_Timer ()
    'This takes care of setting up the app after a
    'hotspot was clicked on within the VBX
    
    tmDelayTimer.Enabled = False
    'Set up the app after the new topic has been displayed
    Call NewTopic(False)
End Sub

