VERSION 2.00
Begin Form frmIndex 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Keyword Index"
   ClientHeight    =   3570
   ClientLeft      =   2775
   ClientTop       =   2970
   ClientWidth     =   6045
   Height          =   4095
   Left            =   2715
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3570
   ScaleWidth      =   6045
   Top             =   2505
   Width           =   6165
   Begin CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   405
      Left            =   4245
      TabIndex        =   10
      Top             =   1065
      Width           =   1575
   End
   Begin CommandButton cmdOK 
      Caption         =   "&OK"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   405
      Left            =   4245
      TabIndex        =   9
      Top             =   450
      Width           =   1575
   End
   Begin SSPanel pan3dKeywordGroup 
      BevelOuter      =   1  'Inset
      Height          =   330
      Left            =   195
      TabIndex        =   7
      Top             =   3120
      Width           =   3735
      Begin ComboBox cbKeywordGroup 
         Height          =   300
         Left            =   15
         Style           =   2  'Dropdown List
         TabIndex        =   8
         Top             =   15
         Width           =   3705
      End
   End
   Begin SSPanel pan3dKeywordList 
      BevelOuter      =   1  'Inset
      Height          =   1625
      Left            =   195
      TabIndex        =   4
      Top             =   1125
      Width           =   3735
      Begin ListBox lbKeywordList 
         Height          =   1590
         Left            =   15
         Sorted          =   -1  'True
         TabIndex        =   5
         Top             =   15
         Width           =   3705
      End
   End
   Begin SSPanel pan3dKeywordText 
      BevelOuter      =   1  'Inset
      Height          =   375
      Left            =   195
      TabIndex        =   1
      Top             =   405
      Width           =   3735
      Begin TextBox ebKeyword 
         Height          =   345
         Left            =   15
         TabIndex        =   2
         Top             =   15
         Width           =   3705
      End
   End
   Begin Label lblKeywordGroup 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "&Keyword Group:"
      Height          =   240
      Left            =   195
      TabIndex        =   6
      Top             =   2880
      Width           =   2670
   End
   Begin Label lblKeywordList 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "&Index List:"
      Height          =   240
      Left            =   195
      TabIndex        =   3
      Top             =   900
      Width           =   1635
   End
   Begin Label lblKeywordText 
      BackColor       =   &H00C0C0C0&
      BackStyle       =   0  'Transparent
      Caption         =   "&Type a word or select one from the list:"
      Height          =   240
      Left            =   195
      TabIndex        =   0
      Top             =   180
      Width           =   3630
   End
End
Option Explicit

Dim frmgblhWheel As Integer

Sub cbKeywordGroup_Click ()
    Call WaitCursor
    'Fill the keyword list box
    Call FillKeywordList
    If ebKeyword.Text <> "" Then
        'Change the text in the ebKeyword edit box
        Call ebKeyword_KeyUp(0, 0)
    End If
    Call DefaultCursor
End Sub

Sub cmdCancel_Click ()
    'Hide the form so execution in calling subroutine can continue
    Me.Visible = False
End Sub

Sub cmdOK_Click ()
    'Let lbKeywordList_DblClick handle this event
    Call lbKeywordList_DblClick
End Sub

Sub ebKeyword_KeyUp (KeyCode As Integer, Shift As Integer)
    'Enable the OK button if supposed to
    cmdOK.Enabled = (ebKeyword.Text <> "")
    'Set the list box index to the closest matching entry to the text in the ebKeyword edit box
    lbKeywordList.ListIndex = WordWheelPrefix(frmgblhWheel, ebKeyword.Text)
End Sub

Sub FillKeywordList ()
    Dim szTemp As String
    Dim lIndex, lWheelLen As Long
    Dim nTemp As Integer

    'Close any open word wheel
    If frmgblhWheel <> 0 Then WordWheelClose (frmgblhWheel)
    'Clear the list box
    lbKeywordList.Clear
    
    'Set the keyword name
    szTemp = "|" & Chr$(cbKeywordGroup.ItemData(cbKeywordGroup.ListIndex))
    'Open the word wheel
    frmgblhWheel = WordWheelOpen(frmMain.MediaView1.MediaViewTitle, szTemp)
    If frmgblhWheel = 0 Then
        'Show the error message
        nTemp = ViewMVError(ERR_WWOPEN, CStr(cbKeywordGroup.List(cbKeywordGroup.ListIndex)))
    Else
        'Get the length of the word wheel
        lWheelLen = WordWheelLength(frmgblhWheel)
        If lWheelLen = 0 Then
            'Show the error message
            nTemp = ViewMVError(ERR_NOKEYWORDS, CStr(cbKeywordGroup.List(cbKeywordGroup.ListIndex)))
        Else
            For lIndex = 0 To lWheelLen - 1
                'Step through the word wheel
                'Initialize the string
                szTemp = String(128, 0)
                'Get the keyword name
                nTemp = WordWheelLookup(frmgblhWheel, lIndex, szTemp, Len(szTemp))
                If nTemp = 1 Then
                    'Show the error message
                    nTemp = ViewMVError(ERR_WWLOOKUP, Format$(lIndex, "0"))
                Else
                    'Add the keyword to the list box
                    lbKeywordList.AddItem szTemp
                End If
            Next lIndex
            lbKeywordList.ListIndex = 0
        End If
    End If
End Sub

Sub Form_Load ()
    Dim bSuccess, nTemp As Integer
    Dim szBaggageContents As String
    
    Call WaitCursor
    
    gblbIndexActive = False
    'Read the baggage file into the szBaggageContents string
    bSuccess = ReadBaggageMVP(szBaggageContents)
    'Fill the cbKeywordGroup combo box with the keyword group titles
    If bSuccess Then bSuccess = FillGroupListBox(szBaggageContents, frmIndex.cbKeywordGroup, "keyword=")
    If Not bSuccess Then
        Call DefaultCursor
        'Show the error message
        nTemp = ViewMVError(ERR_NOKEYWORDSINTITLE, "")
    Else
        pan3dKeywordList.Height = lbKeywordList.Height + 30
        Me.Move frmMain.Left + (frmMain.Width - Me.Width) / 2, frmMain.Top + (frmMain.Height - Me.Height) / 2
        'Intitialize the global handle to the current word wheel
        frmgblhWheel = 0
        'This will fill the lbKeywordList list box with the keywords in the first keyword group
        cbKeywordGroup.ListIndex = 0
        Call DefaultCursor
        Me.Show 1
    End If
End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)
    'Prevents an error if user closes form from control menu
    Cancel = (UnloadMode <> 1)
    Me.Visible = False
End Sub

Sub Form_Unload (Cancel As Integer)
    'Close any open word wheel
    If frmgblhWheel <> 0 Then Call WordWheelClose(frmgblhWheel)
End Sub

Sub lbKeywordList_Click ()
    'This prevents the ebKeyword edit box from being set to the first
    'entry in the lbKeywordList list box when opening the form
    If TypeOf Screen.ActiveForm.ActiveControl Is ListBox Then
        'Enable of OK button
        cmdOK.Enabled = True
        'Set the ebKeyword text to that of the selected list box entry
        ebKeyword.Text = lbKeywordList.List(lbKeywordList.ListIndex)
    End If
End Sub

Sub lbKeywordList_DblClick ()
    Dim nCount, nIndex, nTemp As Integer
    Dim szTemp As String
    Dim lTemp, arlTopicAddress() As Long
    
    Call WaitCursor
    'Get the text of the select entry in the list box
    szTemp = lbKeywordList.List(lbKeywordList.ListIndex)
    'Get the number of topics with the selected keyword
    nCount = KeyIndexGetCount(frmgblhWheel, szTemp)
    If nCount = -1 Then
        'Show the error message
        nTemp = ViewMVError(ERR_BADKEYCOUNT, szTemp)
    Else
        'Redimension the array to hold as many topic addresses as necessary
        ReDim arlTopicAddress(0 To nCount - 1)
        'Load the topic address array with the topic addresses
        lTemp = KeyIndexGetAddrs(frmgblhWheel, szTemp, 0, nCount, arlTopicAddress(0))
        If lTemp <= 0 Then
            'Show the error message
            nTemp = ViewMVError(ERR_BADKEYGETADDRESS, szTemp)
        Else
            Load frmKeyword
            'Set the caption of the listed topics form to the selected keyword
            frmKeyword.lblKeyword.Caption = szTemp
            For nIndex = 0 To nCount - 1
                'Step through the topics
                szTemp = String(128, 0)
                'Get the title of a topic given its address
                nTemp = TitleGetInfo(gblhTitle, TTLINF_ADDRTITLE, arlTopicAddress(nIndex), szTemp)
                If nTemp <> 0 Then
                    'Show the error message
                    nTemp = ViewMVError(ERR_TOPICTITLE, CStr(arlTopicAddress(nIndex)))
                Else
                    If szTemp = "" Then
                        'If no title was given to the topic show a default string
                        frmKeyword.lbResults.AddItem "<Untitled Topic>"
                    Else
                        'Add the topic title to the list box
                        frmKeyword.lbResults.AddItem szTemp
                    End If
                    'Add the topic address to the list box
                    frmKeyword.lbResults.ItemData(frmKeyword.lbResults.NewIndex) = arlTopicAddress(nIndex)
                End If
            Next nIndex
            Me.Visible = False
            gblbIndexActive = True
        End If
    End If
    Call DefaultCursor
End Sub

