/* these define the offsets to the Pane data stored in the window structure */
#define GWL_PANE_LPMV		0
#define GWL_PANE_TYPE		sizeof(long)
#define GWL_PANE_PARENT	2*sizeof(long)
#define GWL_PANE_POLY		3*sizeof(long)
#define EXTRA_PANE_SIZE	4*sizeof(long)

/* and MACROS for getting and setting the data from the window */
#define GetPaneMV(hWnd) (LPMV)GetWindowLong(hWnd, GWL_PANE_LPMV)
#define GetPaneType(hWnd) (int)GetWindowLong(hWnd, GWL_PANE_TYPE)
#define GetPaneParent(hWnd) (HWND)GetWindowLong(hWnd, GWL_PANE_PARENT)
#define GetPanePolygon(hWnd) (int)GetWindowLong(hWnd, GWL_PANE_POLY)
#ifdef WIN32
#define GetPaneInstance(hWnd) (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE)
#else
#define GetPaneInstance(hWnd) (HINSTANCE)GetWindowWord(hWnd, GWW_HINSTANCE)
#endif // WIN32

#define SetPaneMV(hWnd, lpMV) SetWindowLong(hWnd, GWL_PANE_LPMV, (long)lpMV)
#define SetPaneType(hWnd, type) SetWindowLong(hWnd, GWL_PANE_TYPE, (long)type)
#define SetPaneParent(hWnd, hParent) SetWindowLong(hWnd, GWL_PANE_PARENT, (long)hParent)
#define SetPanePolygon(hWnd, ptype) SetWindowLong(hWnd, GWL_PANE_POLY, (long)ptype)

/* pane type ... the first 2 correspond to the subTopic identifiers */
#define NSR_PANE		0
#define SR_PANE		1
#define POPUP_PANE	2001

#if defined(_DEBUG)
#define DBLOADDS _loadds
#else
#define DBLOADDS
#endif

/* layout polygon types .... define new ones here */
#define POLY_NONE		0
#define POLY_DIAMOND	1
