{------------------------------------------------------------------}
{-----------PRINTINFO DEMO v0.5----(c) Jacques Oberto 1994---------}
{------------------------------------------------------------------}
{-----------------------------------E-Mail: oberto@ibpc.fr---------}
{------------------------------------------------------------------}
{-----------PRNINFO.PAS retrieves information on the current-------}
{-----------------------printer installed under Windows and--------}
{-----------------------displays it in a dialog--------------------}
{------------------------------------------------------------------}

program PrnInfo;

{$R PrnInfo.res}

uses WinProcs, WinTypes, Strings, OWindows, ODialogs, Ctl3D;
const
cm_Info = 200;
id_static = 2999;
type
  Tsize = record  { so that we don't have to use unit WIN31.PAS }
       cx: integer;
       cy: integer;
       end;
  TSizes = record
       W : Array[0..30] of Char;
       H : Array[0..30] of Char;
       end;
  TPrintInfoApp = object(TApplication)
    procedure InitMainWindow; virtual;
    end;
  PrintInfoRecord = record    { Holds all the useful printer information }
            Printer_Driver : Array[0..30] of Char;
              Printer_Type : Array[0..30] of Char;
              Printer_Port : Array[0..30] of Char;
                   _Orient : Array[0..30] of Char;
                Paper_Size : Array[0..30] of Char;
               Paper_Width : Array[0..30] of Char;
              Paper_Height : Array[0..30] of Char;
             Print_quality : Array[0..30] of Char;
              Y_Resolution : Array[0..30] of Char;
                 Max_X_Res : Array[0..30] of Char;
                 Max_Y_Res : Array[0..30] of Char;
             Total_X_Width : Array[0..30] of Char;
            Total_Y_Height : Array[0..30] of Char;
                  X_Offset : Array[0..30] of Char;
                  Y_Offset : Array[0..30] of Char;
                Bits_Pixel : Array[0..30] of Char;
                  N_Planes : Array[0..30] of Char;
                   N_Fonts : Array[0..30] of Char;
                 N_Brushes : Array[0..30] of Char;
                    N_Pens : Array[0..30] of Char;
                  N_Colors : Array[0..30] of Char;
  end;

  PPrintInfoDialog = ^TPrintInfoDialog;
    TPrintInfoDialog = object(TDialog)
     TransferRecord: PrintInfoRecord;
    constructor Init(AParent: PWindowsObject; ATitle:PChar);
    procedure OK(var Msg:TMessage); virtual id_First + id_OK;
  end;

  PPrintInfoWindow = ^TPrintInfoWindow;
  TPrintInfoWindow = object(TWindow)
    constructor Init;
    procedure GetWindowClass(var WndClass: TWndClass); virtual;
    procedure Info(var Msg: TMessage); virtual cm_First + cm_Info;
  end;

Const
  PageFormats: Array[1..15] of Array[1..30] of Char =
    { taken from Commdlg.dll }
    ('Letter 8 1/2 x 11 in','Letter Small 8 1/2 x 11 in',
     'Tabloid 11 x 17 in','Ledger 17 x 11 in',
     'Legal 8 1/2 x 14 in','Statement 5 1/2 x 8 1/2 in',
     'Executive 7 1/2 x 10 in','A3 297 x 420 mm',
     'A4 210 x 297 mm','A4 Small 210 x 297 mm',
     'A5 148 x 210 mm','B4 250 x 354','B5 182 x 257 mm',
     'Folio 8 1/2 x 13 in','Quarto 215 x 275 mm');


  PageSizes : array [1..15] of TSizes  =
    { Since Printer resolution is always given in DPI, all
      Paper Formats listed above are measured in inches }
    ((W:'8.5' ;H:'11.0' ),(W:'8.5'  ;H:'11.0' ),(W:'11.0';H:'17.0' ),
     (W:'7.0' ;H:'11.0' ),(W:'8.5'  ;H:'14.0' ),(W:'5.5' ;H:'8.5'  ),
     (W:'7.5' ;H:'10.0' ),(W:'11.69';H:'16.54'),(W:'8.27';H:'11.69'),
     (W:'8.27';H:'11.69'),(W:'5.83' ;H:'8.27' ),(W:'9.84';H:'13.94'),
     (W:'7.17';H:'10.12'),(W:'8.5'  ;H:'13.0' ),(W:'8.46';H:'10.83'));

  PageOrientation: Array[1..2] of Array[1..30] of Char =
     ('Portrait','Landscape');

VAR
         i, code, Result : integer;
                   PrnDC : hDC;  { Printer display context }
         Temp, PrintType,
     PrintDrv, PrintPort : PChar;
               PrintInfo : Array[1..80] of Char;
           Temp1,AppName : Array[1..40] of char;
      Orient,Orientation,
               PaperSize,
            PrintQuality,
             YResolution :array[1..30] of char;
                  OffSet : TSize;

constructor TPrintInfoWindow.Init;
begin
    TWindow.Init(nil, 'PrintInfo Demo');
    Attr.Menu := LoadMenu(HInstance, 'Menu_1');
end;

procedure TPrintInfoWindow.GetWindowClass(var WndClass: TWndClass);
begin
  TWindow.GetWindowClass(WndClass);
  WndClass.Style := 0;
  WndClass.hIcon := LoadIcon(hInstance, 'aPrnInfoIcon');
end;

procedure TPrintInfoWindow.Info(var Msg: TMessage);
begin
  { is there a printer installed ? }
  Result:=GetProfileString('windows','device',#0,@PrintInfo,80);
  if Result <> 0 then
    begin
      Application^.ExecDialog(New(PPrintInfoDialog, Init(@Self, 'PrnInfoDlg')));
    end
  else { just in case there's no printer installed }
    Result := MessageBox(HWindow,'No Printer Installed!',
		       'Oops!', mb_IconStop or mb_OK);
end;

constructor TPrintInfoDialog.Init(AParent: PWindowsObject; ATitle:PChar);
var
 s: PStatic;
begin
  TDialog.Init(AParent, ATitle);
  new(s, InitResource(@Self, 3101, SizeOf(TransferRecord.Printer_Driver)));
  new(s, InitResource(@Self, 3102, SizeOf(TransferRecord.Printer_Type)));
  new(s, InitResource(@Self, 3103, SizeOf(TransferRecord.Printer_Port)));
  new(s, InitResource(@Self, 3104, SizeOf(TransferRecord._Orient)));
  new(s, InitResource(@Self, 3105, SizeOf(TransferRecord.Paper_Size)));
  new(s, InitResource(@Self, 3106, SizeOf(TransferRecord.Paper_Width)));
  new(s, InitResource(@Self, 3107, SizeOf(TransferRecord.Paper_Height)));
  new(s, InitResource(@Self, 3108, SizeOf(TransferRecord.Print_quality)));
  new(s, InitResource(@Self, 3109, SizeOf(TransferRecord.Y_Resolution)));
  new(s, InitResource(@Self, 3110, SizeOf(TransferRecord.Max_X_Res)));
  new(s, InitResource(@Self, 3111, SizeOf(TransferRecord.Max_Y_Res)));
  new(s, InitResource(@Self, 3112, SizeOf(TransferRecord.Total_X_Width)));
  new(s, InitResource(@Self, 3113, SizeOf(TransferRecord.Total_Y_Height)));
  new(s, InitResource(@Self, 3114, SizeOf(TransferRecord.X_Offset)));
  new(s, InitResource(@Self, 3115, SizeOf(TransferRecord.Y_Offset)));
  new(s, InitResource(@Self, 3116, SizeOf(TransferRecord.Bits_Pixel)));
  new(s, InitResource(@Self, 3117, SizeOf(TransferRecord.N_Planes)));
  new(s, InitResource(@Self, 3118, SizeOf(TransferRecord.N_Fonts)));
  new(s, InitResource(@Self, 3119, SizeOf(TransferRecord.N_Brushes)));
  new(s, InitResource(@Self, 3120, SizeOf(TransferRecord.N_Pens)));
  new(s, InitResource(@Self, 3121, SizeOf(TransferRecord.N_Colors)));
  { Starts to retrieve the printer information }
  { First locates the 'device' string in WIN.INI }
  Result:=GetProfileString('windows','device',#0,@PrintInfo,80);

  { then extracts the device name, the printer type and the port }
  Temp := StrScan(@PrintInfo,',');      {-------------------------}
  PrintType := @PrintInfo;              {-------------------------}
  PrintDrv := Temp + 1;                 {---This comes from:------}
  Temp[0]:= #0;                         {---PRNTPW.PAS------------}
  PrintPort := StrScan(PrintDrv,',');   {-------------------------}
  PrintPort[0] := #0;                   {-------------------------}
  Inc(PrintPort);                       {-------------------------}
  { creates the printer driver device context, with the data just found}
  PrnDC := CreateDC(PrintDrv, PrintType, PrintPort, nil);
  { puts same data into the record }
  StrCopy(TransferRecord.Printer_Driver, PrintDrv);
  StrCat(TransferRecord.Printer_Driver,'.DRV');
  StrCopy(TransferRecord.Printer_Type, PrintType);
  StrCopy(TransferRecord.Printer_Port, PrintPort);
  { now goes further in WIN.INI to look for printer setup specifics }
  { creates the AppName specific to the printer installed }
  StrCopy(@AppName, PrintType);
  StrCat(@AppName,',');
  StrMove(@Temp1, PrintPort,4); { to avoid ':' from LPT1: }
  StrCat(@AppName, @Temp1);
  { now searches for extra data under the AppName in WIN.INI }
  { ORIENTATION }
  Result:=(GetProfileString(@AppName,'orientation',#0,@Orientation,80));
  if result = 0 then
    begin
      { some printers drivers only add the string 'orient' }
      Result:=(GetProfileString(@AppName,'orient',#0,@Orient,80));
      Orientation := Orient;
    end;
  if result <> 0 then
    begin
      val(Strpas(@Orientation),i,code);
      StrCopy(TransferRecord._Orient, @PageOrientation[i]);
    end
  else { orientation not found, assumes it is Portrait }
    StrCopy(TransferRecord._Orient,'Portrait (default)' );
  { PAPER SIZE }
  Result:=(GetProfileString(@AppName,'paper size',#0,@PaperSize,80));
    if result = 0 then
      { some drivers, e.g. Postscript use the 'feed' string }
      Result:=(GetProfileString(@AppName,'feed1',#0,@PaperSize,80));
    if result <> 0 then
      begin
        val(Strpas(@PaperSize),i,code);
        if i>15 then { only 15 paper sizes defined in COMMDLG.DLL }
          begin
            StrCopy(TransferRecord.Paper_Size,'Unknown format' );
            StrCopy(TransferRecord.Paper_Width,'?' );
            StrCopy(TransferRecord.Paper_Height,'?' );
          end
          else
          begin
  { PAGE FORMAT }
            StrCopy(TransferRecord.Paper_Size, @PageFormats[i]);
  { PAPER WIDTH }
            StrCopy(TransferRecord.Paper_Width,@PageSizes[i].W);
            StrCat(TransferRecord.Paper_Width,' in.');
  { PAPER HEIGHT }
            StrCopy(TransferRecord.Paper_Height,@PageSizes[i].H);
            StrCat(TransferRecord.Paper_Height,' in.');
          end;
      end
        else { when info not found }
          begin
            StrCopy(TransferRecord.Paper_Size,'Not set up!' );
            StrCopy(TransferRecord.Paper_Width,'Not set up!' );
            StrCopy(TransferRecord.Paper_Height,'Not set up!' );
          end;
  { PRINT QUALITY }
  Result:=(GetProfileString(@AppName,'Print Quality',#0,@PrintQuality,80));
  if Result <> 0 then
    begin
      StrCopy(TransferRecord.Print_Quality,@PrintQuality);
      StrCat(TransferRecord.Print_Quality,' dpi');
    end
    else  { when info not found }
      StrCopy(TransferRecord.Print_Quality,'Default (see below)');
  { RESOLUTION }
  Result :=(GetProfileString(@AppName,'Y Resolution',#0,@YResolution,80));
      if Result <> 0 then
        begin
          StrCopy(TransferRecord.Y_Resolution,@YResolution);
          StrCat(TransferRecord.Y_Resolution,' dpi');
        end
        else { when info not found }
          StrCopy(TransferRecord.Y_Resolution,'Default (see below)');
  { Now interrogates the device context}
  { MAXIMUM X RESOLUTION }
  Result := GetDeviceCaps(PrnDC, LogPixelsX);
  wvsprintf(@TransferRecord.Max_X_Res,'%u', Result);
  StrCat(@TransferRecord.Max_X_Res,' dpi');
  { MAXIMUM Y RESOLUTION }
  Result := GetDeviceCaps(PrnDC, LogPixelsY);
  wvsprintf(@TransferRecord.Max_Y_Res,'%u', Result);
  StrCat(@TransferRecord.Max_Y_Res,' dpi');
  { TOTAL X WIDTH }
  Result := GetDeviceCaps(PrnDC, HorzRes);
  wvsprintf(@TransferRecord.Total_X_Width,'%u', Result);
  StrCat(@TransferRecord.Total_X_Width,' pixels');
  { TOTAL Y HEIGHT }
  Result := GetDeviceCaps(PrnDC, VertRes);
  wvsprintf(@TransferRecord.Total_Y_Height,'%u', Result);
  StrCat(@TransferRecord.Total_Y_Height,' pixels');
  { Now interrogates the printer driver}
  { X OFFSET}
  Result := Escape(PrnDC,GETPRINTINGOFFSET, 0 ,nil,@OffSet);
  wvsprintf(@TransferRecord.X_Offset,'%u', Offset.cX);
  StrCat(@TransferRecord.X_Offset,' pixels');
  { Y OFFSET }
  Result := Escape(PrnDC,GETPRINTINGOFFSET, 0 ,nil,@OffSet);
  wvsprintf(@TransferRecord.Y_Offset,'%u', Offset.cY);
  StrCat(@TransferRecord.Y_Offset,' pixels');
  { back to the the device context}
  { BITS PER PIXEL }
  Result := GetDeviceCaps(PrnDC, BitsPixel);
  wvsprintf(@TransferRecord.Bits_Pixel,'%u', Result);
  { NUMBER OF PLANES.... flying low :^) }
  Result := GetDeviceCaps(PrnDC, Planes);
  wvsprintf(@TransferRecord.N_Planes,'%u', Result);
  { NUMBER OF FONTS }
  Result := GetDeviceCaps(PrnDC, NumFonts);
  wvsprintf(@TransferRecord.N_Fonts,'%u', Result);
  { NUMBER OF BRUSHES }
  Result := GetDeviceCaps(PrnDC, NumBrushes);
  wvsprintf(@TransferRecord.N_Brushes,'%u', Result);
  { NUMBER OF PENS }
  Result := GetDeviceCaps(PrnDC, NumPens);
  wvsprintf(@TransferRecord.N_Pens,'%u', Result);
  { NUMBER OF COLORS }
  Result := GetDeviceCaps(PrnDC, NumColors);
  wvsprintf(@TransferRecord.N_Colors,'%u', Result);
  DeleteDC(PrnDC);  { deletes display context }
  TransferBuffer := @TransferRecord;
end;

procedure TPrintInfoDialog.OK(var Msg:TMessage);
begin
  EndDlg(id_OK);
end;


procedure TPrintInfoApp.InitMainWindow;
begin
  MainWindow := New(PPrintInfoWindow, Init);
end;

var
  PrintInfoApp: TPrintInfoApp;
begin
  Ctl3dRegister(HInstance);
  Ctl3dAutoSubclass(HInstance);
  PrintInfoApp.Init('PrintInfo Demo');
  PrintInfoApp.Run;
  PrintInfoApp.Done;
  Ctl3dUnregister(HInstance);
end.

