#include <windows.h>
#include <commctrl.h>
#include "resource.h"

/**********************************************************************
* MLHotKey.c                                                          *
* by Mike Lin - Last Revision 6/12/98                                 *
* This source is released into the public domain - but if you use it, *
* please give credit where due!                                       *
**********************************************************************/

/* Function Prototypes */

BOOL CALLBACK DlgProc(HWND,UINT,WPARAM,LPARAM);		// Dialog Proc

void doInit(HWND);									// Initialization

void CreateHotKeyCtrl(HWND,HINSTANCE);				// Creates hot key control on dialog

void FillWindowsBox(HWND);							// Fills listbox with names of windows
	BOOL CALLBACK EnumProc(HWND,LPARAM);			// Support function; window enumeration

void SelChange(HWND);								// User changes selection (get window hotkey)

HWND GetBoxWnd(HWND);								// Get window selected in box

int SetHotKey(HWND,BYTE,BYTE);						// Set hot key
void GetHotKey(HWND,BYTE*,BYTE*);					// Get hot key
int RemoveHotKey(HWND);								// Remove hot key
void UpdateHotKeyCtrl(HWND,BYTE,BYTE);				// Updates the hot key control

POINT GetRectCenter(RECT);							// Finds center of RECT

/* / Function Prototypes */

/* WinMain */

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	if(DialogBox(hInstance,
	   		     MAKEINTRESOURCE(IDD_MLHOTKEY_DLG),
			     NULL,
			     DlgProc) == -1 )
		MessageBox(NULL,"Unable to create window","MLHotKey",MB_OK);

	return 0;
}

/* / WinMain */

/* DlgProc */

BOOL CALLBACK DlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_CREATE:
		{
			LPCREATESTRUCT cs = (LPCREATESTRUCT)lParam;
			CreateHotKeyCtrl(hwndDlg,cs->hInstance);
			return TRUE;
		}
		break;

	case WM_INITDIALOG:
		{
			doInit(hwndDlg);
			return TRUE;
		}
		break;

	case WM_COMMAND:
		{
			UINT wID = LOWORD(wParam);

			switch(wID)
			{
			case IDC_REFRESH:
				FillWindowsBox(GetDlgItem(hwndDlg,IDC_WINDOWS_LIST));
				break;

			case IDC_SET:
				{
					HWND hTargetWnd;
					WORD wHotKeyRaw;
					hTargetWnd = GetBoxWnd(GetDlgItem(hwndDlg,IDC_WINDOWS_LIST));
					if(!hTargetWnd)
						break;
					wHotKeyRaw = SendMessage(GetDlgItem(hwndDlg,IDC_HOTKEY),HKM_GETHOTKEY,0,0);
					if(SetHotKey(hTargetWnd,LOBYTE(wHotKeyRaw),HIBYTE(wHotKeyRaw)) != 1)
					{
						MessageBox(hwndDlg,"Unable to set hot key!","Error",MB_OK);
						break;
					}
				}
				break;

			case IDC_REMOVE:
				{
					HWND hTargetWnd;
					hTargetWnd = GetBoxWnd(GetDlgItem(hwndDlg,IDC_WINDOWS_LIST));
					if(!hTargetWnd)
						break;
					RemoveHotKey(hTargetWnd);
					FillWindowsBox(GetDlgItem(hwndDlg,IDC_WINDOWS_LIST));
				}
				break;
			case IDC_WINDOWS_LIST:
				{
					switch(HIWORD(wParam))
					{
					case LBN_SELCHANGE:
						{
							SelChange((HWND)lParam);
						}
						break;
					case LBN_SELCANCEL:
						{
							UpdateHotKeyCtrl(GetDlgItem(hwndDlg,IDC_HOTKEY),0,0);
						}
						break;
					}
				}
				break;
			}

			return TRUE;
		}
		break;

	case WM_CLOSE:
	case WM_DESTROY:
		{
			EndDialog(hwndDlg,0);
			return TRUE;
		}
		break;
	}

	return FALSE;
}

/* / DlgProc */

/* CreateHotKeyCtrl */

void CreateHotKeyCtrl(HWND hwndDlg, HINSTANCE hInst)
{
	const int CTRL_WIDTH = 300;
	const int CTRL_HEIGHT = 45;
	HWND hCtrl;
	RECT rcCtrl,rcDlg,rcWindowsBox;
	POINT DlgCenter;

	InitCommonControls();

	GetWindowRect(hwndDlg,&rcDlg);
	GetWindowRect(GetDlgItem(hwndDlg,IDC_WINDOWS_LIST),&rcWindowsBox);

	DlgCenter = GetRectCenter(rcDlg);

	rcCtrl.top = rcWindowsBox.bottom + 10;
	rcCtrl.bottom = rcCtrl.top + CTRL_HEIGHT;
	rcCtrl.left = DlgCenter.x - (CTRL_WIDTH/2);
	rcCtrl.right = rcCtrl.left + CTRL_WIDTH;

	hCtrl = CreateWindowEx(
						   0,
						   HOTKEY_CLASS,
						   "",
						   WS_CHILD | WS_VISIBLE,
						   rcCtrl.left,
						   rcCtrl.top,
						   (rcCtrl.right - rcCtrl.left),
						   (rcCtrl.bottom - rcCtrl.top),
						   hwndDlg,
						   NULL,
						   hInst,
						   NULL);

	SendMessage(hCtrl,
				HKM_SETRULES,
				HKCOMB_A | HKCOMB_S | HKCOMB_C | HKCOMB_NONE,
				MAKELPARAM(HKCOMB_C | HKCOMB_A,0)
				);
}

/* / CreateHotKeyCtrl */

/* doInit */

void doInit(HWND hDlg)
{
	RECT rcMe,rcScreen;
	POINT ScreenCenter;

	GetWindowRect(hDlg,&rcMe);

	rcScreen.top = 0;
	rcScreen.left = 0;
	rcScreen.bottom = GetSystemMetrics(SM_CYSCREEN);
	rcScreen.right = GetSystemMetrics(SM_CXSCREEN);

	ScreenCenter = GetRectCenter(rcScreen);

	SetWindowPos(hDlg,
				 HWND_TOPMOST,
				 (rcScreen.right/2)-((rcMe.right - rcMe.left)/2),
				 (rcScreen.bottom/2)-((rcMe.bottom - rcMe.top)/2),
				 0,
				 0,
				 SWP_NOSIZE);
	
	FillWindowsBox(GetDlgItem(hDlg,IDC_WINDOWS_LIST));
}

/* / doInit */

/* FillWindowsBox */

void FillWindowsBox(HWND hBox)
{
	SendMessage(hBox,LB_RESETCONTENT,0,0);

	if(!EnumWindows(EnumProc,(LPARAM)hBox))
		MessageBox(GetParent(hBox),"Unable to Enumerate Windows","Error",MB_OK);
}
	/* EnumProc */

	BOOL CALLBACK EnumProc(HWND hwnd, LPARAM lParam)
	{
		HWND hBox = (HWND)lParam;
		char wndtitle[255];

		GetWindowText(hwnd,wndtitle,255);

		if(strcmp(wndtitle,"") && IsWindowVisible(hwnd))
			SendMessage(hBox,LB_ADDSTRING,0,(LPARAM)wndtitle);

		return TRUE;	// Continue enumeration
	}

	/* / EnumProc */

/* / FillWindowsBox */

/* SelChange */

void SelChange(HWND hBox)
{
	HWND hwnd;
	BYTE vKey,vModifiers;

	hwnd = GetBoxWnd(hBox);

	if(!hwnd)
	{
		FillWindowsBox(hBox);		// Window is invalid - refresh window list
		return;
	}

	GetHotKey(hwnd,&vKey,&vModifiers);

	UpdateHotKeyCtrl(GetDlgItem(GetParent(hBox),IDC_HOTKEY),vKey,vModifiers);
}

/* / SelChange */

/* GetBoxWnd */

HWND GetBoxWnd(HWND hBox)
{
	HWND hwnd;
	char wndtitle[255];
	int i;
	
	i = SendMessage(hBox,LB_GETCURSEL,0,0);

	SendMessage(hBox,LB_GETTEXT,i,(LPARAM)&wndtitle);

	hwnd = FindWindow(NULL,wndtitle);

	return hwnd;
}

/* / GetBoxWnd */

/* SetHotKey */

int SetHotKey(HWND hTargetWnd, BYTE vKey, BYTE vModifiers)
{
	return SendMessage(hTargetWnd,WM_SETHOTKEY,(WPARAM)MAKEWORD(vKey,vModifiers),0);
}

/* / SetHotKey */

/* GetHotKey */

void GetHotKey(HWND hTargetWnd, BYTE* vKey, BYTE* vModifiers)
{
	WORD wRawHotKey;

	wRawHotKey = (WORD)SendMessage(hTargetWnd,WM_GETHOTKEY,0,0);

	*vKey = LOBYTE(wRawHotKey);
	*vModifiers = HIBYTE(wRawHotKey);
}

/* / GetHotKey */

/* RemoveHotKey */

int RemoveHotKey(HWND hTargetWnd)
{
	return SendMessage(hTargetWnd,WM_SETHOTKEY,0,0);
}

/* / RemoveHotKey */

/* UpdateHotKeyCtrl */

void UpdateHotKeyCtrl(HWND hCtrl, BYTE vKey, BYTE vModifiers)
{
	SendMessage(hCtrl,HKM_SETHOTKEY,MAKEWORD(vKey,vModifiers),0);
}

/* / UpdateHotKeyCtrl */

/* GetRectCenter */

POINT GetRectCenter(RECT rc)
{
	POINT rtn;

	rtn.x = (rc.left + rc.right) / 2;
	rtn.y = (rc.top + rc.bottom) / 2;

	return rtn;
}

/* / GetRectCenter */
