Async Professional for Windows

Serial communications toolkit for OWL, MFC, and Delphi
------------------------------------------------------
Async Professional for Windows is a powerful serial communications
library tightly integrated with Windows, OWL for Pascal and C++, and
MFC for C++. It has an event driven architecture tuned for
performance and efficiency, with integrated serial debugging tools.
It supports Xmodem, Ymodem, Zmodem, Kermit, CompuServe B+, and Ascii
file transfers. It also includes a terminal window with scrollback
and ANSI emulation, a modem database with over 100 entries, and an
event-driven dialing engine.

Supports the Popular Windows Frameworks
---------------------------------------
  Async Professional for Windows is based on two non-object-oriented
DLLs that are the "engines" for all of its functions. Around these
DLLs are object-oriented wrappers that fit into Borland's
ObjectWindows Library for Pascal and ObjectWindows Library 2.0 for
C++, and into the Microsoft Foundation Classes for Visual C++. The
engines also can be directly linked into Pascal applications.

  The object-oriented layers take full advantage of each framework.
The C++ interfaces optionally use exceptions to report errors. Custom
message crackers are provided to make it easy to install
application-specific event handlers in C++.

Event Driven Architecture
-------------------------
  Async Professional for Windows builds on COMM.DRV at the lowest
level, so that your applications can use standard UART ports as well
as any advanced hardware that has a driver compatible with COMM.DRV.
Async Professional also allows you to completely replace COMM.DRV by
writing about 15 low level functions that interface to your hardware.
An example that calls a DOS Fossil driver is provided. Everything
else in the toolbox builds on these primitive functions.

  Async Professional for Windows installs a high performance
dispatcher that is activated on comm notification and timer events to
buffer incoming characters. Whenever a registered trigger condition
is detected by the dispatcher, it posts a Windows message or directly
calls a registered function. You can trigger on one or more of the
following conditions:

  o one or more bytes of data available
  o specified strings detected in the data stream
  o input or output buffers beyond specified levels
  o modem status lines such as CTS, Carrier Detect, or Ring changed
  o line errors detected
  o output requests generated

  This event driven architecture eliminates the need for your
application to poll for characters or to continuously call
PeekMessage. This provides the highest possible performance, avoids
hogging CPU resources, and allows all the tools -- file transfers,
dialing, terminal updating, etc. -- to run in the background.

Complete Serial Port Control
----------------------------
  Async Professional for Windows provides a comprehensive set of
routines for manipulating the serial port. You can check the status
of all the modem status lines, control hardware and software flow
control, detect incoming rings, enable any port or baud rate allowed
by the comm driver, and more. Easy-to-learn calling sequences mean
you don't need to memorize cryptic Windows API constants and
structures.

Powerful Debugging Tools
------------------------
  The Async Professional for Windows dispatcher has two integrated
debugging facilities that can handle almost any serial communications
problem. Logging creates a time-stamped audit trail of all events
processed by the dispatcher. Tracing generates a report of all the
characters sent and received by your program. If you've ever
attempted to debug asynchronous processes in the Windows message
environment, you already realize what a boon the logging and tracing
reports can be.

A Plethora of Protocols
-----------------------
  Async Professional for Windows has all of today's most
commonly used protocols, including Zmodem, Kermit, and CompuServe B+.
And it supports many advanced protocol features, including Zmodem 8K
blocks, transfer resume, and file management options, as well as
Kermit sliding windows and long blocks. The B+ protocol is integrated
with the terminal window to make the normally difficult B+ startup
process a breeze. A supplied class provides a protocol status
dialog, cancel button, and built-in file transfer log.

  By taking advantage of the Async Professional for Windows event
driven architecture, all protocols run at top speed and can run as
background processes. The protocols are resistant to the timeout
errors that can be generated when other programs hog the CPU for long
periods of time.

Flexible Modem Database
-----------------------
  Async Professional for Windows provides a general purpose class for
managing a Windows INI file as an indexed database. It then
specializes this class to manage a database of modems. Over 100
preconfigured modems are provided, with support for error correction
and data compression when available. The toolbox also supplies dialog
boxes for picking and configuring modems, managing a database of
phone numbers, selecting or entering a phone number, and dialing the
phone with status, abort, and retry.

Terminal Window with Emulation
------------------------------
  The Async Professional terminal window has a built-in, customizable
Ansi emulator. The window supports up to 64K of scrollback
information and also has a built-in file capture facility. Example
programs show how to use the terminal window as the application's
main window, as a child window, and as an MDI child.

Examples for Everyone
---------------------
  Async Professional for Windows includes a range of example
programs, with code fragments for each function, short compilable
examples for each library feature, and sophisticated demonstration
programs that put it all together. The TCOM demo has a menu system,
status bar, modem light display, flyover help, dialing window, modem
database access, complete port configuration, and access to all
transfer protocols.

  All examples are provided in source code for Borland C++ with OWL2,
Microsoft Visual C++ with MFC, and Borland Pascal with OWL.

Fax Support Coming Soon!
------------------------
  TurboPower developers are already working to port the powerful fax
capabilities of Async Professional for DOS to the event driven
Windows architecture. These features will be released in a future
version of Async Professional for Windows.

Designed for Delphi
-------------------
  The Async Professional for Windows architecture is "Delphi-ready"
and has already been tested with pre-release versions of Delphi.
Delphi serial port components will be available for download shortly
after Borland releases their product.

Compilers Supported
-------------------
  Async Professional for Windows supports the following compilers and
application frameworks:

  o Turbo Pascal for Windows 1.5 with ObjectWindows Library
  o Borland Pascal 7.0 with ObjectWindows Library
  o Borland C++ 4.0 with ObjectWindows Library 2.0
  o Microsoft Visual C++ 1.0 or 1.5 with the Microsoft Foundation
    Classes

  When used with one of the C++ compilers, Async Professional for
Windows supports the medium and large memory models.

Superb Support
--------------
  Async Professional for Windows includes complete source code, a
comprehensive manual, and a Windows online help file. You pay no
royalties for distributing applications based on Async Professional
for Windows. All DLLs supplied are redistributable.

  You get expert technical support by voice, fax, or e-mail. Your
questions are often answered by the authors of the software.
Maintenance upgrades are available for just the cost of a download
from a BBS, CompuServe, or the Internet. More information about
maintenance upgrades can be found in the file UPDATE.TXT.

Order Information
-----------------
  Async Professional for Windows costs $199 and includes a 60 day
money back guarantee. It will be available for shipment during
December 1994.

  Upgrades are available to owners of the DOS versions of Async
Professional for $119.

  For more information, or to order, call 1-800-333-4160 from 9 a.m.
to 5 p.m. Mountain time, or write to TurboPower Software, P.O. Box
49009, Colorado Springs, CO 80949. International customers call
719-260-9136.  Send faxes to 719-260-7151. Send electronic mail to
CompuServe 76004,2611. Visit our CompuServe area in PCVENB section 6.
We accept MasterCard, Visa, American Express, Discover, a check in
U.S. funds drawn on a U.S. bank, or COD (within U.S. only).

  Version 1.0
  3.5" media only
  Weight approx. 3.0 pounds
  Price $199 plus shipping
      FedEx Economy   $10     U.S. only                 (2 days)
      Airmail          $5     U.S. only                 (3-10 days)
      Airmail         $10     Canada only               (3-10 days)
      Airmail         $20     Elsewhere                 (7-21 days)

      Call for other shipping options.
