
(***************************************************************)
{								}
{	Turbo Pascal Mouse Interface, Version 1.0		}
{	Developed by Tanescu A. Horatiu				}
{	December 1996						}
{								}
{	Testing the mouse in different video modes		}
{								}
(***************************************************************)

program VideoTest;

uses Mouse;

{ Selects a specific video mode }
procedure SetVideoMode(const Mode : Byte); assembler;
asm
	XOR	AH, AH
	MOV	AL, Mode
	INT	10H
end;

{ Displays TextString at (X, Y) using the specified color }
procedure WriteStr(const X, Y : Byte; const TextString : string; const Color : Byte); assembler;
asm
	PUSH	BP
	MOV	AH, 13H
	XOR	AL, AL
	XOR	BH, BH
	MOV	BL, Color
	MOV	DH, Y
	MOV	DL, X
	LES	BP, TextString
	XOR	CH, CH
	MOV	CL, ES:[BP]
	INC	BP
	INT	10H
	POP	BP
end;

procedure TestVideoMode(const Mode : Byte);
var
  S : string;
begin
  SetVideoMode(Mode);            { init video mode }

  Str(Mode, S); S := 'This is video mode ' + S;
  WriteStr(0, 0, S, 7);          { display mode number on screen }

  ShowMouse;                     { show mouse cursor }
  repeat
    ReadMouse                    { read the mouse }
  until LeftButtonPressed;       { repeat until user clicks the left button }
  HideMouse                      { hide mouse cursor }
end;

var
  I : Byte;

(* Main program *)

begin
  if not MouseInstalled then  { if a mouse driver is not installed }
  begin                       { then halt program }
    WriteLn('Sorry, mouse is not available');
    Halt(1)
  end;

  for I := 0 to $7 do TestVideoMode(I);     { testing modes 0 to $7   }
  for I := $D to $13 do TestVideoMode(I);   { testing modes $D to $13 }

  SetVideoMode(3)                           { set 80x25 Color mode }
end.