Unit NeonPCX;
(*
    PCX Decode unit, for decoding PCX pictures in various ways

    Features
    
     Fast ( Still could go faster with BASM or TASM )

     Read forom Disk to Memory

     Depack from Disk   -> Memory

     Depack from Memory -> Memory

     Check if It's really a PCX




    Docx
    

     PCX_DecodeFromDisk(FName:OpenString; MemSeg:Word ) : Boolean;
      -------------------------------------------------------------
       FName is the Filename of the PCX picture, including Path.
       MemSeg is the Destination where the DePacked data will be stored.


     PCX_DecodeFromMem(SourceSeg,DestSeg:Word);
      ------------------------------------------
       SourceSeg is the Segment in memory where the Picture data is,
       only the Picture data is decoded, NOT the colors.

       DestSeg is the Segment in memory where you want to depacked data
       to bee, MAKE SURE IT'S 64000 BYTS BIG !


     PCX_LoadFile(FName:OpenString;DestSeg:Word);
      --------------------------------------------
       Loads the FName pcx file into memory, but does NOT depack it.
       Only the BITMAP data is loaded, use the LoadPCXPal(PalSeg:Word) to
       get the palette information.
       The DestSeg is the destination in memory. Make sure its the
       right size. Use GetPCXSize(FName) to get the size of a picture.


     PCX_LoadPal(FName:OpenString;PalSeg:Word);
      ------------------------------------------
       Loads the Palette information into memory from file Fname at Segment
       PalSeg. The palette is 768 bytes long.


     PCX_SetMemPal(PalSeg:Word);
      ---------------------------
       Sets the Colors in PalSeg as the Active colors.


     PCX_SetFileColors(FName:OpenString);
      ------------------------------------
       Sets the Colors from FName as the Active Colors.


     PCX_GetFileSize(FName);
      ----------------------
       Returns the Size of the Packed PCX file as a Word, Ignoring the
       header and the Palette at the end.

*)
{$G+} { 286 OP-Codes     }
{$A+} { Word Align Data  }
{$O+} { Allow Overlay    }
{$F-} { Far Calls off    }

{$R-} { Range Check Off  }
{$I-} { I/O Check Off    }
{$S-} { Stack Check off  }
{$Q-} { OverFlow Chk Off }

Interface

Procedure PCX_DecodeFromMem(SourceSeg,DestSeg:Word);
Function PCX_LoadFile(FName:OpenString;DestSeg:Word): Boolean;
Function PCX_DecodeFromFile(FName:OpenString; MemSeg:Word ) : Boolean;
Function PCX_GetFileSize(FName:OpenString):Word;
Procedure PCX_SetMemPal(PalSeg:Word);
Procedure PCX_LoadPal(FName:OpenString;PalSeg:Word);
Procedure PCX_SetFileColors(FName:OpenString);


Implementation

Var
   PCXFile : File;


{ Move CX bytes from DS:SI (Source) to ES:DI (Dest) }
Procedure FFill(Dest:Pointer;Count:Word;FillByte:Byte); Assembler;
ASM
   PUSH ES
   PUSH DI

   CLD                            { Forward Direction                      }

   MOV  AX,Word Ptr [Dest+2]
   MOV  ES,AX
   MOV  DI,Word Ptr [Dest]

   MOV  AL,FillByte
   MOV  AH,AL

   MOV  CX,Count                  { Get Number of Bytes !                  }
   SHR  CX,1                      { Convert to words                       }
   REP  STOSW                     { Move the words                         }
   RCL  CX,1                      { Get the odd byte, if any               }
   REP  STOSB                     { Move it                                }

   POP  DI
   POP  ES
END;


{ Sets a DAC Color to R,G,B Values }
Procedure SetRGB256(Col,R,G,B:Byte); Assembler;
ASM
   MOV  DX,$03C8
   MOV  AL,Col
   OUT  DX,AL
   INC  DX
   MOV  AL,R
   OUT  DX,AL
   MOV  AL,G
   OUT  DX,AL
   MOV  AL,B
   OUT  DX,AL
END;




{ Decodes a PCX from memory to memory }
Procedure PCX_DecodeFromMem(SourceSeg,DestSeg:Word);
Var
   Decoded : Word;
   Chk     : Byte;
   OrgPtr  : ^Byte;
   DestPtr : ^Byte;
BEGIN
     OrgPtr:=Ptr(SourceSeg,0);             { Initialize Pointers & Counters }
     DestPtr:=Ptr(DestSeg,0);
     Decoded:=0;
     While Decoded<64000 do                { Decode the File  }
     BEGIN
          Chk:=OrgPtr^;                    { Get Byte         }
          If Chk and $C0=$C0 then          { Packed or Not ?  }
          BEGIN
               Chk:=OrgPtr^ AND $3F;       { The DATA Length  }
               Inc(OrgPtr);
               FFill(DestPtr,Chk,OrgPtr^); { Fill Range with  }
                                           { the Packed DATA  }

               Inc(Decoded,Chk);           { Decoded amount   }
               Inc(DestPtr,Chk);           { Inc Dest         }
               Inc(OrgPtr);                { Inc Org Ptr      }
          END Else
          BEGIN
               Destptr^:=Chk;              { Byte into Buffer }
               Inc(DestPtr);               { Inc pointers     }
               Inc(Decoded);
               Inc(OrgPtr);
          END;
     END;
END;



{ Loads the Packed data from a PCX file into mem at Seg DestSeg }
Function PCX_LoadFile(FName:OpenString;DestSeg:Word): Boolean;
Var
   Scrap   : Word;
BEGIN
     PCX_LoadFile:=False;
     Assign(PCXFile,FName);               { Assign ...                      }
     Reset(PCXFile,1);                    { Open up                         }
     If IOResult=0 then                   { Did we succseed                 }
     BEGIN
          Seek(PCXFile,128);              { Seek past PCX Header            }
          BlockRead(PCXFile,              { Read File into Buffer -         }
                    Ptr(DestSeg,0)^,      { Skip COLOR Data                 }
                    FileSize(PCXFile)-768,
                    Scrap);
          Close(PCXFile);
          PCX_LoadFile:=True;             { Return Success                  }
     END;
END;



{ Decodes a PCX file to the MemSeg segment in memory }
Function PCX_DecodeFromFile(FName:OpenString; MemSeg:Word ) : Boolean;
Var
   Buf     : Pointer;
BEGIN
     PCX_DecodeFromFile:=False;            { Assume Failure              }
     GetMem(Buf,65000);                    { Allocate Memory for Packed  }
                                           { Picture Data                }
     If PCX_LoadFile(FName,Seg(Buf^)) then
     BEGIN
          PCX_DecodeFromMem(Seg(Buf^),MemSeg);  { Actually DeCode it          }
          PCX_DecodeFromFile:=True;             { Return Success   }
     END;
     FreeMem(Buf,65000);                   { Free memory      }
END;



{ Returns the Size of the PCX File without the Header & palette }
Function PCX_GetFileSize(FName:OpenString):Word;
BEGIN
     PCX_GetFileSize:=0;                  { Assume 0 size }
     Assign(PCXFile,FName);
     Reset(PCXFile,1);
     If IOResult=0 then
     BEGIN
          PCX_GetFileSize:=FileSize(PCXFile)-128-768;
          Close(PCXFile);
     END;
END;



{ Sets the colors from a memory palette as the Active Colors }
Procedure PCX_SetMemPal(PalSeg:Word);
Var
   I      : Word;
   PalPtr : ^Byte;
   R,G,B  : Byte;
BEGIN
     PalPtr:=Ptr(PalSeg,0);
     For I:=0 to 255 do
     BEGIN
         R:=PalPtr^ SHR 2; Inc(PalPtr);
         G:=PalPtr^ SHR 2; Inc(PalPtr);
         B:=PalPtr^ SHR 2; Inc(PalPtr);
         SetRGB256(I,R,G,B);
     END;
END;



{ Loads a PCX palette into memory at seg PalSeg }
Procedure PCX_LoadPal(FName:OpenString;PalSeg:Word);
BEGIN
     Assign(PCXFile,FName);                     { Open File               }
     Reset(PCXFile,1);
     If IOResult=0 then                         { Does it Exists ?        }
     BEGIN
          Seek(PCXFile,FileSize(PCXFile)-768);  { Seek & Read Palette     }
          BlockRead(PCXFile,Ptr(PalSeg,0)^,768);
          Close(PCXFile);                       { Close File              }
     END;
END;



{ Loads the Colors of a PCX File into a Segmemt }
Procedure PCX_SetFileColors(FName:OpenString);
Var
   Buf : ^Byte;
BEGIN
     GetMem(Buf,768);                     { Allocate Buffer for Pal   }
     PCX_LoadPal(FName,Word(Seg(Buf^)));  { Load Palette into buffer  }
     PCX_SetMemPal(Word(Seg(Buf^)));      { Set colors from buffer    }
     FreeMem(Buf,768);                    { Free Buffer               }
END;

END.