
{******************************************}
{*                                        *}
{* Example for MGRLE unit.                *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses mgrle;

var
 expstr,
 cmpstr : string;
 count  : byte;

{ function call by rle unit to get next byte }
function get:integer;far;
begin
   if count = length(expstr) then
     get := -1
   else
   begin
     inc(count);
     get := integer(expstr[count]);
   end;
end;

{ function call by rle unit to store next byte }
procedure put(b:integer);far;
begin
   if b = -1 then
   begin
    writeln('Error occur!');
    Halt;
   end
   else
     cmpstr := cmpstr + char(b);
end;


var
  L:Longint;
  Z:Array[1..4] of byte absolute L;

begin

      { Init string to be compressed }
      expstr := 'AAAAMarkTTTTTest';
      cmpstr := '';
      count := 0;

      { Set I/O functions }
      rleputc := put;
      rlegetc := get;

      { Compress }
      Compressrle;


      expstr := cmpstr;
      cmpstr := '';
      count := 0;

      { Decompress }
      Expandrle;

end.
