
{******************************************}
{*                                        *}
{* Example for MGQCII unit.               *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses mgqcii;

var

 driveinfo : qcii_driveinfo;
 min,maj   : byte;
 i         : word;

begin

   if qciiinstallchk (maj, min) then
   begin
        qciigetinfo (1, @driveinfo);

        if qciidismount (0) <> 0 then; {error}
        (* flush any dirty buffers for the specified
        drive(s) and then discard those sector buffers. *)

        if qciiflush <> 0 then; {error}
        (* immediately write all dirty sectors back to disk *)

        if qciicachestatus (true) <> 0 then; {error}
        (* enables caching of all drives. *)

        if qciisetsectors (100) <> 0 then; {error}
        (* set new number of sector buffers in cache.  *)
        (* 0001h failed--size adjusted                 *)
        (* 8000h cache cannot be resized while enabled *)

        if qciisetflushinterval (1000) <> 0 then; {error}
        (* specify how often the cache should write
        dirty buffers to disk when buffered writes are enabled. *)


        i := qciiuninstall;
        if i <> 0000 then writeln('Intr hook by another TSR :',i);

        if qciiautodismount (true) <> 0 then; {error}
        (* enable auto dismount. *)

        if qciisetbufsz (200) <> 0 then; {error}
        (*  specify the number of cache sector buffers
            to dedicate to buffered read and write operations. *)

        if qciisetbufedwrites (true) <> 0 then; {error}
        (* specify whether the cache should delay disk
        writes.  Note: this procedure enables or disables delayed writes
        for all drives. *)

        if qciisetbufedread (true) <> 0 then; {error}
        (* specify whether the cache should attempt to
        read ahead of actual requests note:  this procedure enables or
        disables read-ahead for all drives. *)

        if qciisetflushcnt (100) <> 0 then; {error}
        (* specify how many dirty sectors the cache
        should write after each flush interval (see ah=25h) when
        buffered writes are enabled. *)

        if qciiforceimincflush <> 0 then; {error}
        (* immediately flush up to flushcount dirty sectors
           to disk as if the flush interval had expired. *)

        if qciienablecache (0) <> 0 then; {error}
        (* enable cache for specific drive. *)

        if qciidisablecache (0) <> 0 then; {error}
        (* disable cache for specific drive. *)

        if qciisectlock (01) <> 0 then; {error}
        (* lock or unlock sectors.
        fnc: 00h end sector locking/unlocking
        01h lock all accessed sectors into cache
        02h unlock all accessed sectors and discard from cache *)

        if qciisetlockpoolsize (100) <> 0 then; {error}
        (*  specify the number of cache sector buffers which
            may be dedicated to data locked into the cache. *)

        qciisetbuffedreaddrv (true, 0); {error}
        (* enable read cache for a specified drive. *)

        if qciisetbuffedwrtdrv (true, 0) <> 0 then; {error}
        (* enable write cache for a specified drive. *)

        if qciisetrdbufszdrv (254, 0) <> 0 then; {error}
        (* set read buffer size for specific drive. *)

        if qciisetwrbufszdrv (24, 0) <> 0 then; {error}
        (* set write buffer size for specific drive. *)
   end;

end.
