
{******************************************}
{*                                        *}
{* Example for MGFILHDL unit.             *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses mgnumber, mgfilhdl;

var
  f       : tfile;
  buffer,
  buf2    : array[1..10] of byte;
  b       : byte;
  i       : word;


{ sample procedure call if file error occur. }
procedure error;
begin
  writeln('file error occur...');
end;


begin

     f.fname := 'test.txt';
     fcreate (@f, aArchive);
     (* create file with archive (normal) attribute *)
     if f.errcode <> fsucces then error;
     { close file }
     fclose(@f);

     { open file with read/write acces and deny none }
     fopen (@f, mReadWrite+DenyNone);
     if f.errcode <> fsucces then error;

     { Initialize buffer }
     for i := 1 to 10 do buffer[i] := i;

     { Write 10 bytes to file }
     writeln(fwrite(@f, @buffer, 10));
     b:=4;
     { write one more byte }
     fwritebyte (@f, b);
     { flush (write) dirty buffer }
     fflush (@f);

     writeln(fpos(@f));
     { seek to start of file }
     fseekstart (@f);
     writeln(fpos(@f));
     if f.errcode <> fsucces then error;

     { read first 10 bytes of file }
     writeln(fread (@f, @buf2, 10));
     { read one more byte }
     b := freadbyte (@f);

     { seek to end of file }
     fseekend (@f);
     writeln(fpos(@f));
     { force error !! (end of file) }
     b := freadbyte (@f);
     writeln(f.errcode);

     writeln(fpos(@f));
     writeln(feof(@f));
     if f.errcode <> fsucces then error;

     { lock-unlock file acces }
     flock (@f, 1, 3);
     funlock (@f, 1, 3);

     writeln(fpos(@f));
     writeln(feof(@f));

     { seek to start of file }
     fseek (@f, 1);
     { read one byte }
     b := freadbyte (@f);
     { seek one byte from end of file }
     fseekeof (@f, 1);
     { read one byte }
     b := freadbyte (@f);

     { seek from pos }
     fseekpos (@f, 1);

     writeln(fpos (@f));
     writeln(fsize (@f));
     writeln(feof (@f));

     { Write file attributes }
     writeln('Archive   = ',fgetattr (@f) and aArchive <> 0);
     writeln('Hiden     = ',fgetattr (@f) and aHiden <> 0);
     writeln('System    = ',fgetattr (@f) and aSystem <> 0);
     writeln('Readonly  = ',fgetattr (@f) and aReadOnly <> 0);
     writeln('Directory = ',fgetattr (@f) and aDirectory <> 0);

     fsetattr (@f, (fgetattr(@f) or aHiden));

     writeln;
     writeln('Archive   = ',fgetattr (@f) and aArchive <> 0);
     writeln('Hiden     = ',fgetattr (@f) and aHiden <> 0);
     writeln('System    = ',fgetattr (@f) and aSystem <> 0);
     writeln('Readonly  = ',fgetattr (@f) and aReadOnly <> 0);
     writeln('Directory = ',fgetattr (@f) and aDirectory <> 0);

     fsettime (@f, nrandom(10,1000));
     fsetdate (@f, nrandom(10,1000));
     i := fgettime (@f);
     i := fgetdate (@f);

     { set size of file = 5 }
     ftrunc (@f, 5);

     writeln(fsize (@f));

     { close file }
     fclose(@f);

end.
