
{******************************************}
{*                                        *}
{* Example for MGDBHASH unit.             *}
{*                                        *}
{* 07-27-95 by Mark Gauthier.             *}
{*                                        *}
{******************************************}

uses mgdbhash;

type
  FriendType = record
     name : string[35];
     phone : string[15];
  end;

Var
 Friends : HashFilePtr; { Database file variable. }
 Friend  : FriendType;  { Database field }

begin
 New(Friends); { Allocate file }
 if Friends = nil then halt;

 { open work like create                                            }
 { procedure HashOpen(Filename:string; recsize:word; KeyStart:word; }
 {               NumRec,NumOver:longint; var Hash:HashFilePtr);     }


 HashCreate('FRIENDS.DAT',       { file name }
            sizeof(FriendType),  { size of record }
            36,                  { Key Offset = phone offset }
            10,                  { Database of 10 entrys }
            2,                   { Overflow = 25% of entrys number }
            Friends);            { Database variable }

 if hasherror <> hsucces then halt;
 Friend.name := 'Andre';
 Friend.phone := '514-430-1111';
 HashWrite(Friends, @Friend); {Add one record}

 Friend.name := 'Luc';
 Friend.phone := '514-435-2222';
 HashWrite(Friends, @Friend); {Add one record}

 Friend.name := 'Nathalie';
 Friend.phone := '514-430-1111';
 HashWrite(Friends, @Friend); {Add one record}

 Friend.name := 'Eric';
 Friend.phone := '514-979-4454';
 HashWrite(Friends, @Friend); {Add one record}

 Friend.name := 'Lise';
 Friend.phone := '32-212-011-3232';
 HashWrite(Friends, @Friend); {Add one record}

 { search in database for record that have phone number (hashing key)  }
 { that match to 514-979-4454.  This function may return element that      }
 { have a phone number different of 514-979-4454 because it search for }
 { similar hasing key not similar key.                                     }

Friend.phone := '514-979-4454';
writeln('Found 514-979-4454 = ', HashFind(Friends, @Friend));

{ Search for first record that match hashing key of 514-430-1111 }
Friend.phone := '514-430-1111';
if HashReadFirst(Friends, @Friend) then
begin
    repeat
       writeln('Name:',Friend.name, ' Phone: ',Friend.phone);
    until HashReadNext(Friends, @Friend) = false;
end;



{ search in database for record that have phone number (hashing key)  }
{ that match to specific phone.  If a record match the key then record}
{ are compare if record are equal record is delete from database.         }

Friend.name := 'Lise';
Friend.phone := '32-212-011-3232';
writeln('Delete Lise? = ', HashDelete(Friends, @Friend));

Friend.phone := '32-212-011-3232';
writeln('Found 32-212-011-3232 = ', HashFind(Friends, @Friend));

 {Close database}
 HashClose(Friends);

end.
