program more_3D;
uses crt,krush2;

const    iniz      = 10;      { Initial Z-coordinate }
         xof       = 160;     { X-coordinate         }
         yof       = 100;     { Y-coordinate         }
         zof       = 40;      { Distance             }
         dots_only = false;   { Dots or a wireframe  }


type point  = record X,Y,Z:real; end;
     virtua = array[0..64000] of byte;
     virpnt = ^virtua;

var plate      : array[0..36] of record X,Y,Z:integer; end;
    conv       : array[0..36] of point;
    twod       : array[0..36] of record X,Y:word; end;
    ctb,stb    : array[0..360] of real;
    virscr     : virpnt;
    virseg     : word;
    x,y,z      : integer;


Procedure V_Setup; begin GetMem (VirScr,64000); virseg := seg (virscr^); end;
Procedure V_Free; begin FreeMem (VirScr,64000); end;
procedure V_Flip(source,dest:Word); assembler;
asm; push ds; mov ax, [Dest]; mov es, ax; mov ax, [Source]; mov ds, ax;
xor si, si; xor di, di; mov cx, 32000; rep movsw; pop ds; end;


procedure Define_plate;
var i,j:word;
begin
  V_Setup; V_Cls(virseg,0);
  for i:=1 to 36 do setcolor(i,25+i,0,25+i);
  for i:=0 to 360 do begin
    stb[i] := sin(i*pi/180);
    ctb[i] := cos(i*pi/180);
  end;

  for i:=0 to 5 do for j:=1 to 6 do begin
     plate[i*6+j].x := -5+i*2;                { What a WEIRD way to }
     plate[i*6+j].y := -7+j*2;                { plot the points...  }
     plate[i*6+j].z := iniz;                  { but it does work.   }

{    plate[i*6+j].z := 10+i*j mod 2;          { <-- Try it...       }

  end;
  x:=0; y:=0; z:=0;
end;

procedure Rotatepoints(Xan,Yan,Zan : integer);
var i:integer ; tmp:point;
begin
  for i:=1 to 36 do begin
    tmp.x := plate[i].X;
    tmp.y := plate[i].Y*ctb[Xan] - plate[i].Z*stb[Xan];
    tmp.z := plate[i].Y*stb[Xan] + plate[i].Z*ctb[Xan];
    conv[i] := tmp;

    tmp.x := conv[i].x*ctb[Yan] - conv[i].z*stb[Yan];
    tmp.z := conv[i].x*stb[Yan] + conv[i].z*ctb[Yan];
    conv[i] := tmp;

    tmp.x := conv[i].x*ctb[Zan] - conv[i].y*stb[Zan];
    tmp.y := conv[i].x*stb[Zan] + conv[i].y*ctb[Zan];
    conv[i] := tmp;

  end;
end;

procedure Drawpoints;
var i:integer; tmp:real;
begin
  for i:=1 to 36 do begin
    tmp := conv[i].z+zof;
    twod[i].x := round((256*conv[i].x) / tmp+xof);
    twod[i].y := round((256*conv[i].y) / tmp+yof);
  end;
  if dots_only = true then
    for i:=1 to 36 do mem[virseg:twod[i].x+twod[i].y*320] := i
  else begin
    for i:=1 to 35 do if (i mod 6)<>0 then
    line(twod[i].x,twod[i].y,twod[i+1].x,twod[i+1].y,i,virseg);
    for i:=1 to 30 do
    line(twod[i].x,twod[i].y,twod[i+6].x,twod[i+6].y,i,virseg);
  end;
end;

begin
  Screenmode($13);
  Define_plate;
  repeat
    Rotatepoints(x,y,z);
    Drawpoints;
    V_Flip(virseg,$A000);
    V_Cls(virseg,0);
    if y<360 then inc(y,1) else y:=0;
    if x<360 then inc(x,3) else x:=0;
    if z<360 then inc(z,2) else z:=0;
  until keypressed;
  Screenmode($3);
end.