{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
program e_host;

{$I e_types.inc  }
{$I e_mdm.inc    }
{$I e_h_mon.inc }
{$I e_dt.inc }
{$I e_srch.inc }

type
  index_type     = record
                     unit : unit_type;
                     phone_no : ph_num_type;
                     head,
                     tail : real
                   end;

   key_type      = unit_type;

var
  unit_ndx_file  : file of index_type;       {Index for mail queue file}
  queue_file     : file of mail_que_type;    {Mail queue file}
  mail_item_file : file of byte;             {Actual mail item}

  last_unit_called : unit_type;

  ok,
  quit      : boolean;

const
  unit_ndx_fname : file_path_type = 'E:\EMAIL\E_UNIT.NDX';
  queue_fname    : file_path_type = 'E:\EMAIL\E_MAIL.QUE';
  mail_fname     : file_path_type = 'E:\EMAIL\nnnnnnnn.ITM';

  mail_pending   : boolean = true;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure init_date_time;

begin
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure open_unit_ndx_file(var ok : boolean);

var
  err        : integer;
  index_rec  : index_type;

begin
  assign(unit_ndx_file,unit_ndx_fname);
  {$I-} reset(unit_ndx_file); {$I+}
  err := ioresult;
  if err=0
    then begin
      seek(unit_ndx_file,0);
      read(unit_ndx_file,index_rec);
      last_unit_called := index_rec.unit
    end;
  ok := (err=0)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure init_files(var ok : boolean);

begin
  open_unit_ndx_file(ok)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
var
  bin_index_entry : index_type;

function bin_get_key;

begin
  {For debugging purposes:}
    writeln('Getting record ',bin_rn);
  seek(unit_ndx_file,bin_rn);
  read(unit_ndx_file,bin_index_entry);
  bin_get_key := addr(bin_index_entry.unit)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function bin_less_than;

var
  target,
  current_key : ^key_type;

begin
  setptr(target,bin_target);
  setptr(current_key,bin_current);
  { For debugging purposes:
    writeln('Is ',target^,' less than ',current_key^); }
  bin_less_than := target^<current_key^
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function bin_equal_to;

var
  target,
  current_key : ^key_type;

begin
  setptr(target,bin_target);
  setptr(current_key,bin_current);
  { For debugging purposes:
    writeln('Is ',target^,' equal to ',current_key^); }
  bin_equal_to := target^=current_key^
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function index_rec_no(unit : unit_type) : integer;

begin
  index_rec_no := bin_search(1,filesize(unit_ndx_file)-1,unit)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function rec_no_after(unit : unit_type) : integer;

var
  index_rn : integer;

begin
  index_rn := index_rec_no(unit);
  if index_rn=filesize(unit_ndx_file)-1
    then rec_no_after := 1
    else rec_no_after := index_rn + 1
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure index_delete(index_rn : integer);

var
  last_rn,
  rn         : integer;
  index_rec  : index_type;

begin
  last_rn := filesize(unit_ndx_file) - 1;
  for rn := index_rn + 1 to last_rn do begin
    seek(unit_ndx_file,rn);
    read(unit_ndx_file,index_rec);
    seek(unit_ndx_file,rn-1);
    write(unit_ndx_file,index_rec)
  end;
  seek(unit_ndx_file,last_rn);
  truncate(unit_ndx_file);
  close(unit_ndx_file);
  open_unit_ndx_file(ok)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure index_add(index_rn   : integer;
                    index_item : index_type);

var
  last_rn,
  rn         : integer;
  index_rec  : index_type;

begin
  last_rn := filesize(unit_ndx_file) - 1;
  for rn := last_rn downto index_rn do begin
    seek(unit_ndx_file,rn);
    read(unit_ndx_file,index_rec);
    seek(unit_ndx_file,rn+1);
    write(unit_ndx_file,index_rec)
  end;
  seek(unit_ndx_file,index_rn);
  write(unit_ndx_file,index_item);
  close(unit_ndx_file);
  open_unit_ndx_file(ok)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function night_time : boolean;

begin
  night_time := true
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure xfer_mail(    index_rn : real;
                    var finished : boolean);

var
  queue_block : mail_que_type;
  index_rec  : index_type;
  ok          : boolean;
  c           : char;

begin
  seek(unit_ndx_file,index_rn);
  read(unit_ndx_file,index_rec);
  while (index_rec.head<>0) and (aux_carrier_detect) do begin
    seek(queue_file,index_rec.head);
    read(queue_file,queue_block);
    {Find mail item}
    {Xfer queue block info}
    {Xfer mail item}
    if c=recvok
      then begin
        index_rec.head := queue_block.next;
        seek(unit_ndx_file,index_rn);
        write(unit_ndx_file,index_rec)
      end
      else begin
        {Handle "notrecvok" condition}
      end
  end;
  finished := (index_rec.head=0)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure mail_call(var quit : boolean);

var
  ok,
  finished   : boolean;
  c          : char;
  save_unit  : unit_type;
  index_rn   : real;
  index_rec  : index_type;

begin
  {Assume there is mail.}
  mail_pending := true;

  {Remember where we started.}
  save_unit := last_unit_called;

  {Find the first unit with mail to be delivered.}
  repeat
    index_rn := rec_no_after(last_unit_called);
    seek(unit_ndx_file,index_rn);
    read(unit_ndx_file,index_rec);
    if index_rec.head=0 {No mail.}
      then last_unit_called := index_rec.unit
  until (index_rec.head<>0) or (save_unit=last_unit_called);

  {We either found mail or determined that there is none.}
  if index_rec.head<>0
    then begin
      call(index_rec.phone_no,ok);
      if aux_carrier_detect
        then begin
          xfer_mail(index_rn,finished);
          hangup;
          quit := false;
          if finished
            then last_unit_called := index_rec.unit
        end
      else if keypressed
        then begin
          write('Terminate program? (Y/N) ');
          read(kbd,c);
          writeln(c);
          quit := (upcase(c)='Y')
        end
      else begin {The remote failed to answer -- skip for now.}
        last_unit_called := index_rec.unit;
        quit := false
      end
    end
    else mail_pending := false {There is no mail.};

  {Remember the last unit called.}
  if last_unit_called<>save_unit
    then begin
      index_rec.unit := last_unit_called;
      seek(unit_ndx_file,0);
      write(unit_ndx_file,index_rec)
    end
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure handlecall;

begin
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure await_mail(var quit : boolean);

var
  c : char;

begin
  awaitcall(5*minutes);
  if aux_carrier_detect
    then begin
      handlecall;
      hangup;
      quit := false
    end
    else if keypressed
      then begin
        write('Terminate program? (Y/N) ');
        read(kbd,c);
        writeln(c);
        quit := (upcase(c)='Y')
      end
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

var
  xunit : unit_type;

begin {main}
  init_files(ok);
  if ok
    then begin
      write('Enter unit: ');
      readln(xunit);
      writeln('Next rec no = ',rec_no_after(xunit))
    end
    else writeln('File open error');
  close(unit_ndx_file)

(*  clrscr;
  if (paramstr(1)='$M') or (paramstr(1)='$m')
    then monitor := true;
  host := true;
  init_mdm(bd300);
  init_date_time;
  init_files(ok);
  if not ok
    then exit;

  repeat
    if night_time and mail_pending
      then begin
        mail_call(quit)
      end
      else begin
        await_mail(quit)
      end
  until quit;

  quit_mdm
end. {main}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
*)end.