{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
program e_hinit;

{$I e_types.inc  }

var
  unit_ndx_file   : file of index_type;       {Index for mail queue header file}
  queue_hdr_file  : file of queue_hdr_type;   {Mail queue header file}
  queue_file      : file of mail_que_type;    {Mail queue file}
  sys_info_file   : file of sys_info_type;    {System information file}

  sys_info        : sys_info_type;
  index_rec       : index_type;
  free_hdr        : queue_hdr_type;
  exists          : boolean;
  choice          : char;
  quit            : boolean;

const
  password        = 'noshit';

  cr              = ^M;
  lf              = ^J;
  bell            = ^G;

  unit_ndx_fname  : file_path_type = '\EMAIL\E_UNIT.NDX';
  queue_hdr_fname : file_path_type = '\EMAIL\E_MQUE.HDR';
  queue_fname     : file_path_type = '\EMAIL\E_MAIL.QUE';
  sys_info_fname  : file_path_type = '\EMAIL\E_HINFO.SYS';
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function readchar(ok_chars : char_set) : char; { Restricts input to ok_chars }

var
  c : char;

begin
  repeat
    read(kbd,c);
    if not (c in ok_chars)
      then write(bell)
  until c in ok_chars;
  readchar := c
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function yes(txt : anystr) : boolean; { Display txt, get Y or N,
                                        return TRUE if Y, FALSE if N }

var
  c : char;
  cursor : integer;

begin
  write(txt+' (Y/N) ');
  c := readchar(['y','Y','n','N']);
  yes := (upcase(c) = 'Y');
  writeln
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function no(txt : anystr) : boolean; { Same as "yes" except opposite logic }

begin
  no := not yes(txt)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
begin {main}
  if paramstr(1)<>password
    then begin
      writeln('Bad command or file name');
      exit
    end;

  clrscr;
  assign(unit_ndx_file,unit_ndx_fname);
  {$I-} reset(unit_ndx_file); {$I+}
  exists := (ioresult=0);
  if exists
    then if yes(unit_ndx_fname+
        ' already exists.'+cr+lf+
        'Would you like to delete it and create a new one? ')
      then if yes(lf+'ARE YOU SURE!!!? '+bell)
        then begin
          close(unit_ndx_file);
          erase(unit_ndx_file);
          exists := false
        end;
  if not exists
    then begin
      rewrite(unit_ndx_file);
      fillchar(index_rec,sizeof(index_rec),0);
      seek(unit_ndx_file,0);
      write(unit_ndx_file,index_rec);
      close(unit_ndx_file)
    end;

  assign(queue_hdr_file,queue_hdr_fname);
  {$I-} reset(queue_hdr_file); {$I+}
  exists := (ioresult=0);
  if exists
    then if yes(queue_hdr_fname+
        ' already exists.'+cr+lf+
        'Would you like to delete it and create a new one? ')
      then if yes(lf+'ARE YOU SURE!!!? '+bell)
        then begin
          close(queue_hdr_file);
          erase(queue_hdr_file);
          exists := false
        end;
  if not exists
    then begin
      rewrite(queue_hdr_file);
      with free_hdr do begin
        fillchar(free_hdr,sizeof(free_hdr),0);
        unit := 'FREE LIST HEADER';
        head := -1;
        tail := -1
      end;
      write(queue_hdr_file,free_hdr);
      close(queue_hdr_file)
    end;

  assign(queue_file,queue_fname);
  {$I-} reset(queue_file); {$I+}
  exists := (ioresult=0);
  if exists
    then if yes(queue_fname+
        ' already exists.'+cr+lf+
        'Would you like to delete it and create a new one? ')
      then if yes(lf+'ARE YOU SURE!!!? '+bell)
        then begin
          close(queue_file);
          erase(queue_file);
          exists := false
        end;
  if not exists
    then begin
      rewrite(queue_file);
      close(queue_file)
    end;

  assign(sys_info_file,sys_info_fname);
  {$I-} reset(sys_info_file); {$I+}
  exists := (ioresult=0);
  if exists
    then read(sys_info_file,sys_info)
    else with sys_info do begin
      rewrite(sys_info_file);
      unit := '';
      serial_no := 0;
      host_no := 0;
      host_phone_no := '';
      time_zone := 5
    end;

  with sys_info do repeat
    clrscr;
    writeln;
    writeln('Current system information:');
    writeln;
    writeln('  Host number   : ',host_no);
    writeln('  Serial number : ',serial_no);
    writeln('  Phone number  : ',host_phone_no);
    writeln('  Time zone     : ',time_zone);
    writeln;
    if yes('Any changes?')
      then begin
        write('Which field to change? (H,S,P, or T) : ');
        choice := readchar(['H','h','S','s','P','p','T','t']);
        writeln;
        case choice of
          'H','h' : begin
                      write('  New host number   : ');
                      readln(host_no)
                    end;
          'S','s' : begin
                      write('  New serial number : ');
                      readln(serial_no)
                    end;
          'P','p' : begin
                      write('  New phone number  : ');
                      readln(host_phone_no)
                    end;
          'T','t' : begin
                      write('  New time zone     : ');
                      readln(time_zone)
                    end
          else write(bell)
        end;
        quit := false
      end
      else quit := true
  until quit;
  seek(sys_info_file,0);
  write(sys_info_file,sys_info);
  close(sys_info_file)

end. {main}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
