program Tutorial5;
{
 3d Tutorial step#5
 Made by fh(c)96
 Mail: fh@viktoria.drp.fmph.uniba.sk

  The point of the perspective is this: when you look at two same things (let's
 say two same-sized cubes) and the one is closer to you than the other one, you
 see them NOT same-sized - the one closer to you is bigger. Yeah i know this is
 kinda primitive explanation ...

  Let's say you want to implement the perspective to your 3d rotating, too. All
 you have to do is add one simple equation to your drawing procedure:

              per * x (or y)    where x (or y) is the x-coordinate you want to
 sx (or sy) = --------------    draw, z is the z-coordinate, per is the pers-
                 per + z        pective number and sx (or sy) is the final
                                x-(y-)coordinate which you just draw.
  You get the equation as following: (for maximal simplicity we'd talk now just
 about 2d, not 3d.) take two points - A and S (where S is horizontal with your
 eye-line and the distance between A and S is x. when you look at your points
 from zero distance, you'll see the distance between A and S equaling x. But
 when you look at it from 1 meter, the distance is less than x - let's say sx.

        A			(o) is your eye, z is the distance on the
^       +---____		z-axis from the point (0,0,0) (that's point S)
|       |       ----____ A'     x is the distance on the x-axis, per is the
|  ^    |               -+--____	distance to an imaginal point somewhere
x  |    |                |      ----____     far away (very important - the
|  sx   |                |              ----____   perspective depends on it!)
|  |    |                |                      ----____ 
v  v (o)+----------------+--------------------------------x somewhere far away
        S                S'
        <--------z-------x--------------per--------------->

 (Better picture than this ascii is in file tut5.pcx.)

  To determine, what is the size of sx (remember we want to draw the point A'),
 let's use the similarity of triangles (or whatever you want to call it).
 x/z+per = sx/per   - to get the sx just multiple it by per, so you'll get our
 good old equation listed somewhere in this text. So in your program you just
 put the numbers (x-distance on the x-axis, z-distance on the z-axis and per
 as the perspective number - you'll find the right one for you by trying).
}

uses tutunit,crt;

const sin005 : real = 0.049979169;
      cos005 : real = 0.99875026;
var xt,yt,zt:real; {temp points}
    ch:char; {for key you want to press}
    xan,yan,zan:real; {angles for axis X,Y,Z}
    objname: string[20]; {just a junk}
    per:real; {...you know, like the perspective stuff...}
    sx,sy,sx1,sy1,p,zoom,p1: integer; {Screen coords X,Y}
    points,lines:word; {nr. of points and lines of the object}
    obj,objold: array[0..511] of real; {object to rotate (max 512 points}
    lobj: array[0..1023] of integer; {line index of object (max 1024}
    xsin,ysin,zsin,xcos,ycos,zcos: real; {some help variables}
    {eeh, sorry if i don't use all of them, no time for optimization}

procedure intro;
begin
 textcolor(15);
 writeln;
 writeln(' Name of object: ',objname);
 textcolor(7);
 writeln;
 writeln(' Keyz: x     - rotates around X axis,');
 writeln('       y     - rotates around Y axis,');
 writeln('       z     - rotates around Z axis,');
 writeln('       UP    - moves the object up,');
 writeln('       DOWN  - moves the object down,');
 writeln('       LEFT  - moves the object left,');
 writeln('       RIGHT - moves the object right,');
 writeln('       +     - moves the object to the front,');
 writeln('       -     - moves the object to the back,');
 writeln('       ,     - increases the perspective,');
 writeln('       .     - decreases the perspective,');
 writeln('       r     - resets the values.');
 writeln;
 writeln('Press a key to continue ...');
 readkey;
end;

procedure readdata;
var f:text;
begin
 writeln('3d Tutorial step#5 (C) 1996 by fh.');
 if ParamCount <> 1 then begin writeln('Usage: TUT5 datafile'); halt(0); end;
 assign(F,Paramstr(1));
 reset(F);
 readln(F,objname);
 readln(F,points,lines);
 p1:=0;
 for p:=1 to points do begin readln(F,obj[p1],obj[p1+1],obj[p1+2]); p1:=p1+3; end;
 p1:=0;
 for p:=1 to lines do begin readln(F,lobj[p1],lobj[p1+1]); p1:=p1+2; end;
 close(F);
end;

procedure draw(color:byte); {procedure to draw a cube}
begin
 for p:=0 to lines-1 do begin {loops for all lines}
  sx:=round(zoom*(per*obj[lobj[p*2]*3]/(per+obj[lobj[p*2]*3+2])))+160; {x coord for point1}
  sy:=round(zoom*(per*obj[lobj[p*2]*3+1]/(per+obj[lobj[p*2]*3+2])))+100; {y coord for point1}
  sx1:=round(zoom*(per*obj[lobj[p*2+1]*3]/(per+obj[lobj[p*2+1]*3+2])))+160; {x coord for point2}
  sy1:=round(zoom*(per*obj[lobj[p*2+1]*3+1]/(per+obj[lobj[p*2+1]*3+2])))+100; {y coord for point2}
  line(SX,SY,sx1,sy1,color); {draw line between points 1&2 in current color}
 end;
end;

procedure calc; {calculates new values after rotate step}
begin
 for p:=0 to points-1 do begin {repeats for all points}
  Yt := obj[p*3+1] * xCOS - obj[p*3+2] * xsin; {read old values from the table of coord,}
  Zt := obj[p*3+1] * xsin + obj[p*3+2] * xcos; {rotating about x axis}
  obj[p*3+1] := Yt; {writes the new values back to the table}
  obj[p*3+2] := Zt;

  Xt := obj[p*3] * ycos - obj[p*3+2] * ySIN; {same as above, for Y axis}
  Zt := obj[p*3] * ySIN + obj[p*3+2] * yCOS;
  obj[p*3] := Xt;
  obj[p*3+2] := Zt;

  Xt := obj[p*3] * zCOS - obj[p*3+1] * zSIN; {about Z axis}
  Yt := obj[p*3] * zSIN + obj[p*3+1] * zCOS;
  obj[p*3] := Xt;
  obj[p*3+1] := Yt;
 end;
end;

procedure move(xp,yp,zp:real);
begin
 for p:=0 to points-1 do begin {repeats for all points}
  obj[p*3]:=obj[p*3]+xp; {add xp to the X coord (even if it is less then 0)}
  obj[p*3+1]:=obj[p*3+1]+yp; {add yp to the Y coord}
  obj[p*3+2]:=obj[p*3+2]+zp; {...i think you've got the idea}
 end;
end;

begin
 readdata;
 intro;
 setmode;      {sets the 13h (320x200x256) mode}
 zoom:=30;     {size of the object}
 per:=6;       {the initial perspective}

 cls;
 draw(15);
 repeat        {loops ...}
  ch:=readkey;
  draw(0);
  xsin:=0; {'cause sin(0)=0}
  ysin:=0; {...}
  zsin:=0; {...}
  xcos:=1; {'cause cos(0)=1}
  ycos:=1; {...}
  zcos:=1; {...}
  case ch of
   'X' : begin xsin:=sin005; {rotates around X}
	 xcos:=cos005; end;  
   'Y' : begin ysin:=sin005; {...}
	 ycos:=cos005; end;
   'Z' : begin zsin:=sin005;
	 zcos:=cos005; end;
   'x' : begin xsin:=sin005; {for small caps, too}
	 xcos:=cos005; end;
   'y' : begin ysin:=sin005; {...}
	 ycos:=cos005; end;
   'z' : begin zsin:=sin005;
	 zcos:=cos005; end;
   ',' : begin per:=per+0.5;
         if per=12 then per:=11.5; end;      {increases the perspective}
   '.' : begin per:=per-0.5;
         if per=1.5 then per:=2; end;        {decreases the perspective}
   #77 : move(0.1,0,0);      {move right}
   #72 : move(0,-0.1,0);     {move up}
   #75 : move(-0.1,0,0);     {move left}
   #80 : move(0,0.1,0);      {move down}
   '+' : begin; move(0,0,-0.1); zoom:=zoom+5; end; {move to front} {or no?}
   '-' : begin; move(0,0,0.1); zoom:=zoom-5; end;  {move to back}
   'r' : readdata;           {resets the values}
   'R' : readdata;           { '  ' }
  end;
  calc;         {calculates the new coords}
  draw(15);     {draws it again}
  waitretrace;  {wait a sec!}
 until ch=#27;  {... 'till you press ESC}
 closegraph;    {jump back to text mode}
 writeln('3dTutorial step#5');
 writeln('Made by fh(c)96.');
end.
