UNIT BMP256;
{
	BMP256
	- by Bjarke Viksoe

	Converts Windows(tm) BMP image file in format 320x200 in 256 colours to
	a raw image. Accepts Windows(tm) .RLE / .DIB images too.
	It bitches over some of the RLE compressed pictures???
	Little IO checking. No picturesize checking.
}

INTERFACE

USES
	DEMOINIT, PICTURE;


Procedure LoadPix(buffer : pScreen; filename : string);
Procedure ConvertBMP(dst : pScreen; src : pBuffer);


(*--------------------------------------*)

IMPLEMENTATION

{$I-}

TYPE
	pHeader = ^HeaderType;
	HeaderType = RECORD
		{picture structure}
		bmptype : word;
		size : longint;
		reserved1, reserved2 : word;
		OffBits : longint;
		{bitmap header}
		biSize : longint;
		biWidth : longint;
		biHeight : longint;
		biPlanes : word;
		biBitCount : word;
		biCompression : longint;
		biSizeImage : longint;
		biXPelsPerMeter : longint;
		biYPelsPerMeter : longint;
		biClrUsed : longint;
		biClrImportant : longint;
	end;


Procedure ExtractCMAP(src : pBuffer; pos : word);
Var
	i,k  : word;
Begin
	k:=1;
	for i:=1 to 256 do begin
		CMAP[k]:=src^[pos+2] SHR 2;
		CMAP[k+1]:=src^[pos+1] SHR 2;
		CMAP[k+2]:=src^[pos] SHR 2;
		Inc(pos,4);
		Inc(k,3);
	end;
End;

Procedure ExtractBMP(h : pHeader; src : pScreen; dst : pScreen);
Var
	width, height : word;
	x,i  : word;
Begin
	if (h^.biCompression=0) then begin
		{No compression used...}
		x:=0;
		{Typical Good Ol' Bill...
		 To confuse the enemy he's put the picture up-side-down!}
		for i:=h^.biHeight-1 downto 0 do begin
			Move(src^[x*h^.biWidth], dst^[i*h^.biWidth], h^.biWidth);
			Inc(x);
		end;
	end
	else if (h^.biCompression=1) then begin
		{RLE8 compression used...}
		width:=h^.biWidth;
		height:=h^.biHeight;
		if (width*height) > 65535 then exit;
		x:=0;
		asm
			push	ds
			les	di,[dst]
			mov	ax,[height]
			dec	ax
			imul	[width]
			add	di,ax
			lds	si,[src]
			xor	cx,cx
			xor	bx,bx
			cld
@BMP_loop:
			lodsb
			or		al,al
			jz		@BMP_escape
			{it's a fill run}
			mov	cl,al
			add	bx,cx
			lodsb
			rep stosb
			jmp	@BMP_loop
@BMP_escape:
			{fetch escape code}
			lodsb
			or		al,al
			jz		@BMP_eol
			cmp	al,1
			je		@BMP_done
			cmp	al,2
			je		@BMP_delta
			{it's an absolute run}
			mov	cl,al
			add	bx,cx
			rep movsb
			mov	ax,si {align after absolute run}
			and	ax,1
			add	si,ax
			jmp	@BMP_loop
@BMP_eol:   {the eof-of-line escape}
			sub	di,bx       {return to pos 0 on line}
			sub	di,[width]  {go one line up...}
			xor	bx,bx
			dec	[height]
			jnz	@BMP_loop
			jmp	@BMP_done
@BMP_delta: {the delta escape}
			xor	ah,ah
			lodsb
			add	di,ax
			add	bx,ax
			lodsb
			mul	[width]
			add	di,ax
			xor	ax,ax
			jmp	@BMP_loop
@BMP_done:
			pop	ds
		end;
	end;
End;

Procedure ConvertBMP(dst : pScreen; src : pBuffer);
{Parse tga file}
Var
	h : pHeader;
	pos : word;
Begin
	h := pHeader(src);
	with h^ do begin
		{safety check for correct BMP file}
		if (bmptype<>$4D42) then exit; { type must be 'BM' }
		if (biWidth>320) OR (biHeight>240) OR (biPlanes<>1) OR (biBitCount<>8) then exit;
	end;
	pos:=h^.biSize + 14 + 1;
	ExtractCMAP( src, pos );
	ExtractBMP( h, pScreen( @src^[pos + (256*4) ]), dst );
End;


Procedure LoadPix(buffer : pScreen; filename : string);
Var
	pFileMem: pBuffer;
	FileHandle : file;
	size : longint;
Begin
	Assign(FileHandle, filename);
	Reset(FileHandle, 1);
	size := FileSize(FileHandle);
	if (size > 65535) then exit;
	if (size > MaxAvail) then exit;
	GetMem(pFileMem, size);
	BlockRead(FileHandle, pFileMem^, size);
	Close(FileHandle);
	If IOResult=0 then begin
		ConvertBMP(buffer, pFileMem);
	end;
	FreeMem(pFileMem, size);
End;

{$I+}

End.
