; =======================================================================
; FILE: DebVect.ASM
;
; COPYRIGHT (c) 1988, 1989 BY BORLAND INTERNATIONAL, Inc.
;
; PURPOSE: Device Driver Overlay (DDO) for the DEBUG.BGI driver
;          This file defines the vector table at the beginning of the
;          driver. The segment definitions allow this module to be
;          linked with a Turbo C module.
;
; Current Date: 09/15/88
;
; Updates:      None.
;
; =======================================================================

        INCLUDE DEVICE.INC              ; File defines vector table format

_TEXT   SEGMENT PARA PUBLIC 'CODE'
_TEXT   ENDS

_DATA   segment word public 'DATA'
_DATA   ENDS

_BSS    segment word public 'BSS'
_BSS    ENDS

_TEXT   SEGMENT PARA PUBLIC 'CODE'

DGROUP  group   _DATA, _TEXT, _BSS
        ASSUME  DS:DGROUP, CS:DGROUP

;       The following table defines all of the available vectors as
;       residing in the Turbo C module.

        EXTRN   _install       : NEAR,   _init           : NEAR
        EXTRN   _clear         : NEAR,   _post           : NEAR
        EXTRN   _move          : NEAR,   _draw           : NEAR
        EXTRN   _vect          : NEAR,   _bar            : NEAR
        EXTRN   _patbar        : NEAR,   _arc            : NEAR
        EXTRN   _pieslice      : NEAR,   _filled_ellipse : NEAR
        EXTRN   _palette       : NEAR,   _allpalette     : NEAR
        EXTRN   _color         : NEAR,   _fillstyle      : NEAR
        EXTRN   _linestyle     : NEAR,   _textstyle      : NEAR
        EXTRN   _text          : NEAR,   _textsiz        : NEAR
        EXTRN   _floodfill     : NEAR,   _getpix         : NEAR
        EXTRN   _putpix        : NEAR,   _bitmaputil     : NEAR
        EXTRN   _savebitmap    : NEAR,   _restorebitmap  : NEAR
        EXTRN   _setclip       : NEAR,   _color_query    : NEAR


        BGI     DEBUG           ; Defining a Debugging Driver

DDOVEC  DW      _install        ; Driver initialization and installation
                                ; Input:    AX=Command #   CX = Parameter
                                ; Output:   Varies according to command

        DW      _init           ; Initialize device for output
                                ; Input:    ES:BX points to information table
                                ; Output:   None

        DW      _clear          ; Clear graphics device and ready it for new
                                ; output. (Clear Screen, Load Paper, ... )
                                ; Input:    None
                                ; Output:   None

        DW      _post           ; Post - Make picture visible. Enable screen,
                                ; print paper, eject current sheet, ...
                                ; Input:    None
                                ; Output:   None

        DW      _move           ; Set Current Drawing Pointer to value.
                                ; Input:    AX = X coord,  BX = Y Coord
                                ; Output:   None

        DW      _draw           ; Draw a line from the Current Pointer to
                                ; the given coordinate.
                                ; Input:    AX = X coord,  BX = Y Coord
                                ; Output:   None

        DW      _vect           ; Draw a line between the given coordinate
                                ; pairs.
                                ; Input:    AX = X Start,  BX = Y Start
                                ;           CX = X End,    DX = Y End
                                ; Output:   None

        DW      EMULATE         ; Emulated polygon

        DW      _bar            ; Draw a filled rectangle with the CP as the
                                ; Lower Left corner, and the given coordinate
                                ; as the upper right.
                                ; Input:    AX = X Corner  BX = Y Corner
                                ;           CX = Depth for #D bars
                                ;           DX = Draw Top Flag (DX<>0 Draw Top)
                                ; Output:   None

        DW      _patbar         ; Draw a patterned rectangle with the given
                                ; coorinate pair. The pattern is provided by
                                ; the set fill pattern entry.
                                ; Input:    AX = X Corner  BX = Y Corner
                                ;           CX = X Corner  DX = Y Corner
                                ; Output:   None

        DW      _arc            ; Draw an elliptical arc from the given start
                                ; angle to the given end angle, using the CP
                                ; as the Center Point, and the given X and Y
                                ; Radii. Angles are 0-360 degrees.
                                ; Input:    AX = Start Angle  BX = End Angle
                                ;           CX = X radius of arc
                                ;           DX = Y radius of arc
                                ; Output:   None

        DW      _pieslice       ; Draw an elliptical sector from the given start
                                ; angle to the given end angle, using the CP
                                ; as the Center Point, and the given X and Y
                                ; Radii. Angles are 0-360 degrees.
                                ; Input:    AX = Start Angle  BX = End Angle
                                ;           CX = X radius of arc
                                ;           DX = Y radius of arc
                                ; Output:   None

        DW      _filled_ellipse ; Draw an ellipse using the CP as the Center
                                ; Point, and the given X and Y radii.
                                ; Input:    AX = X Radius of ellipse
                                ;           BX = Y Radius of ellipse
                                ; Output:   None

        DW      _palette        ; Set a palette entry to a given color.
                                ; Input:    AX = Index and Command Code
                                ;           BX, CX, DX as needed
                                ; Output:   None

        DW      _allpalette     ; Load the palette with a table of colors.
                                ; Input:    ES:BX = Palette Table to load
                                ; Output:   None

        DW      _color          ; Set the palette indexs for the current
                                ; drawing color and the current fill color.
                                ; Input:    AL = Drawing Color
                                ;           AH = Fill color
                                ; Output:   None

        DW      _fillstyle      ; Set current fill pattern. The fill pattern is
                                ; set to the pattern specified. If the pattern
                                ; number is -1 then the pattern is define in
                                ; a user supplied array.
                                ; Input:    AL = Pattern # (-1 for user def)
                                ;           ES:BX = User pattern data if needed
                                ; Output:   None

        DW      _linestyle      ; Set current line style. The line style is
                                ; set to the style specified. If the style
                                ; number is -1 then the style is define in
                                ; a user supplied pattern.
                                ; Input:    AL = Style # (-1 for user def)
                                ;           BX = User Line Pattern
                                ;           CX = Line Width (1 or 3)
                                ; Output:   None

        DW      _textstyle      ; Set the text attributes for font rendering
                                ; Input:    AL = Font Number
                                ;           AH = Font Path and Direction
                                ;           BX = Desired X Character Size
                                ;           CX = Desired Y Character Size
                                ; Output:   BX = Actual X Character Size
                                ;           CX = Actual Y Character Size

        DW      _text           ; Draw a string in the current font with the
                                ; justification point at the CP.
                                ; Input:    ES:BX = Pointer to string
                                ;           CX    = String Length

        DW      _textsiz        ; Calculate the dimensions (in pixels) of an
                                ; input text string.
                                ; Input:    ES:BX = Pointer to string
                                ;           CX    = String Length
                                ; Output:   BX    = Width of string
                                ;           CX    = Height of string

        DW      RESERVED        ; RESERVED

        DW      _floodfill      ; Do a floodfill in the current color using
                                ; the given (X,Y) address as the seed.
                                ; Input:    AX = X Coord  BX = Y Coord
                                ; Output:   None.

        DW      _getpix         ; Read a pixel from the given coord.
                                ; Input:    AX = X Coord  BX = Y Coord
                                ; Output:   DL = Pixel value read

        DW      _putpix         ; Write a pixel to the given coord.
                                ; Input:    AX = X Coord  BX = Y Coord
                                ;           DL = Pixel value read
                                ; Output:   None.


        DW      _bitmaputil     ; Return a pointer to a table of misc driver
                                ; utilities. The following describes the table.
                                ; Input:    None.
                                ; Output:   ES:BS = Base of table
                                ;
                                ;       DW GOTOGRAPHIC
                                ;       DW EXITGRAPHIC
                                ;       DW PUTPIX
                                ;       DW GETPIX
                                ;       DW (BITS PER PIXEL)
                                ;       DW SETPAGE
                                ;       DW SETVISUAL
                                ;       DW SETWRITEMODE

        DW      _savebitmap     ; Save a portion of the screen to CPU memory.
                                ; Input:    ES:BX = Pointer to CPU buffer
                                ;           SI    = Start X coord of save block
                                ;           DI    = Start Y coord of save block
                                ;           CX    = End X coord of save block
                                ;           DX    = End Y coord of save block
                                ; Output:   (In Save Block)

        DW      _restorebitmap  ; Restore a portion of the screen from CPU memory.
                                ; Input:    ES:BX = Pointer to CPU buffer
                                ;           SI    = Start X coord of save block
                                ;           DI    = Start Y coord of save block
                                ;           CX    = End X coord of save block
                                ;           DX    = End Y coord of save block
                                ;           AL    = Write mode for block writing
                                ; Output:   None.

        DW      _setclip        ; Set the clipping window to the rectangle
                                ; defined by the two (X,Y) pairs
                                ; Input:    AX = Upper Left X coord
                                ;           BX = Upper Left Y coord
                                ;           CX = Lower Right X coord
                                ;           DX = Lower Right Y coord
                                ; Output:   None.

        DW      _color_query    ; Return the parameters of the device color
                                ; table (Size, Default Palette, etc)
                                ; Input:    AL = Command for query
                                ; Output:   As required per command.

        DW     35 DUP (NONE)    ; Reserved Entry Points

_TEXT   ENDS                    ; Close the code segment

        END
