                IDEAL
                MODEL  TPascal
                LOCALS @@

                P286

StackSize EQU 500

EXTRN DevStack         : BYTE
EXTRN DevSS            : WORD
EXTRN DevSP            : WORD

EXTRN DoGetBuffer      : FAR

EXTRN CSOldInt8        : FAR

EXTRN Sounding         : DWORD
EXTRN SoundLeft        : WORD

EXTRN SystemClockIncr  : WORD
EXTRN SystemClockCount : WORD

EXTRN PeriodicCount    : WORD
EXTRN PeriodicStart    : WORD
EXTRN PeriodicProc     : DWORD

EXTRN DeviceIdling     : BYTE


;*******************************************

MACRO Chunk1
                CLI

                PUSH    AX
                PUSH    DS

                MOV     AX,SEG Sounding
                MOV     DS,AX

                MOV     [DevSS],SS
                MOV     [DevSP],SP
                MOV     SS,AX
                MOV     SP,OFFSET DevStack + StackSize

                PUSH    DX
                PUSH    CX
                PUSH    BX
                PUSH    ES

ENDM Chunk1

;*******************************************

; DeviceRut1

;*******************************************

MACRO Chunk21

                MOV     AX,[SoundLeft]
                AND     AX,AX
                JNZ     @@yeah

                PUSH    DI
                PUSH    SI
                CALL    DoGetBuffer
                POP     SI
                POP     DI

                AND     AX,AX
                JNZ     @@yeah

                INC     AH
                MOV     [DeviceIdling],AH

ENDM Chunk21

;-------------------------------------------

; DeviceRutFail

;-------------------------------------------

MACRO Chunk221

                JMP     SystemIntEntry

@@yeah:         DEC     AX
                MOV     [SoundLeft],AX

ENDM Chunk221

;-------------------------------------------

; DeviceRut1

;-------------------------------------------

MACRO Chunk222

                XOR     BH,BH
                MOV     [DeviceIdling],BH

                LES     BX,[Sounding]

ENDM Chunk222

;-------------------------------------------

MACRO Chunk22

                Chunk221
                Chunk222

ENDM Chunk22

;-------------------------------------------

MACRO Chunk2

                Chunk21
                Chunk22

ENDM Chunk2

;*******************************************

MACRO MonoChunk31

                MOV     AX,[ES:BX]
                ADD     AX,[ES:BX+2]
                ADD     AX,[ES:BX+4]
                ADD     AX,[ES:BX+6]
                XOR     AH,80h
                MOV     CL,AH

ENDM MonoChunk31

;-------------------------------------------

MACRO SterChunk31

                MOV     AX,[ES:BX]
                ADD     AX,[ES:BX+6]
                ADD     AX,AX
                MOV     CH,AH
                MOV     AX,[ES:BX+2]
                ADD     AX,[ES:BX+4]
                ADD     AX,AX
                MOV     CL,AH
                XOR     CX,8080h

ENDM SterChunk31

;-------------------------------------------

MACRO StMixChunk31

                MOV     CX,[ES:BX]
                ADD     CX,[ES:BX+6]
                MOV     DX,[ES:BX+2]
                ADD     DX,[ES:BX+4]
                MOV     AX,CX
                ADD     AX,DX
                SAR     AX,1
                ADD     CX,AX
                ADD     DX,AX
                MOV     CL,DH
                XOR     CX,8080h

ENDM StMixChunk31

;-------------------------------------------

MACRO StMix2Chunk31

                MOV     CX,[ES:BX]
                ADD     CX,[ES:BX+6]
                MOV     DX,[ES:BX+2]
                ADD     DX,[ES:BX+4]
                SAR     CX,1
                SAR     DX,1
                MOV     AX,CX
                ADD     AX,DX
                ADD     CX,AX
                ADD     DX,AX
                SAR     AX,1
                ADD     CX,AX
                ADD     DX,AX
                MOV     CL,DH
                XOR     CX,8080h

ENDM StMix2Chunk31

;===========================================

MACRO MonoChunk32

                MOV     CL,[ES:BX]
                XOR     CL,80h

ENDM MonoChunk32

;-------------------------------------------

MACRO SterChunk32

                MOV     CL,[ES:BX]
                XOR     CL,80h
                MOV     CH,CL

ENDM SterChunk32

;*******************************************

MACRO Chunk41 Size

                ADD     BX,Size
                MOV     [WORD PTR Sounding],BX

ENDM Chunk31

;-------------------------------------------

MACRO Chunk42

                INC     BX
                MOV     [WORD PTR Sounding],BX

ENDM Chunk42

;*******************************************

; DeviceRut2

;*******************************************

MACRO Chunk51
                JMP     SystemIntEntry
ENDM Chunk51

;-------------------------------------------

MACRO Chunk5

SystemIntEntry:
                POP     ES
                POP     BX
                POP     CX
                POP     DX

                MOV     SS,[DevSS]
                MOV     SP,[DevSP]

                DEC     [PeriodicCount]
                JNZ     @@NoSystemClock

                MOV     AX,[PeriodicStart]
                MOV     [PeriodicCount],AX

                MOV     AX,[SystemClockIncr]
                ADD     [SystemClockCount],AX
                JNC     @@nosys

                PUSHF
                CALL    FAR CSOldInt8
                JMP     @@sisys

@@nosys:        MOV     AL,20h
                OUT     20h,AL

@@sisys:        PUSHA
                PUSH    ES

                STI

                CALL    [PeriodicProc]

                POP     ES
                POPA

                JMP     @@Fin

@@NoSystemClock:
                MOV     AL,20h
                OUT     20h,AL

@@Fin:
                POP     DS
                POP     AX
                IRET

ENDM Chunk5

