/*******************  start of original comments  ********************/
/*
 * Written by Douglas Thomson (1989/1990)
 *
 * This source code is released into the public domain.
 */
/*********************  end of original comments   ********************/

/*
 * New editor name:  tde, the Thomson-Davis Editor.
 * Author:           Frank Davis
 * Date:             June 5, 1991
 *
 * This modification of Douglas Thomson's code is released into the
 * public domain, Frank Davis.  You may distribute it freely.
 *
 * See "tdestr.h" for a description of these variables. C requires global
 *  variables to be declared "extern" in all modules except one.  This file
 *  is included in ed.c and it should not be included in any other module.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#ifdef __TURBOC__
   #include <stdlib.h>
#elif __MSC__
   #include <stdlib.h>
   #if defined( toupper )
       #undef toupper
   #endif
#endif

displays g_display;

status_infos g_status;

boyer_moore_type bm;

CEH ceh;

SORT sort;

mode_infos mode = {
   0,           /* initial color scheme */
   FALSE,       /* sync mode? */
   TRUE,        /* sync semaphore must be TRUE - DO NOT CHANGE */
   FALSE,       /* macro recording mode must be FALSE - DO NOT CHANGE */
   TRUE,        /* insert mode */
   TRUE,        /* indent mode */
   8,           /* tab size */
   TRUE,        /* default smart tab mode */
   FALSE,       /* enhanced keyboard flag - set in main.c, video_config( ) */
   SMALL_INS,   /* default cursor size == small insert and large overstrike */
   "<=======   End of File   =======>",       /* eof message */
   TRUE,        /* default TRUE = do not write ^Z at end of file */
   CRLF,        /* default write <cr><lf> at eol */
   TRUE,        /* default remove trailing space on edited lines */
   FALSE,       /* default show eol character is off */
   NO_WRAP,     /* default word wrap mode is off */
   0,           /* default left margin - add 1 to margins for display */
   2,           /* default paragraph begin */
   71,          /* default right margin */
   FALSE,       /* default backup mode */
   TRUE,        /* default ruler mode */
   MM_DD_YY,    /* default date style */
   _12_HOUR     /* default time style */
};

/*
 * do_it is an array of pointers to functions that return int with an argument
 * that is a pointer to a window.  Is that right???
 */

#define NUM_FUNCS          122

int  (* (do_it[NUM_FUNCS]))( WINDOW * ) = {
   insert_overwrite,                /*   regular text keys        0  */
   get_help,                        /*   Help                     1  */
   insert_newline,                  /*   Rturn                    2  */
   next_line,                       /*   NextLine                 3  */
   beg_next_line,                   /*   BegNextLine              4  */
   move_down,                       /*   LineDown                 5  */
   move_up,                         /*   LineUp                   6  */
   move_right,                      /*   CharRight                7  */
   move_left,                       /*   CharLeft                 8  */
   scroll_right,                    /*   ScrollRight              9  */
   scroll_left,                     /*   ScrollLeft              10  */
   word_right,                      /*   WordRight               11  */
   word_left,                       /*   WordLeft                12  */
   page_down,                       /*   ScreenDown              13  */
   page_up,                         /*   ScreenUp                14  */
   goto_end_file,                   /*   EndOfFile               15  */
   goto_top_file,                   /*   TopOfFile               16  */
   goto_bottom,                     /*   BotOfScreen             17  */
   goto_top,                        /*   TopOfScreen             18  */
   goto_eol,                        /*   EndOfLine               19  */
   home,                            /*   BegOfLine               20  */
   goto_line,                       /*   JumpToLine              21  */
   center_window,                   /*   CenterWindow            22  */
   center_window,                   /*   CenterLine              23  */
   horizontal_screen_right,         /*   HorizontalScreenRight   24  */
   horizontal_screen_left,          /*   HorizontalScreenLeft    25  */
   scroll_down,                     /*   ScrollDnLine            26  */
   scroll_up,                       /*   ScrollUpLine            27  */
   fixed_scroll_up,                 /*   FixedScrollUp           28  */
   fixed_scroll_down,               /*   FixedScrollDn           29  */
   toggle_overwrite,                /*   ToggleOverWrite         30  */
   toggle_smart_tabs,               /*   ToggleSmartTabs         31  */
   toggle_indent,                   /*   ToggleIndent            32  */
   toggle_ww,                       /*   ToggleWordWrap          33  */
   toggle_crlf,                     /*   ToggleCRLF              34  */
   toggle_trailing,                 /*   ToggleTrailing          35  */
   toggle_z,                        /*   ToggleZ                 36  */
   toggle_eol,                      /*   ToggleEol               37  */
   toggle_sync,                     /*   ToggleSync              38  */
   toggle_ruler,                    /*   ToggleRuler             39  */
   set_tabstop,                     /*   SetTabs                 40  */
   set_left_margin,                 /*   SetLeftMargin           41  */
   set_right_margin,                /*   SetRightMargin          42  */
   set_paragraph_margin,            /*   SetParagraphMargin      43  */
   format_paragraph,                /*   FormatParagraph         44  */
   format_paragraph,                /*   FormatText              45  */
   left_justify,                    /*   LeftJustify             46  */
   right_justify,                   /*   RightJustify            47  */
   center_justify,                  /*   CenterJustify           48  */
   tab_key,                         /*   Tab                     49  */
   backtab,                         /*   BackTab                 50  */
   match_pair,                      /*   ParenBalance            51  */
   back_space,                      /*   BackSpace               52  */
   char_del_under,                  /*   DeleteChar              53  */
   char_del_under,                  /*   StreamDeleteChar        54  */
   line_kill,                       /*   DeleteLine              55  */
   eol_kill,                        /*   DelEndOfLine            56  */
   word_delete,                     /*   WordDelete              57  */
   insert_newline,                  /*   AddLine                 58  */
   insert_newline,                  /*   SplitLine               59  */
   join_line,                       /*   JoinLine                60  */
   dup_line,                        /*   DuplicateLine           61  */
   undo_line,                       /*   AbortCommand            62  */
   undo_line,                       /*   UndoLine                63  */
   undo,                            /*   UndoDelete              64  */
   toggle_search_case,              /*   ToggleSearchCase        65  */
   find_string,                     /*   FindForward             66  */
   find_string,                     /*   FindBackward            67  */
   find_string,                     /*   RepeatFindForward1      68  */
   find_string,                     /*   RepeatFindForward2      69  */
   find_string,                     /*   RepeatFindBackward1     70  */
   find_string,                     /*   RepeatFindBackward2     71  */
   replace_string,                  /*   ReplaceForward          72  */
   replace_string,                  /*   ReplaceBackward         73  */
   mark_block,                      /*   MarkBlock               74  */
   mark_block,                      /*   MarkLine                75  */
   mark_block,                      /*   MarkStream              76  */
   unmark_block,                    /*   UnMarkBlock             77  */
   move_copy_delete_overlay_block,  /*   FillBlock               78  */
   move_copy_delete_overlay_block,  /*   NumberBlock             79  */
   move_copy_delete_overlay_block,  /*   CopyBlock               80  */
   move_copy_delete_overlay_block,  /*   KopyBlock               81  */
   move_copy_delete_overlay_block,  /*   MoveBlock               82  */
   move_copy_delete_overlay_block,  /*   OverlayBlock            83  */
   move_copy_delete_overlay_block,  /*   DeleteBlock             84  */
   block_write,                     /*   BlockToFile             85  */
   block_print,                     /*   PrintBlock              86  */
   block_expand_tabs,               /*   BlockExpandTabs         87  */
   block_trim_trailing,             /*   BlockTrimTrailing       88  */
   block_convert_case,              /*   BlockUpperCase          89  */
   block_convert_case,              /*   BlockLowerCase          90  */
   block_convert_case,              /*   BlockStripHiBit         91  */
   sort_box_block,                  /*   SortBoxBlock            92  */
   date_time_stamp,                 /*   DateTimeStamp           93  */
   edit_another_file,               /*   EditFile                94  */
   dir_help,                        /*   DirList                 95  */
   file_file,                       /*   File                    96  */
   save_file,                       /*   Save                    97  */
   save_as_file,                    /*   SaveAs                  98  */
   change_fattr,                    /*   SetFileAttributes       99  */
   edit_next_file,                  /*   EditNextFile           100  */
   redraw_screen,                   /*   RedrawScreen           101  */
   size_window,                     /*   SizeWindow             102  */
   split_horizontal,                /*   SplitHorizontal        103  */
   split_vertical,                  /*   SplitVertical          104  */
   next_window,                     /*   NextWindow             105  */
   prev_window,                     /*   PreviousWindow         106  */
   zoom_window,                     /*   ZoomWindow             107  */
   next_hidden_window,              /*   NextHiddenWindow       108  */
   set_marker,                      /*   SetMark1               109  */
   set_marker,                      /*   SetMark2               110  */
   set_marker,                      /*   SetMark3               111  */
   goto_marker,                     /*   GotoMark1              112  */
   goto_marker,                     /*   GotoMark2              113  */
   goto_marker,                     /*   GotoMark3              114  */
   record_on_off,                   /*   RecordMacro            115  */
   play_back,                       /*   PlayBack               116  */
   save_strokes,                    /*   SaveMacro              117  */
   load_strokes,                    /*   LoadMacro              118  */
   clear_macros,                    /*   ClearAllMacros         119  */
   pause,                           /*   Pause                  120  */
   quit                             /*   Quit                   121  */
};

/*
 * set the 256 possible function keys to FS (First Stroke)
 * set the 1024 stroke buffer keys to SK (Stroke Key) and SN (Stroke Next)
 */
#define         FS      STROKE_LIMIT+1
#define         SK      MAX_KEYS+1
#define         SN      STROKE_LIMIT+1

MACRO macro = {
               /* 16 rows of 16 = 256 = MAX_KEYS */
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
   FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS, FS,
                 /* 102.4 rows of 10 = 1024 = STROKE_LIMIT */
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN, SK, SN,
SK, SN, SK, SN, SK, SN, SK, SN
};
