

/*
 * Group the list of available keys alphabetically.
 */
CONFIG_DEFS valid_keys[AVAIL_KEYS] = {
/*  available key      index into file   */
   { "a+\'",                     40 },
   { "a+-",                     130 },
   { "a+0",                     129 },
   { "a+1",                     120 },
   { "a+2",                     121 },
   { "a+3",                     122 },
   { "a+4",                     123 },
   { "a+5",                     124 },
   { "a+6",                     125 },
   { "a+7",                     126 },
   { "a+8",                     127 },
   { "a+9",                     128 },
   { "a+;",                      39 },
   { "a+<",                      51 },
   { "a+=",                     131 },
   { "a+>",                      52 },
   { "a+?",                      53 },
   { "a+[",                      26 },
   { "a+]",                      27 },
   { "a+a",                      30 },
   { "a+b",                      48 },
   { "a+backspace",              14 },
   { "a+c",                      46 },
   { "a+d",                      32 },
   { "a+e",                      18 },
   { "a+enter",                  28 },
   { "a+esc",                     1 },
   { "a+f",                      33 },
   { "a+f1",                    104 },
   { "a+f10",                   113 },
   { "a+f11",                   139 },
   { "a+f12",                   140 },
   { "a+f2",                    105 },
   { "a+f3",                    106 },
   { "a+f4",                    107 },
   { "a+f5",                    108 },
   { "a+f6",                    109 },
   { "a+f7",                    110 },
   { "a+f8",                    111 },
   { "a+f9",                    112 },
   { "a+g",                      34 },
   { "a+grey/",                 164 },
   { "a+greydel",               163 },
   { "a+greydown",              160 },
   { "a+greyend",               159 },
   { "a+greyenter",             166 },
   { "a+greyhome",              151 },
   { "a+greyins",               162 },
   { "a+greyleft",              155 },
   { "a+greypgdn",              161 },
   { "a+greypgup",              153 },
   { "a+greyright",             157 },
   { "a+greyup",                152 },
   { "a+h",                      35 },
   { "a+i",                      23 },
   { "a+j",                      36 },
   { "a+k",                      37 },
   { "a+l",                      38 },
   { "a+m",                      50 },
   { "a+n",                      49 },
   { "a+o",                      24 },
   { "a+p",                      25 },
   { "a+q",                      16 },
   { "a+r",                      19 },
   { "a+s",                      31 },
   { "a+t",                      20 },
   { "a+tab",                   165 },
   { "a+u",                      22 },
   { "a+v",                      47 },
   { "a+w",                      17 },
   { "a+x",                      45 },
   { "a+y",                      21 },
   { "a+z",                      44 },
   { "a+~",                      41 },
   { "backspace",                 9 },
   { "c+@",                     174 },
   { "c+[",                     201 },
   { "c+\\",                    202 },
   { "c+]",                     203 },
   { "c+^",                     204 },
   { "c+_",                     205 },
   { "c+a",                     175 },
   { "c+b",                     176 },
   { "c+backspace",              11 },
   { "c+c",                     177 },
   { "c+center",                143 },
   { "c+d",                     178 },
   { "c+del",                   147 },
   { "c+down",                  145 },
   { "c+e",                     179 },
   { "c+end",                   117 },
   { "c+enter",                   8 },
   { "c+esc",                     4 },
   { "c+f",                     180 },
   { "c+f1",                     94 },
   { "c+f10",                   103 },
   { "c+f11",                   137 },
   { "c+f12",                   138 },
   { "c+f2",                     95 },
   { "c+f3",                     96 },
   { "c+f4",                     97 },
   { "c+f5",                     98 },
   { "c+f6",                     99 },
   { "c+f7",                    100 },
   { "c+f8",                    101 },
   { "c+f9",                    102 },
   { "c+g",                     181 },
   { "c+grey*",                 150 },
   { "c+grey+",                 144 },
   { "c+grey-",                 142 },
   { "c+grey/",                 149 },
   { "c+greyenter",              43 },
   { "c+h",                     182 },
   { "c+home",                  119 },
   { "c+i",                     183 },
   { "c+ins",                   146 },
   { "c+j",                     184 },
   { "c+k",                     185 },
   { "c+l",                     186 },
   { "c+left",                  115 },
   { "c+m",                     187 },
   { "c+n",                     188 },
   { "c+o",                     189 },
   { "c+p",                     190 },
   { "c+pgdn",                  118 },
   { "c+pgup",                  132 },
   { "c+q",                     191 },
   { "c+r",                     192 },
   { "c+right",                 116 },
   { "c+s",                     193 },
   { "c+t",                     194 },
   { "c+tab",                   148 },
   { "c+u",                     195 },
   { "c+up",                    141 },
   { "c+v",                     196 },
   { "c+w",                     197 },
   { "c+x",                     198 },
   { "c+y",                     199 },
   { "c+z",                     200 },
   { "center",                   76 },
   { "del",                      83 },
   { "down",                     80 },
   { "end",                      79 },
   { "enter",                     6 },
   { "esc",                       2 },
   { "f1",                       59 },
   { "f10",                      68 },
   { "f11",                     133 },
   { "f12",                     134 },
   { "f2",                       60 },
   { "f3",                       61 },
   { "f4",                       62 },
   { "f5",                       63 },
   { "f6",                       64 },
   { "f7",                       65 },
   { "f8",                       66 },
   { "f9",                       67 },
   { "grey+",                   168 },
   { "grey-",                   167 },
   { "greyenter",                29 },
   { "home",                     71 },
   { "ins",                      82 },
   { "left",                     75 },
   { "pgdn",                     81 },
   { "pgup",                     73 },
   { "right",                    77 },
   { "s+a+\'",                   242 },
   { "s+a+-",                   216 },
   { "s+a+0",                   215 },
   { "s+a+1",                   206 },
   { "s+a+2",                   207 },
   { "s+a+3",                   208 },
   { "s+a+4",                   209 },
   { "s+a+5",                   210 },
   { "s+a+6",                   211 },
   { "s+a+7",                   212 },
   { "s+a+8",                   213 },
   { "s+a+9",                   214 },
   { "s+a+;",                   241 },
   { "s+a+<",                   253 },
   { "s+a+=",                   217 },
   { "s+a+>",                   254 },
   { "s+a+?",                   255 },
   { "s+a+[",                   228 },
   { "s+a+]",                   229 },
   { "s+a+a",                   232 },
   { "s+a+b",                   250 },
   { "s+a+c",                   248 },
   { "s+a+d",                   234 },
   { "s+a+e",                   220 },
   { "s+a+f",                   235 },
   { "s+a+g",                   236 },
   { "s+a+h",                   237 },
   { "s+a+i",                   225 },
   { "s+a+j",                   238 },
   { "s+a+k",                   239 },
   { "s+a+l",                   240 },
   { "s+a+m",                   252 },
   { "s+a+n",                   251 },
   { "s+a+o",                   226 },
   { "s+a+p",                   227 },
   { "s+a+q",                   218 },
   { "s+a+r",                   221 },
   { "s+a+s",                   233 },
   { "s+a+t",                   222 },
   { "s+a+u",                   224 },
   { "s+a+v",                   249 },
   { "s+a+w",                   219 },
   { "s+a+x",                   247 },
   { "s+a+y",                   223 },
   { "s+a+z",                   246 },
   { "s+a+~",                   243 },
   { "s+backspace",              10 },
   { "s+c+left",                170 },
   { "s+c+right",               171 },
   { "s+enter",                   7 },
   { "s+esc",                     3 },
   { "s+f1",                     84 },
   { "s+f10",                    93 },
   { "s+f11",                   135 },
   { "s+f12",                   136 },
   { "s+f2",                     85 },
   { "s+f3",                     86 },
   { "s+f4",                     87 },
   { "s+f5",                     88 },
   { "s+f6",                     89 },
   { "s+f7",                     90 },
   { "s+f8",                     91 },
   { "s+f9",                     92 },
   { "s+greyenter",              42 },
   { "s+tab",                    15 },
   { "tab",                      12 },
   { "up",                       72 }
};


/*
 * sorted alphabetic list of functions that keys may be assigned to.
 *   add 1 to NUM_FUNC so users may use either Macro or Playback to
 *   define macros.
 */

CONFIG_DEFS valid_func[NUM_FUNC+1] = {
   { "AbortCommand",                 62 },
   { "AddLine",                      58 },
   { "BackSpace",                    52 },
   { "BackTab",                      50 },
   { "BegNextLine",                   4 },
   { "BegOfLine",                    20 },
   { "BlockExpandTabs",              87 },
   { "BlockLowerCase",               90 },
   { "BlockStripHiBit",              91 },
   { "BlockToFile",                  85 },
   { "BlockTrimTrailing",            88 },
   { "BlockUpperCase",               89 },
   { "BotOfScreen",                  17 },
   { "CenterJustify",                48 },
   { "CenterLine",                   23 },
   { "CenterWindow",                 22 },
   { "CharLeft",                      8 },
   { "CharRight",                     7 },
   { "ClearAllMacros",              119 },
   { "CopyBlock",                    80 },
   { "DateTimeStamp",                93 },
   { "DelEndOfLine",                 56 },
   { "DeleteBlock",                  84 },
   { "DeleteChar",                   53 },
   { "DeleteLine",                   55 },
   { "DirList",                      95 },
   { "DuplicateLine",                61 },
   { "EditFile",                     94 },
   { "EditNextFile",                100 },
   { "EndOfFile",                    15 },
   { "EndOfLine",                    19 },
   { "File",                         96 },
   { "FillBlock",                    78 },
   { "FindBackward",                 67 },
   { "FindForward",                  66 },
   { "FixedScrollDn",                29 },
   { "FixedScrollUp",                28 },
   { "FormatParagraph",              44 },
   { "FormatText",                   45 },
   { "GotoMark1",                   112 },
   { "GotoMark2",                   113 },
   { "GotoMark3",                   114 },
   { "Help",                          1 },
   { "HorizontalScreenLeft",         25 },
   { "HorizontalScreenRight",        24 },
   { "JoinLine",                     60 },
   { "JumpToLine",                   21 },
   { "KopyBlock",                    81 },
   { "LeftJustify",                  46 },
   { "LineDown",                      5 },
   { "LineUp",                        6 },
   { "LoadMacro",                   118 },
   { "Macro",                       116 },
   { "MarkBox",                      74 },
   { "MarkLine",                     75 },
   { "MarkStream",                   76 },
   { "MoveBlock",                    82 },
   { "NextHiddenWindow",            108 },
   { "NextLine",                      3 },
   { "NextWindow",                  105 },
   { "Null",                          0 },
   { "NumberBlock",                  79 },
   { "OverlayBlock",                 83 },
   { "ParenBalance",                 51 },
   { "Pause",                       120 },
   { "PlayBack",                    116 },
   { "PreviousWindow",              106 },
   { "PrintBlock",                   86 },
   { "Quit",                        121 },
   { "RecordMacro",                 115 },
   { "RedrawScreen",                101 },
   { "RepeatFindBackward1",          70 },
   { "RepeatFindBackward2",          71 },
   { "RepeatFindForward1",           68 },
   { "RepeatFindForward2",           69 },
   { "ReplaceBackward",              73 },
   { "ReplaceForward",               72 },
   { "RightJustify",                 47 },
   { "Rturn",                         2 },
   { "Save",                         97 },
   { "SaveAs",                       98 },
   { "SaveMacro",                   117 },
   { "ScreenDown",                   13 },
   { "ScreenUp",                     14 },
   { "ScrollDnLine",                 26 },
   { "ScrollLeft",                   10 },
   { "ScrollRight",                   9 },
   { "ScrollUpLine",                 27 },
   { "SetFileAttributes",            99 },
   { "SetLeftMargin",                41 },
   { "SetMark1",                    109 },
   { "SetMark2",                    110 },
   { "SetMark3",                    111 },
   { "SetParagraphMargin",           43 },
   { "SetRightMargin",               42 },
   { "SetTabs",                      40 },
   { "SizeWindow",                  102 },
   { "SortBoxBlock",                 92 },
   { "SplitHorizontal",             103 },
   { "SplitLine",                    59 },
   { "SplitVertical",               104 },
   { "StreamDeleteChar",             54 },
   { "Tab",                          49 },
   { "ToggleCRLF",                   34 },
   { "ToggleEol",                    37 },
   { "ToggleIndent",                 32 },
   { "ToggleOverWrite",              30 },
   { "ToggleRuler",                  39 },
   { "ToggleSearchCase",             65 },
   { "ToggleSmartTabs",              31 },
   { "ToggleSync",                   38 },
   { "ToggleTrailing",               35 },
   { "ToggleWordWrap",               33 },
   { "ToggleZ",                      36 },
   { "TopOfFile",                    16 },
   { "TopOfScreen",                  18 },
   { "UndoDelete",                   64 },
   { "UndoLine",                     63 },
   { "UnMarkBlock",                  77 },
   { "WordDelete",                   57 },
   { "WordLeft",                     12 },
   { "WordRight",                    11 },
   { "ZoomWindow",                  107 }
};


/*
 * list of color fields sorted alphabetically
 */

CONFIG_DEFS valid_colors[NUM_COLORS*2] = {
   { "co80_Blocks",                  15 },
   { "co80_CurLine",                 20 },
   { "co80_EndOfFile",               19 },
   { "co80_FileHeader",              12 },
   { "co80_HelpScreen",              17 },
   { "co80_HilitedFile",             23 },
   { "co80_MessageLine",             16 },
   { "co80_ModeLine",                14 },
   { "co80_Ruler",                   21 },
   { "co80_RulerPointer",            22 },
   { "co80_Text",                    13 },
   { "co80_Wrapped",                 18 },
   { "mono_Blocks",                   3 },
   { "mono_CurLine",                  8 },
   { "mono_EndOfFile",                7 },
   { "mono_FileHeader",               0 },
   { "mono_HelpScreen",               5 },
   { "mono_HilitedFile",             11 },
   { "mono_MessageLine",              4 },
   { "mono_ModeLine",                 2 },
   { "mono_Ruler",                    9 },
   { "mono_RulerPointer",            10 },
   { "mono_Text",                     1 },
   { "mono_Wrapped",                  6 }
};


/*
 * list of editor modes sorted alphabetically
 */

CONFIG_DEFS valid_modes[NUM_MODES] = {
   { "Backups",             Backup  },
   { "ControlZ",            Write_Z },
   { "CursorStyle",         Size    },
   { "DateStyle",           Date    },
   { "DisplayEndOfLine",    Eol     },
   { "EndOfLineStyle",      Crlf    },
   { "IndentMode",          Ind     },
   { "InsertMode",          Ins     },
   { "LeftMargin",          Left    },
   { "ParagraphMargin",     Para    },
   { "RightMargin",         Right   },
   { "Ruler",               Ruler   },
   { "SmartTabMode",        Smart   },
   { "TabSize",             TAB     },
   { "TimeStyle",           Time    },
   { "TrimTrailingBlanks",  Trim    },
   { "WordWrapMode",        WW      },
};



CONFIG_DEFS off_on[2] = {
   { "Off",   0 },
   { "On",    1 }
};


CONFIG_DEFS valid_z[2] = {
   { "No_Z",     1 },
   { "Write_Z",  0 }
};


CONFIG_DEFS valid_cursor[2] = {
   { "Large",   1 },
   { "Small",   0 }
};


CONFIG_DEFS valid_crlf[2] = {
   { "CRLF",   1 },
   { "LF",     2 }
};


CONFIG_DEFS valid_wraps[3] = {
   { "DynamicWrap",   2 },
   { "FixedWrap",     1 },
   { "Off",           0 }
};


CONFIG_DEFS valid_dates[6] = {
   { "DD_MM_YY",     1 },
   { "DD_MM_YYYY",   4 },
   { "MM_DD_YY",     0 },
   { "MM_DD_YYYY",   3 },
   { "YY_MM_DD",     2 },
   { "YYYY_MM_DD",   5 }
};


CONFIG_DEFS valid_times[2] = {
   { "12_Hour",     0 },
   { "24_Hour",     1 }
};
