{ ------------------------------------------------------------------------ }
{                                                                          }
{            EDITED FOR SBC_TPx.TPU UNIT BY JARI KAIJA 1993                }
{                                                                          }
{ ------------------------------------------------------------------------ }
{                                                                          }
{   DESCRIPTION :                                                          }
{       This program demonstrates how to call the MIDI functions           }
{       to play a 'C major scale' using 10 MIDI instrument sound.          }
{                                                                          }
{       It also changes the pressure of note, so you will heard different  }
{       volume with each note.                                             }
{                                                                          }
{       The program is responsible for the timing between notes.           }
{                                                                          }
{       The program checks the BLASTER environment for the Card settings.  }
{       It also performs a test based on the BLASTER environment settings  }
{       to ensure they tally with the hardware settings on the Card.       }
{                                                                          }
{       Demondstration uses MIDI channel 1 to output MIDI data.            }
{                                                                          }
{ ------------------------------------------------------------------------ }

USES SBC_TPx, DOS, CRT;

procedure PlayScale;
const

    note_num : array[0..8] of byte = ( 60,62,64,65,67,69,71,72,74 );

var
    i,j : word;
    instrument, note : byte;

begin

    for instrument := 0 to 9 do begin
        sbmidi_out_shortmsg($C0,instrument,0);

        for note := 0 to 8 do begin
            sbmidi_out_shortmsg($90,note_num[note],random($80));

            for i := 0 to 150 do
                for j := 0 to 1500 do begin
                end;

            sbmidi_out_shortmsg($80,note_num[note],$40);
        end;
    end;

end;


{ ------------------------------------------------------------------------ }

begin
    if GetEnvSetting = 0 then begin
        if boolean( sbc_check_card and $0006 ) then begin
        clrscr;
        maker;
        sbc_dsp_reset;

        writeln;
        writeln('SB Developer kit version ',_sbclib_version_major,'.',_sbclib_version_minor,' by Jari Kaija');
        writeln;
        writeln('MIDI Play starts...');
            PlayScale;
        writeln('MIDI Play ends.');
        writeln;
        end
        else
            writeln('Sound Blaster card not found or wrong I/O setting.');
    end
    else
        writeln('BLASTER environment variable not set or incomplete or invalid.');
end.
