; NEW : ver 1.01 : Added support for many resolutions (see modes.asm)

;while viewing : SPACE - advance to next frame
;                ESC - quit

;speed controlled playback has not been done yet

include qlib.inc
include play.inc
include video.inc
include key.inc
include string.inc
include file.inc

.data
  h dw ?
  tvid dd ?
  str1 dd ?
  head play_flk <>
  mode dd ?
  mode_name dd ?
  bufsiz dd ?
  timer dd 46ch

include modes.asm

.code
error1 proc,a:dword
  callp print,a
  callp exit,0
error1 endp

main proc
  .if byte ptr _argc!=2
    callp error1,"PLAYFLK Ver1.01\n Usage: PLAYFLK filename.flk\n"
  .endif

  mov eax,_argv
  mov eax,[eax+1*4]
  mov str1,eax

  callp open,str1,0
  .if eax==ERROR
    callp error1,"Error : File not found\n"
  .endif
  mov h,ax
  callp read,h,offset head,sizeof head
  .if eax!=sizeof head
    callp error1,"Error : File corrupt\n"
  .endif
  callp close,h

  mov eax,_base
  sub timer,eax

  movzx eax,head.xres 
  movzx ebx,head.yres
  movzx ecx,head.bpp
  mul ebx
  .if ecx==8
    ;nothin
  .elseif ecx==15 || ecx==16
    shl eax,1
  .elseif ecx==24
    mov edx,3
    mul edx
  .endif
  mov bufsiz,eax
  callp malloc,eax
  .if eax==ERROR
    callp error1,"No RAM available"
  .endif
  mov tvid,eax
  callp gset,tvid

  movzx ebx,head.xres
  movzx ecx,head.yres
  movzx edx,head.bpp
  .if (ebx==320) && (ecx==200) && (edx==8)
    ;although VESA does support this mode (153h) it does not appear on all cards
    callp setgmode,13h
    jmp video_set
  .endif  
  mov esi,offset modes
@@:
  lodsd
  .if !eax
    callp printf,"Unable to find mode: %d x %d %dbpp\n",head.xres \
      ,head.yres,head.bpp
    callp exit,0
  .endif
  mov mode,eax
  lodsd
  .if eax!=ebx
    add esi,3*4
    jmp @b
  .endif
  lodsd
  .if eax!=ecx
    add esi,2*4
    jmp @b
  .endif
  lodsd
  .if eax!=edx
    add esi,1*4
    jmp @b
  .endif
;found mode!
  lodsd
  mov mode_name,eax
  mov eax,mode
  callp checkvbemode
  .if eax==ERROR
    callp printf,"Unable to set VBE 2.0 mode : %s\n",mode_name
    callp exit,0
  .endif

  call setvbemode

video_set:

  callp play_init

  callp play_open,str1   ;uses a handle!
top:
  .if play_status==play_done
    jmp again
  .endif
  call play_next
  .if (perror)
    callp setgmode,3
    callp print,"Play error\n"
    callp exit,0
  .endif
  call play_pal   ;this should be called right before or after updating screen
  call v_copy
  mov eax,timer
  mov ecx,[eax]
wait1:
  mov ebx,[eax]
  sub ebx,ecx
  cmp ebx,2
  jb wait1

  call getch
  cmp al,27
  jnz top
  call play_close  ;closes file!
  callp setgmode,3
  ret
again:
  callp play_seek,1
  .if eax==ERROR
    callp setgmode,3
    callp print,"PLAY_SEEK error\n"
    callp exit,0
  .endif
  jmp top
main endp

end
