; STDLIB32 for PMC
; (c) Ng Yew Choong (arjuna/sad little people) 1995
; tty.asm - bios console output routines

ideal
smart
jumps
locals  @@

p386

include "pmc.inc"
include "stdlib32.inc"


segTEXT

proc c  tty_putchr \
        chr:dword

        pushad
        mov     ah,0fh
        int     10h
        mov     ah,0eh
        mov     al,[byte chr]
        int     10h
        popad
        xor     eax,eax
        ret
endp


proc c  _tty_putstr \
        string:dword, flag:dword

        pushad
        mov     ah,0fh
        int     10h
        mov     esi,[string]
@@loop:
        mov     al,[esi]
        or      al,al
        jz      @@exit
        mov     ah,0eh
        int     10h
        cmp     [flag],0
        jz      @@skip
        cmp     al,10
        jnz     @@skip
        mov     ah,0eh
        mov     al,13
        int     10h
@@skip:
        inc     esi
        jmp     @@loop
@@exit:
        popad
        xor     eax,eax
        ret
endp


proc c  tty_putstr_raw \
        string:dword

        push    0
        push    [string]
        call    _tty_putstr
        add     esp,8
        ret
endp


proc c  tty_putstr \
        string:dword

        push    1
        push    [string]
        call    _tty_putstr
        add     esp,8
        ret
endp


ends

end
