/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* roll APL2 V1.0.0 ****************************************************
* Returns a random selection from the whole numbers beginning with     *
* indxorg and ending with indxorg+n-1.  This version works with        *
* the zortech C++ compiler.                                            *
***********************************************************************/
#define INCLUDES 0
#include "includes.h"
double roll(n)
double n;
{
	extern int aplerr;
	extern int indxorg;
	double r;
#if APL_DOS
	double divisor=32767.0;
#else
	double divisor=RAND_MAX;
#endif

	if (n == 0.0) return(0.0);
	if (n < 0.0) {
		aplerr = 37;
		return(0.0);
	}
	r = indxorg;
	return(r + ((double) rand())/divisor * (double) n);
}
