/*Copyright (C) 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* relative APL2 V1.0.0 ************************************************
* Extends dyadic scalar functions such as and and or to conformable    *
* pairs of APL variables item-by-item.  Arguments must either agree    *
* in shape, or one must have only a single element, which is repeatedly*
* matched with elements of the other.  If both arguments have one item,*
* but differing ranks, the result has the higher rank.                 *
* example:                                                             *
*   relative(and,litvect("0.0 0.0 1.0 1.0"),                           *
*                litvect("0.0 1.0 0.0 1.0"));                          *
*   produces the vector 0 0 0 1.                                       *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb relative(oper,left,rite)
int (*oper)(); /* operator */
Aplcb left,rite; /* operands */
{
	Dyadicm; Errstop; Matchok;
	extern int aplerr;
	double *dataout,*leftptr,*riteptr;
	int i,leftinc,riteinc;
	Aplcb out;

	if (!matchok(&left,&rite,APLNUMB))
		return(NULL); /* m/b real */
	out=dyadicm(left,rite,
		((void **)&dataout),((void **)&leftptr),((void **)&riteptr),
		&leftinc,&riteinc,APLNUMB
		); /* go build APLCB */
#include "dyadcom.h"
}
