/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* reduce APL2 V1.0.0 **************************************************
* Call format is - c=reduce(operator,identity,operand,axis);           *
* Reduce may be most easily understood by first looking at how it works*
* on a vector, e.g. "1 2 3 4 5".  It obtains a result by applying the  *
* specified operator, e.g. plus, in a fashion equivalent to the        *
* expression "1+2+3+4+5", producing 15 for an answer.  Reduce  does the*
* operation right-to-left, however, so the minus operator applied to   *
* "1 2 3 4 5" produces the answer 3, not -13.                          *
*                                                                      *
* For an argument that is a scalar or vector, the result is a scalar.  *
* For arguments of higher rank, n, the result is of rank n-1.          *
* Arguments of rank 2 or more are treated as collections of vectors,   *
* the axis argument determining how the vectors are constructed.       *
* Suppose m is a 3-by-4 matrix, as follows:  1   2   3   4             *
*                                            5   6   7   8             *
*                                            9  10  11  12             *
*                                                                      *
* reduce(plus,NIL,m,1) produces:  15 18 21 24                          *
* reduce(plus,NIL,m,2) produces:  10 26 42                             *
*                                                                      *
* The identity argument is a pointer to a double floating point value  *
* that is used only for reduction of an empty vector, the result being *
* the identity value.  For plus and minus, the identity element is 0.  *
* For multiplication and division it is 1.                             *
*                                                                      *
* in the case of a scalar or vector of length 1, the result is the     *
* item itself.                                                         *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb reduce(oper,identity,rite,axis)
double (*oper)(); /* operator */
double *identity; /* identity value */
Aplcb rite; /* operand */
int axis; /* axis of reduction */
{
     Reducesb;

     return(reducesb(1,oper,identity,rite,axis));
}
