/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* quadin APL2 V1.0.0 **************************************************
* Called by execexef.  Accepts an expression from the standard input   *
* file, evaluates it and returns the result.  Empty input, one with    *
* nothing other than tabs, newlines, and spaces, is ignored, and a new *
* prompt is issued.  System commands entered will be executed, then    *
* the prompt will be re-issued.                                        *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+STRING
#include "includes.h"
Aplcb quadin()
{
	Aplscan; Aplwksp; Codechar; Compute; Endoper; Errinit; Errstop;
	Getchrv;
	extern int aplerr;
	Aplcb in,out;
	char *cp,*cpend,prompt[10];
	int i;

	if (errinit()) return(NULL);
	strcat(strcpy(prompt,codechar(QUAD)),codechar(COLON));
	for(out = NULL; out == NULL;) {
		aplerr = 0; /* reset prior error. */
		in = getchrv(prompt); /* get input */
		if (aplerr) return(NULL);
		if (in->aplcount == 0) 
			endoper(in); /* ignore null input */
		else {
			cp = in->aplptr.aplchar;
			cpend = cp + in->aplcount;
			i = aplscan(&cp,cpend); /* find first token code */
			if (cp == cpend && i == RIGHT_ARROW)
				return(errstop(0,in,NULL,NULL));
			if (i == RIGHT_PAREN)
				i = aplwksp(in,cp,cpend); /* in w/b freed */
			else out = compute(in);
		}
	}
	return(errstop(0,NULL,NULL,out));
}
