/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* partitp APL2 V1.0.0 *************************************************
* Called by partito to create the next partition.                      *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb partitp(out,rite,lead,n,trail,top,oaxi,raxi,botcnt,axis)
Aplcb out;	/* Variable to which selected items are assigned. */
Aplcb rite;	/* Variable from which items are selected. */
int lead;		/* Number of items to drop from start of candidates. */
int n;		/* Number of items to go in this partition. */
int trail;     /* Number of items to drop from end of candidates. */
int top;		/* Index (rel 0) along items above axis. */
int oaxi;		/* Index (rel 0) in axis to next in output. */
int raxi;		/* Index (rel 0) in axis beyond last in candidates. */
int botcnt;	/* Count of elements separating each item along axis. */
int axis;		/* Axis (rel 0) along which partitioning is to be done. */
{
	Dtacopy; Getcb;
	Aplcb new,*op;
	int bot,datatyp,oaxicnt,raxicnt;
	char *ip;

	datatyp = rite->aplflags & (APLMASK | APLAPL);
	oaxicnt = *(out->apldim + axis);
	raxicnt = *(rite->apldim + axis);
	op = out->aplptr.aplapl + top*oaxicnt*botcnt + oaxi*botcnt;
	ip = rite->aplptr.aplchar + rite->aplsize *
		(top*raxicnt*botcnt + (raxi-n-trail)*botcnt);
	for(bot = 0; bot < botcnt; bot++) {
		new = getcb(NULL,n,datatyp,1,NULL);
		*(op + bot) = new;
		if (n && new != NULL) {
			dtacopy(new->aplptr.aplchar,
				ip + (bot * rite->aplsize),
				n,botcnt,datatyp);
		}
	}
}
