/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* namelen APL2 V1.0.0 *************************************************
* Called by aplcpyd and execqncs to obtain the location and length of  *
* an apl name in an array of names.  The name is checked, and if not   *
* well formed, a length of 0 is returned.                              *
***********************************************************************/
#define INCLUDES APLCHDEF
#include "includes.h"
int namelen(nameary,colsize,ix,nameptr)
char *nameary;		/* Array of names. */
int colsize;		/* Size allowed for each name, padded with blanks. */
int ix;			/* Index, origin 0, of desired name. */
char **nameptr;	/* Will be set on return to start of name. */
{
	Aplname; Aplquae; Aplscan; Codechar;
	char *s,*t,*u,*v;
	int code,len;

	t = 1 + (s = *nameptr = nameary + ix * colsize); /* next name */
	if (*s == *codechar(QUAD) && aplquae(&t,s + colsize))
		u = t; /* it is e.g. Lio */
	else
		u = t = aplname(s, s + colsize); /* end of next name */
	if (u == s + colsize)	code = SPACE;
		else				code = aplscan(&u, s + colsize);
	if (0 == (len = t - s) || code != SPACE || u != s + colsize)
		return(0); /* Invalid name, return 0 length. */
	else
		return(len); /* Name is well formed. Return length. */
}

