/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* matmult.c APL2 V1.0.0 ***********************************************
* Called by mdivide.                                                   *
* Given two matrices A and B, A having M rows and N columns, B having  *
* N rows and P columns, matmult will return a pointer to a new matrix  *
* C, having M rows and P columns.  An element in C at the Ith row and  *
* Jth column is formed by the sum of a[i][k]*b[k][j], for k=1 to N.    *
***********************************************************************/
#define INCLUDES APLMEM
#include "includes.h"
double *matmult(a,b,arows,acols,bcols)
double *a,*b;
int arows,acols,bcols;
{
	int i,j,k;
	double t,*m,*n,*c;
	c=malloc(arows*bcols*sizeof(t));
	for (i=0;i<arows;i++) {
		m=a+i*acols; /* proper row in a */
		n=c+i*bcols; /* proper row in c */
		for (k=0;k<bcols;k++) {
			t=0.0;
			for (j=0;j<acols;j++)
				t+=*(m+j)*(*(b+j*bcols+k));
			*(n+k)=t;
		}
	}
	return(c);
}
