/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* Matchsub APL2 V1.0.0 ************************************************
* Called by match.									           *
* Yields 1 if arguments are same in structure and data, 0 otherwise.	 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int matchsub(datatyp,lp,rp)
int datatyp;   /* data type pointed to by lp, rp.  */
char *lp, *rp; /* pointers to data to be compared. */
{
	Eq; Ivalue; Match;
	extern int aplerr;
	int ret;
 
	switch (datatyp) {
		case APLCHAR:
          	ret = (*lp == *rp);
               break;
		case APLINT:
			ret = (*(int *)lp == *(int *)rp);
			break;
		case APLNUMB:
			ret = eq(*(double *)lp, *(double *)rp);
			break;
		case APLAPL:
			ret = ivalue(match(*(Aplcb *)lp,*(Aplcb *)rp));
			break;
		default:
          	ret = 0;
          	aplerr = 999;
               break;
	} /* end select */
	return(ret);
}

