/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* matchoks APL2 V1.0.0 ************************************************
* Called by matchok, scalax to check for matching data types. Returns 1*
* if ok, 0 if not.	A char var w/b converted to a numeric type only if *
* empty. When data types are a mix of integer and real, the integer is *
* converted to real. When data types are a mix of real and complex, the*
* real will be converted to complex.							 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int matchoks(pleft,prite,datatyp)
Aplcb pleft[], prite[];
int datatyp;
{
	Aplnest; Formdft; Matchget; Matchokt;
	extern int aplerr;
	Aplcb left, rite;
	int ltype,rtype;

	ltype=(left=*pleft)->aplflags & (APLMASK + APLAPL);
	rtype=(rite=*prite)->aplflags & (APLMASK + APLAPL);
	if ((ltype == rtype) && (ltype & datatyp)) return(1); /* ok */
	if (left->aplcount == 0 && (rtype & datatyp)) {
		*pleft = matchget(left,rtype); /* convert empty */
		return(1); /* ok */
	}
	if (rite->aplcount == 0 && (ltype & datatyp)) {
		*prite = matchget(rite,ltype); /* convert empty */
		return(1); /* ok */
	}
	if (	(datatyp & APL_NUMERIC) && 
		(ltype & APL_NUMERIC) && 
		(rtype & APL_NUMERIC))
		return(matchokt(pleft,prite,datatyp,ltype,rtype));
	if (datatyp & APLAPL) {
		if (ltype != APLAPL) *pleft = aplnest(left);
		if (rtype != APLAPL) *prite = aplnest(rite);
		return(1);
	}
	if (datatyp & APLCHAR) {
		if (ltype != APLCHAR) *pleft = formdft(left);
		if (rtype != APLCHAR) *prite = formdft(rite);
		return(1);
	}
	return(0); /* data not ok */
}
