/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* getfact APL2 V1.0.0 *************************************************
* Called by transpot to obtain skip factors based on the               *
* dimensions passed as argument, e.g. if argument is the vector 2 3 4, *
* the skip factors returned will be 12 4 1. If rite isn't scalar, it   *
* is assumed to be a vector.                                           *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb getfact(rite)
Aplcb rite;
{
	Cat; Drop; Endoper; Errstop; Iscalar; Iscan; Itimes; Perm; Reverse;
	extern int indxorg;
	int itimesid=1;
	Aplcb out;

	if (rite->aplcount)
		out = perm(reverse(			/* Contains a factor for each  */
			drop(	/* axis of rite giving the number of elements */
				iscalar(-1),	/* skipped when the corresponding   */
				cat(			/* index is bumped by 1. If rite has*/
					iscalar(1), /* dimensions 2 3 4, factor will  */
					iscan(itimes,&itimesid, /* be 12 4 1. This is */
						reverse(rite,indxorg),	 /* the same as */
						indxorg),			 /* `R-1U1,X\`Rrite. */
					indxorg)),
			indxorg));
	else {
		out = perm(iscalar(1));
		endoper(rite);
	}
	return(errstop(0,NULL,NULL,out));
}
