/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* funinit.c - APL2 V1.0.0 *********************************************
* Called by apl.  Initializes all the static structures that describe  *
* builtin APL functions.                                               *
***********************************************************************/
#include <limits.h>
#define INCLUDES APLCHDEF+APLTOKEN+APLCB+FUNCODES+FUNSTRUC
#include "includes.h"
#include "funstat.h"
void funinit(void)
{
#include "funscalr.h"
#include "funmixed.h"
#include "funoper.h"
#include "funmacs.h"
#include "funassgn.h"
#include "funassgo.h"
#include "funassgs.h"
}
/* funexec *************************************************************
* Called by execexeg to test the current token for a function.         *
***********************************************************************/
Apltoken funexec(tok)
Apltoken tok; /* current token */
{
     Newtok;
     extern int aplerr;
     void *func=NULL;

     if (aplerr || tok == NULL) return(tok);
     switch (tok->token_code) {
#include "funcase.h"
     default: return(tok); /* no function found */
     } /* end switch */
     if (tok->token_flags & TOKPERM)
          tok = newtok(FUNCTION_TOKEN, 0, tok->token_offset, NULL, 0);
     tok->token_code = FUNCTION_TOKEN;
     tok->token_ptr.token_function = func;
     return(tok);
}
