/* Copyright (C) 1992 by Thomas Glen Smith.  All Rights Reserved. */
/* funcinit APL2 V1.0.0 ************************************************
* Called from funcmain to initialize the local variable tree.          *
***********************************************************************/
#define INCLUDES APLMEM+APLCB+APLTOKEN+APLFUNCI+TREE
#include "includes.h"
void funcinit(fp,left,rite)
Aplfunc fp;		/* Function definition structure. */
Aplcb left,rite;	/* Operands, or may be NULL. */
{
#include "quadext.h"
	Aplcopy; Avladd; Getcb; Perm;
	extern int aplerr; extern Treelist treehdr;
	Apltoken tok; Avlnode pav,*phd; Aplcb out; char *nameptr;

	tok = fp->funcvars; /* list of local variables */
	if (fp->functype & RETVAL) { /* Now localize return value name */
		phd = &(treehdr->avlhdr);
		pav = avladd(phd,tok->token_ptr.token_string,NULL);
		tok = tok->token_queue.token_next_ptr; /* next local name */
	}
	if (fp->functype & DYAD) { /* Now localize left operand */
     	if (left != NULL)
			if (left->aplflags & APLTEMP)
				left->aplflags -= APLTEMP;
			else left = perm(aplcopy(left));
		phd = &(treehdr->avlhdr);
		pav = avladd(phd,tok->token_ptr.token_string,left);
		tok = tok->token_queue.token_next_ptr; /* next local name */
	}
	if (fp->functype & (DYAD + MONAD)) {
     	if (rite != NULL)
			if (rite->aplflags & APLTEMP)
				rite->aplflags -= APLTEMP;
			else rite = perm(aplcopy(rite)); /* localize */
		phd = &(treehdr->avlhdr);
		pav = avladd(phd,tok->token_ptr.token_string,rite);
		tok = tok->token_queue.token_next_ptr; /* next local name */
	}
	while (tok != NULL) { /* localize other variables */
		switch (tok->token_code) {
			case QUAD_CT:	nameptr=quadct; treehdr->fuzzsave=1; break;
			case QUAD_IO:	nameptr=quadio; treehdr->indxsave=1; break;
			default:		nameptr=tok->token_ptr.token_string;
		}
		phd = &(treehdr->avlhdr);
		pav = avladd(phd, nameptr, NULL);
		tok = tok->token_queue.token_next_ptr; /* next local name */
	}
	/* Now localize labels */
	for (tok=fp->funclabs;tok!=NULL;tok=tok->token_queue.token_next_ptr) {
		out = getcb(NULL,1,APLINT+APLLABEL,0,NULL);
		if (aplerr) break;
		*(out->aplptr.aplint) = tok->token_offset;
		phd = &(treehdr->avlhdr);
		pav = avladd(phd,tok->token_ptr.token_string,out);
	}
}
