/* Copyright (C) 1995 by Thomas Glen Smith.	All Rights Reserved. */
/* formscj APL2 V1.0.0 *************************************************
* Called by formsci if an adjustment m/b made to the exponent.		 *
***********************************************************************/
#define INCLUDES STDIO+STRING+FORM
#include "includes.h"
void formscj(bufptr,bufint,buffer,expadj,eptr)
char	**bufptr;	/* Ptr to array of ptrs into value to format. */
int	*bufint;	/* Ptr to array of int describing value to format. */
char *buffer;	/* Work buffer in which to format value. */
int expadj;	/* Amount to adjust exponent. */
char *eptr;	/* Pointer to "e" in e-notation. */
{
	Formats;
	int expwrk,incr;
	char *dp;

	dp = DECIMAL_POINT(bufptr); /* Address of d.p. */
	expwrk = expadj; /* Copy adjustment. */
	incr = expwrk > 0 ? 1 : -1; /* Increment. */
	while(expwrk) { /* Now adjust d.p. in base. */
		*dp = *(dp - incr); /* Shift digit. */
		*(dp -= incr) = '.'; /* Shift d.p. and d.p. ptr. */
		expwrk -= incr;
	}
	formats(buffer,bufptr,bufint); /* Stats on base. */
	sscanf(eptr+1, "%d", &expwrk); /* Input formatted exponent. */
	expwrk += expadj; /* Adjust exponent. */
	if (expwrk >= 0) { /* Exponent positive? */
		*(eptr+1) = '+'; /* Sign of exponent. */
	} else { /* Exponent is negative. */
		*(eptr+1) = '-'; /* Sign of exponent. */
		expwrk = -expwrk; /* Absolute value of exponent. */
	}
	sprintf(eptr+2,"%d",expwrk); /* Format exponent. */
}
