/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* formatu APL2 V1.0.0 *************************************************
* Called by formota.                                                  	 *
***********************************************************************/
#define INCLUDES FORM
#include "includes.h"
void formatu(fcc_final,fcc_explicit,four_switch,dpp,ch)
int *fcc_final;	/* Final set of format control flags. */
int *fcc_explicit;	/* Explicitly defined format control flags. */
int four_switch;	/* 1 if '4' has been seen this side of d.p. */
char *dpp;		/* Points to d.p. - NULL if we're left of it. */
char ch;			/* New format control character. */
{
	int lsw, rsw;
	static int	lall=(FC1L | FC2L | FC3L | FC4L),
				rall=(FC1R | FC2R | FC3R | FC4R);

	switch (ch) {
		case '1': lsw = FC1L; rsw = FC1R; break;
		case '2': lsw = FC2L; rsw = FC2R; break;
		case '3': lsw = FC3L; rsw = FC3R; break;
	} /* end switch */
	
	if (dpp == NULL) { /* Left of d.p.? */
		*fcc_explicit	&= ~lall; /* Turn off all prior. */
		*fcc_explicit	|= lsw; /* Turn on new. */
		*fcc_final	&= ~lall; /* Turn off all prior. */
		*fcc_final	|= lsw; /* Turn on new. */
		if (!four_switch) {
			*fcc_final &= ~rall; /* Turn off all prior. */
			*fcc_final |= rsw; /* Turn on new. */
		}
	}
	else { /* Right of decimal point. */
		*fcc_final	&= ~rall; /* Turn off all prior. */
		*fcc_final	|= rsw; /* Turn on new. */
		if (!four_switch)
			if (!(*fcc_explicit & lall)) {
				*fcc_final &= ~lall; /* Turn off all prior. */
				*fcc_final |= lsw; /* Turn on new. */
			}
	}
}
