/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* formatc APL2 V1.0.0 *************************************************
* Called from form when the left argument is NULL.  Formatc will set   *
* widthcb and precb to vectors containing widths and precisions for    *
* each column of rite.                                                 *
***********************************************************************/
#define INCLUDES APLCB+FORM
#include "includes.h"
void formatc(cba)
Aplcb cba;
{
	extern double pp; /* Quad-pp = print presicion */
     int col, cols, d, *dp, e, f, *fp, i, maxw=15, mypp, p, *sp, w, *wp;

	mypp = pp;
     if (mypp < 0 || mypp > 10) mypp = 10; /* be realistic */
	cols = *(cba->apldim + 1);
     dp = Digicb;
     fp = Fraccb;
     sp = Signcb;
     wp = Widcb;
     i = 0;
	for (col = 0; col < cols; col++) { /* Once for each column of rite. */
     	f = *fp++; /* places to right of decimal */
          p = (f) ? 1 : 0; /* 1 for decimal point if not integer */
          d = *dp++; /* Digits left of decimal. */
		e = 0; /* Default is to not print in e-notation. */
		if (f + d > mypp) { /* Too much to print? */
			if (d >= mypp) /* Print as integer? */
				p = f = *(Precb + col) = 0; /* No decimal point. */
			else *(Precb + col) = f = mypp - d; /* Reduce places */
	          if (d == 0 /* Is digits left of d.p. 0? */
				&& p  /* Are there digits right of d.p.? */
				&& *wp >= mypp) /* Are there more than Lpp zeros */
				e = 1; /* before 1st significant digit? */
		}
          if (!e) {
	     	w =  f        /* places to right of decimal */
	               + p        /* 1 for decimal point if not integer */
	               + d        /* places to left of decimal */
                    + (d == 0) /* 1 for 0 left of decimal */
	               + *sp++    /* 1 if sign needed */
	               ;
		}
          if (e || w > maxw) {
          	w = maxw - 1;
               *(Precb + col) = -6; /* e-notation */
          }
          *wp++ = w + i; /* i = 1 for blank between columns. */
          i = 1; /* 1 for intervening blank except first column */
     }     
}
