/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execspez APL2 V1.0.0 ************************************************
* Called by execspet to perform selective specification, e.g. (Er)#n.  *
* Execspex will have popped right paren from the stack, established a  *
* new execstk element to evaluate the expression contained in parens,  *
* all after confirming it is indeed selective specification format.	 *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+APLCB+TREE
#include "includes.h"
Aplcb execspez(tok, axistok, op, leftorig, left, pnwa)
Apltoken	tok,		/* Token for E in e.g. (Er)#n. */
		axistok,	/* Token for x in e.g. (E[x]r)#n. */
		op;		/* Token for r in e.g. (Er)#n. */
Aplcb	leftorig;	/* Original variable to which to selectively assign. */
Aplcb	left;	/* 0,1,2,... in the shape of leftorig. */
int		*pnwa;	/* Not-Whole-Array indicator. */
{
	Enlist; Execfree; Execspeg; Execspes; Exectok; Integer;
	extern Treelist treehdr;
	extern int aplerr;
	extern int indxorg;
	int i,*ip,j;
	Aplcb out=NULL;

	for (;;) { /* lets me use break */
		if (aplerr) break;
		i = 0;
		out = execspeg(tok, axistok, exectok(left, op->token_offset),
			pnwa); /* Select indices for selective assignment. */
		tok = axistok = NULL;
		out = execspes(out); /* Ensure result in proper form. */
          break;
	}
	execfree(tok); execfree(axistok);
	return(out); /* indicate selective specification handled */
}
