/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execspeu APL2 V1.0.0 ************************************************
* Called by execspex and recursively by itself, to generate an Aplcb	 *
* of shape identical to leftorig, but with all scalars replaced with   *
* integer containing the unique index to the corresponding item in     *
* the recursive ravel of leftorig.                                     *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb execspeu(leftorig, pnix)
Aplcb leftorig;	/* pattern Aplcb. */
int *pnix;		/* next index value to use */
{
	Getcb; Intcopy;
	extern int aplerr;
	Aplcb *icb,*ocb,out,wrk;
	int i,j,o,*op,type;

	type = (leftorig->aplflags & APLAPL) ? APLAPL : APLINT;
     o = leftorig->aplcount;
	out = getcb(NULL, o, type, leftorig->aplrank, NULL);
	if (aplerr) return(NULL);
	if (out->aplrank > 1) /* rank higher than vector? */
		intcopy(out->apldim,leftorig->apldim,out->aplrank,1);
	if (type == APLAPL) {
		icb = leftorig->aplptr.aplapl;
		ocb = out->aplptr.aplapl;
		while (o--)
			*ocb++ = execspeu(*icb++, pnix);
     }
	else {
		op = out->aplptr.aplint;
          while (o--)
			*op++ = (*pnix)++;
     }
	return(out);
}
