/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execspeg APL2 V1.0.0 ************************************************
* Called by execspek, execspet, and execspez to evaluate the left      *
* operand to the assignment.	In the case of selective specification,  *
* this will produce the indices for the selective specification.       *
* Otherwise, it will produce the object to assign to for normal        *
* assignment.                                                          *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+APLCB+TREE
#include "includes.h"
Aplcb execspeg(tok, axistok, op, psw)
Apltoken tok,	   /* Token for E in e.g. (Er)#n	 */
	    axistok, /* Token for x in e.g. (E[x]r)#n */
	    op;	   /* Token for r in e.g. (Er)#n	 */
int	   *psw;	   /* Setting of NOT_WHOLE_ARRAY copied here. */
{
	Errstop; Execexed; Execexek; Execgetp; Lifo;
	extern Treelist treehdr;
	extern int aplerr;
	int i;

	if (op)
		op = lifo(&(treehdr->avlexec->avloprst), op);
	if (axistok)
		axistok = lifo(&(treehdr->avlexec->avlfunst),axistok);
	if (tok)
		tok = lifo(&(treehdr->avlexec->avlfunst),tok);
	i = treehdr->treeflag; /* save */
	execexed(); /* mainline expression evaluation */
	*psw = treehdr->treeflag & NOT_WHOLE_ARRAY;
	treehdr->treeflag = i; /* restore */
	return(errstop(0,NULL,NULL,execgetp(execexek())));
}
