/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execspec APL2 V1.0.0 ************************************************
* Called by execexed to perform specification (left) arrow.			 *
***********************************************************************/
#define INCLUDES APLCHDEF+APLTOKEN+APLCB+TREE
#include "includes.h"
int execspec(ptok)
Apltoken *ptok; /* token for next operator */
{
	Execmona; Execsped; Execspex;
	extern int aplerr;
     extern Treelist treehdr;
	Apltoken op,tok;
	int code,noexit=1;

	tok = *ptok;
	if (aplerr || tok == NULL) return(!noexit);
	code = tok->token_code; /* save for later test */
	execmona(tok); /* do monadic, stack left arrow or other function */
	*ptok = NULL; /* token has been handled */
	if (code != LEFT_ARROW) return(noexit); /* quit if not assignment */
	if (execspex())
     	return(aplerr == 0); /* selective specification */
	if ((noexit != execexee(&tok,&op)) || aplerr) 
     	return(!noexit);
     treehdr->lastfun = LEFT_ARROW;
     return(execsped(tok,op)); /* finish assignment */
}
