/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* execnext APL2 V1.0.0 ************************************************
* Called by dottran, eachtran, and slashtra.                           *
* See execnext.h for a description of function.                        *
***********************************************************************/
#include "execnext.h"
#define INCLUDES APLCB+APLCHDEF+APLTOKEN+STDIO+TREE
#include "includes.h"
int execnext(pfun,pax,parg,varcnt)
Apltoken *pfun; /* w/b = next function token, or null. */
Apltoken *pax;  /* w/b = next axis token, or null.	*/
Apltoken *parg; /* w/b = next argument token, or null. */
int *varcnt;	 /* w/b > 0 if simple variable name list. */
			 /* varcnt is not NULL only when execspex is calling. */
{
	Axistest; Execexee; Execnexs; Pop;
	extern Treelist treehdr;
	extern int aplerr;
	Apltoken op;
	int noexit,savelast,varsw=1;

	*pfun = *parg = *pax = op = NULL; /* initialize */
	if (varcnt != NULL) *varcnt = 0; /* initialize */
	else varsw=0;
	savelast = treehdr->lastfun;
	noexit = execexee(pfun,&op);
	if (*pfun == NULL && op == NULL) return(noexit);
	if (*pfun != NULL) {
		if (op != NULL) {
			aplerr = 999;
			exit(1);
		} /* never happen */
	}
	else varsw = execnexs(pfun,parg,op,varcnt,&noexit,savelast,varsw);
	if (*pfun != NULL) {
		if (noexit && axistest(treehdr->avlexec->avloprst)) {
			varsw = 0; /* not common variable name list */
			*pax = pop(&(treehdr->avlexec->avloprst));
		}
	}
	if (aplerr) noexit=0;
	return(noexit);
}
