/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* execmsg APL2 V1.0.0 *************************************************
* Called by aplload.                                                   *
* Called during EXECUTE processing to print an error message about the *
* current APL statement.                                               *
***********************************************************************/
#define INCLUDES STDIO+APLTOKEN
#include "includes.h"
void execmsg(stmt,stmtlen,offset,msg)
char *stmt; /* APL stmt in error - not necessarily ended with \0 */
int stmtlen; /* length of *stmt */
int offset; /* offset of error */
char *msg; /* error message */
{
	Aplmsg; Aplnewl;
	extern int aplerr;
	int i;

	if (msg == NULL && aplerr != 0)
		msg = aplmsg(aplerr); /* go get message text */
	while (stmtlen--)
		printf("%c",*stmt++); /* print APL stmt */
	aplnewl(); /* Reset to new output line. */
	if (msg != NULL) {
		for (i = offset; i > 0; i--)
			printf(" "); /* print spaces */
		printf("^ %s\n", msg); /* print error message */
	}
}
