/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execjota APL2 V1.0.0 ************************************************
* Called from execjot when the data types of the two operands agree,   *
* and neither data type is character, to do outer product.             *
***********************************************************************/
#define INCLUDES APLTOKEN+APLCHDEF+APLCB+FUNSTRUC
#include "includes.h"
Aplcb execjota(left,rite,type,rscp)
Aplcb left,rite; /* left and right operands */
int type;                 /* data types of left and right operands */
Scalar_dyadics *rscp;     /* function definitions - see aplstruc.h */
{
     Execjotc; Outrprdp;
     Aplcb out=NULL;

     switch(type) {
          case APLCPLX:
               if (NULL != rscp->procs.ppcpx)
               	out = outrprdp(rscp->procs.ppcpx,left,rite);
               if (out != NULL) break;
          case APLINT:
               if (NULL != rscp->procs.ppint)
                    out = outrprdp(rscp->procs.ppint,left,rite);
               if (out != NULL) break;
          case APLNUMB:
               out = execjotc(left,rite,type,type,rscp);
               break;
     } /* end switch */
     return(out);
}
