/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execjot2 APL2 V1.0.0 ************************************************
* Called by dottran.                                                   *
* Derived function routine to handle outer product when the function   *
* is not scalar dyadic.  deriv_func in the aplderiv structure is set   *
* to execjot2 by dottran, based on the type of function f as in J.f.   *
***********************************************************************/
#define INCLUDES APLCHDEF+FUNSTRUC+APLDERIV+APLCB
#include "includes.h"
Aplcb execjot2(dp,left,rite)
Aplderiv dp; /* function describing derived function */
Aplcb left,rite; /* arguments */
{
     Eachdyag; Errstop; Getcb; Intcopy; Matchok; Perm;
     extern int aplerr;
     Aplcb *lp,*op,out=NULL,*rp;
     int datacnt,i,*ip,j,rank;

	if (!matchok(&left,&rite,APLAPL))
     	return(NULL);
	datacnt = left->aplcount * rite->aplcount;
	rank = left->aplrank + rite->aplrank;
	out=getcb(NULL, datacnt, APLAPL + APLTEMP, rank, NULL);
	if (out != NULL && rank > 1) { /* set dimensions */
		ip=intcopy(out->apldim, left->apldim, left->aplrank, 1);
		ip=intcopy(ip, rite->apldim, rite->aplrank, 1);
	}
	if (datacnt) {
		op = out->aplptr.aplapl;
		lp = left->aplptr.aplapl;
		i = left->aplcount;
		while(0 < i--) {
			rp = rite->aplptr.aplapl;
			j = rite->aplcount;
			while(0 < j--)
               	*op++ = perm(
					eachdyag(dp,&(dp->deriv_rite),*lp,*rp++));
			lp++;
		}
     }
     return(errstop(0,left,rite,out));
}
